/*
 * candidate protocol
 *
 * $Id: candidate.c,v 1.5 2002/03/26 10:46:59 taka Exp $
 */
#include <stdio.h>
#include <stdlib.h>

#include "aime.h"
#include "queue.h"
#include "control.h"
#include "bufsize.h"
#include "candidate.h"


struct candidate
{
	int id;

	SLIST_ENTRY (candidate) entry;
};
static SLIST_HEAD (,candidate) candlist = SLIST_HEAD_INITIALIZER (0);

static void
add_to_list (struct candidate* can)
{
	int maxid = -1;
	struct candidate* c;

	SLIST_FOREACH (c, &candlist, entry) {
		if (c->id > maxid) maxid = c->id;
	}

	can->id = maxid + 1;
	SLIST_INSERT_HEAD (&candlist, can, entry);
}

struct candidate*
candidate_allocate (void)
{
	struct candidate* can;

	can = malloc (sizeof (struct candidate));
	if (can == NULL) {
		NOMEMORY ("can't malloc candidate");
		return NULL;
	}

	add_to_list (can);
	
	return can;
}

void
candidate_destroy (struct candidate* can)
{
	if (can) {
		candidate_stop (can);
		SLIST_REMOVE (&candlist, can, candidate, entry);
		free (can);
	}
}

static char buffer[CONTROL_BUFFER_LINE_SIZE + 1];
void
candidate_start (struct candidate* can, int num)
{
	snprintf (buffer, sizeof (buffer),
		  "candidate %d start %d", can->id, num);
	control_write (buffer);
}
void
candidate_candidate (struct candidate* can, int index, char* cand)
{
	const char* def = "";

	snprintf (buffer, sizeof (buffer),
		  "candidate %d cand %d %s", can->id, index,
		  cand == NULL ? def : cand);
	control_write (buffer);
}
void
candidate_coordinate (struct candidate* can, int x, int y)
{
	snprintf (buffer, sizeof (buffer),
		  "candidate %d window %d %d",  can->id, x, y);
	control_write (buffer);
}
void
candidate_stop (struct candidate* can)
{
	snprintf (buffer, sizeof (buffer),
		  "candidate %d stop", can->id);
	control_write (buffer);
}
void
candidate_select (struct candidate* can, int number)
{
	snprintf (buffer, sizeof (buffer),
		  "candidate %d select %d", can->id, number);
	control_write (buffer);
}
