/*
 * conversion
 *
 * $Id: conversion.c,v 1.54 2002/03/26 10:46:59 taka Exp $
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#include "aime.h"
#include "queue.h"
#include "ximpacket.h"
#include "ximic.h"
#include "conversion.h"
#include "pewindow.h"
#include "imconnection.h"
#include "charcode.h"
#include "hotkeys.h"
#include "control.h"
#include "candidate.h"

#ifdef USE_ANTHY
#include <anthy/anthy.h>
#include <anthy/input.h>
#endif

#define HAVE_AI_RETURN 0

enum
{
	INPUT_STATUS_OFF,		/* ime is off */
	INPUT_STATUS_NONE,		/* there are no input */
	INPUT_STATUS_EDIT,		/* there are some input */
	INPUT_STATUS_CONVERSION,	/* under conversion */
	INPUT_STATUS_NUM,
};

#if 0
static struct rk_map* rk_maps[INPUT_MODE_NUM];
#endif

#define BUFFER_UNIT_SIZE (32)
struct conversion
{
	char*	ctext;
	char*	ctextsrc;		/* convert to ctext */

	int	mode;

	int	status;

	TAILQ_HEAD (,conversion_string) cstring;

	struct ximic*	xic;	/* where do I belong to? */

#ifdef USE_ANTHY
	struct candidate* can;

	struct anthy_input_context* aic;
	struct aisegments* cursor_seg;
#endif /* USE_ANTHY */
};
static void
init_cstring (struct conversion* conv)
{
	struct conversion_string* cs;

	cs = TAILQ_FIRST (&conv->cstring);
	while (cs) {
		struct conversion_string* n = TAILQ_NEXT (cs, entry);
		TAILQ_REMOVE (&conv->cstring, cs, entry);
		if (cs->buf) free (cs->buf);
		free (cs);
		cs = n;
	}
	TAILQ_INIT (&conv->cstring);
}
#ifdef USE_ANTHY
static struct anthy_input_config* config;
static void
ai_update_preedit (struct conversion* conv, struct anthy_input_preedit* aipre)
{
	int makeaipre = 0;
	struct anthy_input_segment* seg;

	if (!aipre) {
		aipre = anthy_input_get_preedit (conv->aic);
		makeaipre = 1;
	}

	/* initialize conv->cstring} */
	init_cstring (conv);

	/* make up conv->cstring */

	/* none */
	if (aipre->state == ANTHY_INPUT_ST_EDIT) {
		/* need to determine cursor position */
		int len = 0;
		int cursorpos = -1;
		struct conversion_string* cstr;
		char* s;

		cstr = malloc (sizeof (*cstr));
		if (!cstr) {
			NOMEMORY ("can't allocate aisegments");
			goto DONE;
		}
		
		/* 1st, determine string length and cursor pos */
		for (seg = aipre->segment; seg; seg = seg->next) {
			if (seg->flag & ANTHY_INPUT_SF_CURSOR) {
				cursorpos = len;
			}
			if (!seg->str) continue;
			len += strlen (seg->str);
		}

		/* 2nd, allocate memory */
		cstr->buf = malloc (sizeof (char) * (len + 1));
		if (!cstr->buf) {
			NOMEMORY ("can't allocate buffer for preedit none");
			free (cstr);
			goto DONE;
		}

		s = cstr->buf;
		/* 3rd, fill and determine cursor position */
		for (seg = aipre->segment; seg; seg = seg->next) {
			int slen;

			if (!seg->str) continue;
			slen = strlen (seg->str);
			memcpy (s, seg->str, slen);
			s += slen;
		}
		*s = '\0';

		cstr->cursor = cursorpos;
		cstr->stat = 0;

		TAILQ_INSERT_TAIL (&conv->cstring, cstr, entry);
		goto DONE;
	}

	/* else */
	for (seg = aipre->segment; seg; seg = seg->next) {
		struct conversion_string* cstr;

		if (!seg->str) continue;

		cstr = malloc (sizeof (*cstr));
		if (cstr == NULL) {
			NOMEMORY ("can't allocate buffer for preedit");
			continue;
		}

		cstr->buf = strdup (seg->str);
		if (!cstr->buf) {
			NOMEMORY ("can't allocate buffer for preedit");
			free (cstr);
			continue;
		}

		cstr->cursor = -1;
		if (seg->flag & ANTHY_INPUT_SF_CURSOR) {
			cstr->stat = CONV_STAT_REVERSE | CONV_STAT_UNDERLINE;
		} else {
			cstr->stat = CONV_STAT_UNDERLINE;
		}

		TAILQ_INSERT_TAIL (&conv->cstring, cstr, entry);
	}

 DONE:
	if (makeaipre) anthy_input_free_preedit (aipre);
}
#endif

#ifdef USE_ANTHY
static void
ai_cand_show_next (struct conversion* conv, struct anthy_input_preedit* aipre)
{
	struct anthy_input_segment* curseg;

	curseg = aipre->cur_segment;

	if (!(curseg->flag & ANTHY_INPUT_SF_ENUM)) return;
	if (conv->can == NULL) {
		int i;
		int x,y;

		conv->can = candidate_allocate ();
		if (!conv->can) return;

		candidate_start (conv->can, curseg->nr_cand);
		for (i = 0; i < curseg->nr_cand; i++) {
			struct anthy_input_segment* aiseg;
			aiseg = anthy_input_get_candidate (conv->aic, i);
			candidate_candidate (conv->can, i, aiseg->str);
		}

		/* set coordinate */
		pewindow_get_cursor (conv->xic->pew, &x, &y);
		candidate_coordinate (conv->can, x, y);
	}
	candidate_select (conv->can, curseg->cand_no);
}
static void
ai_cand_show_end (struct conversion* conv)
{
	if (conv->can) {
		candidate_destroy (conv->can);
		conv->can = NULL;
	}
}
#endif /* USE_ANTHY_PENDING */

static void
st_init_conv_status (struct conversion* conv)
{
	init_cstring (conv);
	conv->status = INPUT_STATUS_NONE;
}
static int
st_commit (struct conversion* conv)
{
#ifdef USE_ANTHY
	struct anthy_input_preedit* aipre;
	int status;

	anthy_input_commit (conv->aic);

	aipre = anthy_input_get_preedit (conv->aic);

	if (aipre->commit) {
		if (conv->ctextsrc) free (conv->ctextsrc);
		conv->ctextsrc = strdup (aipre->commit);

		status = CV_SEND_COMMIT;
	} else {
		status = CV_SEND_KEY_EVENT;
	}

	st_init_conv_status (conv);
	return status;
#endif
	return CV_SEND_KEY_EVENT;
}
static void
delete_all_buffer (struct conversion* conv)
{
	if (conv->ctextsrc) {
		conv->ctextsrc = NULL;
		free (conv->ctextsrc);
	}
	st_init_conv_status (conv);
}

static int
st_conversion_commit (struct conversion* conv)
{
#ifdef USE_ANTHY
	int ret;

	ret = st_commit (conv);
	ai_cand_show_end (conv);
	return ret;
#endif /* USE_ANTHY */

	return CV_DO_NOTHING;
}
static int
st_ascii (struct conversion* conv)
{
#ifdef USE_ANTHY
	anthy_input_map_select (conv->aic, ANTHY_INPUT_MAP_ALPHABET);
#endif /* USE_ANTHY */
	conv->mode = INPUT_MODE_H_ASCII;
	control_mode (conv->mode, conv->status);
	return CV_DO_NOTHING;
}
static int
st_hiragana (struct conversion* conv)
{
#ifdef USE_ANTHY
	anthy_input_map_select (conv->aic, ANTHY_INPUT_MAP_HIRAGANA);
#endif /* USE_ANTHY */
	conv->mode = INPUT_MODE_HIRAGANA;
	control_mode (conv->mode, conv->status);
	return CV_DO_NOTHING;
}
static int
st_katakana (struct conversion* conv)
{
#ifdef USE_ANTHY
	anthy_input_map_select (conv->aic, ANTHY_INPUT_MAP_KATAKANA);
#endif /* USE_ANTHY */
	conv->mode = INPUT_MODE_KATAKANA;
	control_mode (conv->mode, conv->status);
	return CV_DO_NOTHING;
}
static int
st_zenkaku_ascii (struct conversion* conv)
{
#ifdef USE_ANTHY
	anthy_input_map_select (conv->aic, ANTHY_INPUT_MAP_WALPHABET);
#endif /* USE_ANTHY */
	conv->mode = INPUT_MODE_Z_ASCII;
	control_mode (conv->mode, conv->status);
	return CV_DO_NOTHING;
}
static int
st_kana (struct conversion* conv)
{
	/* XXX */
	conv->mode = INPUT_MODE_KANA;
	control_mode (conv->mode, conv->status);
	return CV_DO_NOTHING;
}
#ifdef USE_ANTHY
static int
convert_aipre_state (int state)
{
	switch (state) {
	case ANTHY_INPUT_ST_NONE:
		return INPUT_STATUS_NONE;
	case ANTHY_INPUT_ST_EDIT:
		return INPUT_STATUS_EDIT;
	case ANTHY_INPUT_ST_CONV:
	case ANTHY_INPUT_ST_CSEG:
		return INPUT_STATUS_CONVERSION;
	default:
		return -1;
	}
}
static void
update_preedit_and_status (struct conversion* conv)
{
	struct anthy_input_preedit* aipre;

	aipre = anthy_input_get_preedit (conv->aic);
	ai_update_preedit (conv, aipre);
	conv->status = convert_aipre_state (aipre->state);
	anthy_input_free_preedit (aipre);
}	
#endif /* USE_ANTHY */
static int
st_start_conversion (struct conversion* conv)
{
#ifdef USE_ANTHY
	anthy_input_space (conv->aic);
	update_preedit_and_status (conv);
#endif /* USE_ANTHY */

	return CV_DO_NOTHING;
}
static int
st_input_cancel (struct conversion* conv)
{
#ifdef USE_ANTHY
	anthy_input_quit (conv->aic);
	update_preedit_and_status (conv);
#endif
	return CV_DO_NOTHING;
}
static int
st_input_backspace (struct conversion* conv)
{
#ifdef USE_ANTHY
#if HAVE_AI_RETURN
	int ret;

 	ret = anthy_input_erase_prev (conv->aic);
	update_preedit_and_status (conv);
	if (ret == -1) {
		return CV_SEND_KEY_EVENT;
	}
#else
	anthy_input_erase_prev (conv->aic);
	update_preedit_and_status (conv);
#endif
#endif
	return CV_DO_NOTHING;
}
static int
st_input_delete (struct conversion* conv)
{
#ifdef USE_ANTHY
#if HAVE_AI_RETURN
	int ret;

 	ret = anthy_input_erase_next (conv->aic);
	update_preedit_and_status (conv);
	if (ret == -1) {
		return CV_SEND_KEY_EVENT;
	}
#else
	anthy_input_erase_next (conv->aic);
	update_preedit_and_status (conv);
#endif
#endif
	return CV_DO_NOTHING;
}
static int
st_nextprev_candidate (struct conversion* conv, int change)
{
#ifdef USE_ANTHY
	struct anthy_input_preedit* aipre;

	if (change == 1) {
		anthy_input_next_candidate (conv->aic);
	} else {
		anthy_input_prev_candidate (conv->aic);
	}
	aipre = anthy_input_get_preedit (conv->aic);
	ai_update_preedit (conv, aipre);
	ai_cand_show_next (conv, aipre);
	conv->status = convert_aipre_state (aipre->state);
	anthy_input_free_preedit (aipre);

#endif /* USE_ANTHY */
	return CV_DO_NOTHING;
}
static int
st_next_candidate (struct conversion* conv)
{
	return st_nextprev_candidate (conv, 1);
}
static int
st_prev_candidate (struct conversion* conv)
{
	return st_nextprev_candidate (conv, -1);
}
static int
st_cancel_conversion (struct conversion* conv)
{
#ifdef USE_ANTHY
	anthy_input_quit (conv->aic);
	update_preedit_and_status (conv);
#endif
	return CV_DO_NOTHING;
}
static int
st_do_nothing (struct conversion* conv)
{
	/* do nothing */
	return CV_DO_NOTHING;
}
static void
push_key_internal (struct conversion* conv, int c)
{
#ifdef USE_ANTHY
	anthy_input_key (conv->aic, c);
	update_preedit_and_status (conv);
#endif
}
static int
st_none_key (struct conversion* conv, int c)
{
	push_key_internal (conv, c);
	return CV_DO_NOTHING;
}
static int
st_edit_key (struct conversion* conv, int c)
{
	push_key_internal (conv, c);
	return CV_DO_NOTHING;
}
static int
st_conversion_key (struct conversion* conv, int c)
{
	st_conversion_commit (conv);
	push_key_internal (conv, c);

	return CV_SEND_COMMIT;
}
static int
st_on (struct conversion* conv)
{
#ifdef USE_ANTHY
	st_hiragana (conv);
#endif
	conv->status = INPUT_STATUS_NONE;
	pewindow_map (conv->xic->pew);
	control_mode (conv->mode, conv->status);
	return CV_DO_NOTHING;
}
static int
st_off (struct conversion* conv)
{
	delete_all_buffer (conv);
	conv->status = INPUT_STATUS_OFF;
 	pewindow_unmap (conv->xic->pew);
#ifdef USE_ANTHY
	ai_cand_show_end (conv);
#endif
	control_mode (conv->mode, conv->status);
	return CV_DO_NOTHING;
}

#ifdef USE_ANTHY
static int
ai_move (struct anthy_input_context* aic, int type)
{
	int ret = 0;
	if (type == -1) {
#if HAVE_AI_RETURN
		ret = 
#else
			anthy_input_move (aic, -1);
#endif
	} else if (type == 1) {
#if HAVE_AI_RETURN
		ret = 
#else
			anthy_input_move (aic, 1);
#endif
	} else if (type == -2) {
#if HAVE_AI_RETURN
		ret = 
#else
			anthy_input_beginning_of_line (aic);
#endif
	} else if (type == 2) {
#if HAVE_AI_RETURN
		ret = 
#else
			anthy_input_end_of_line (aic);
#endif
	}
	return ret;
}
#endif
static int
st_move (struct conversion* conv, int p)
{
#ifdef USE_ANTHY
	int ret;

	ret = ai_move (conv->aic, p);
	update_preedit_and_status (conv);
	ai_cand_show_end (conv);

	if (ret == -1) return CV_SEND_KEY_EVENT;
	else           return CV_DO_NOTHING;
#endif
	return CV_DO_NOTHING;
}
static int
st_cursor_left (struct conversion* conv)
{
	return st_move (conv, -1);
}
static int
st_cursor_right (struct conversion* conv)
{
	return st_move (conv, 1);
}
static int
st_phrase_left (struct conversion* conv)
{
	return st_move (conv, -1);
}
static int
st_phrase_right (struct conversion* conv)
{
	return st_move (conv, 1);
}

static int
st_cursor_first (struct conversion* conv)
{
	return st_move (conv, -2);
}
static int
st_cursor_last (struct conversion* conv)
{
	return st_move (conv, 2);
}
static int
st_phrase_first (struct conversion* conv)
{
	return st_move (conv, -2);
}
static int
st_phrase_last (struct conversion* conv)
{
	return st_move (conv, 2);
}
static void
ai_phrase_growshrink (struct conversion* conv, int p)
{
#ifdef USE_ANTHY
	anthy_input_resize (conv->aic, p);
	update_preedit_and_status (conv);
	ai_cand_show_end (conv);
#endif /* USE_ANTHY */
}
static int
st_phrase_grow (struct conversion* conv)
{
	ai_phrase_growshrink (conv, 1);
	return CV_DO_NOTHING;
}
static int
st_phrase_shrink (struct conversion* conv)
{
	ai_phrase_growshrink (conv, -1);
	return CV_DO_NOTHING;
}

static struct conversion_state_transition
{
	int (*func[HOT_KEYS_TYPE_NUM]) (struct conversion* conv);
	int (*keyfunc) (struct conversion* conv, int c);
}state_trans_functions[INPUT_STATUS_NUM]=
{
	/* INPUT_STATUS_OFF */
	{
		/* ASCII, HIRAGANA, KATAKANA, ZENKAKU_ASCII, KANA, HENKAN,
		   CANCEL, BACKSPACE, DELETE, COMMIT, ON, LEFT, RIGHT, FIRST,
		   LAST, GROW, SHRINK, ON_OR_COMMIT, CAND_NEXT, CAND_PREV */
		{NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, st_on, NULL, NULL, NULL,
		 NULL, NULL, NULL, st_on, NULL, NULL,},
		NULL,
	},

	/* INPUT_STATUS_NONE */
	{
		/* ASCII, HIRAGANA, KATAKANA, ZENKAKU_ASCII,
		   KANA, HENKAN, CANCEL, BACKSPACE, DELETE, COMMIT, ON,
		   LEFT, RIGHT, FIRST, LAST, GROW, SHRINK, ON_OR_COMMIT,
		   CAND_NEXT, CAND_PREV */
		{st_ascii, st_hiragana, st_katakana, st_zenkaku_ascii,
		 st_kana, NULL, NULL, NULL, NULL, NULL, st_off,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,},
		st_none_key,
	},

	/* INPUT_STATUS_EDIT */
	{
		/* ASCII, HIRAGANA, KATAKANA, ZENKAKU_ASCII,
		   KANA, HENKAN, CANCEL,
		   BACKSPACE, DELETE, COMMIT, ON,
		   LEFT, RIGHT,
		   FIRST, LAST, GROW, SHRINK, ON_OR_COMMIT
		   CAND_NEXT, CAND_PREV */
		{st_ascii, st_hiragana, st_katakana, st_zenkaku_ascii,
		 st_kana, st_start_conversion, st_input_cancel,
		 st_input_backspace, st_input_delete, st_commit, st_off,
		 st_cursor_left, st_cursor_right,
		 st_cursor_first, st_cursor_last, NULL, NULL, st_commit,
		 NULL, NULL},
		st_edit_key,
	},

	/* INPUT_STATUS_CONVERSION */
	{
		/* ASCII, HIRAGANA, KATAKANA, ZENKAKU_ASCII,
		   KANA, HENKAN, CANCEL,
		   BACKSPACE, DELETE, COMMIT, ON,
		   LEFT, RIGHT,
		   FIRST, LAST,
		   GROW, SHRINK, ON_OR_COMMIT,
		   CAND_NEXT, CAND_PREV */
		{st_ascii, st_hiragana, st_katakana, st_zenkaku_ascii,
		 st_kana, st_next_candidate, st_cancel_conversion,
		 st_do_nothing, NULL, st_conversion_commit, st_off,
		 st_phrase_left, st_phrase_right,
		 st_phrase_first, st_phrase_last,
		 st_phrase_grow, st_phrase_shrink, st_conversion_commit,
		 st_next_candidate, st_prev_candidate,},
		st_conversion_key,
	},
};

static int
is_ksym_x_modifier (KeySym k)
{
	if (IsModifierKey (k)) return 1;
	else                   return 0;
}
static int
is_state_x_shift_only (int state)
{
	if (state == 0 || state == ShiftMask) return 1;
	else                                  return 0;
}
static struct hotkeys* hkeys;
#if 0
static void
create_rkmap (void)
{
	struct rk_rule rk_rule_comma_period[3] =
	{
		{",", NULL, NULL},
		{".", NULL, NULL},
		{NULL, NULL, NULL},
	};
	struct rk_rule* merged;
	int i;

	for (i = 0; i < INPUT_MODE_NUM; i++) {
		if (rk_maps[i]) {
			rk_map_free (rk_maps[i]);
			rk_maps[i] = NULL;
		}
	}

	/* set config */
	rk_rule_comma_period[0].rhs = RKMAP_WIDE_COMMA_JP;
	rk_rule_comma_period[1].rhs = RKMAP_WIDE_PERIOD_JP;

	rk_maps[INPUT_MODE_H_ASCII] = rk_map_create (rk_rule_h_alphabet);
	rk_maps[INPUT_MODE_Z_ASCII] = rk_map_create (rk_rule_z_alphabet);

	merged = rk_merge_rules (rk_rule_hiragana, rk_rule_comma_period);
	rk_maps[INPUT_MODE_HIRAGANA] = rk_map_create (merged);
	rk_rules_free (merged);

	merged = rk_merge_rules (rk_rule_katakana, rk_rule_comma_period);
	rk_maps[INPUT_MODE_KATAKANA] = rk_map_create (merged);
	rk_rules_free (merged);

}
#endif
void
conversion_hotkeys_add (int hktype, int state, KeySym ksym)
{
	hotkeys_add_entry (hkeys, hktype, state, ksym);
}
int
conversion_module_initialize (void)
{
#if 0
	create_rkmap ();
#endif
	
	hkeys = hotkeys_allocate ();
	if (hkeys == NULL) return -1;

#ifdef USE_ANTHY
	{
		int ret;

		ret = anthy_input_init ();
		if (ret == -1) {
			fprintf (stderr, "can't initialize anthy library.\n");
			return -1;
		}
		config = anthy_input_create_config ();
	}
#endif

	return 0;
}

static void
conversion_freectext (struct conversion* conv)
{
	if (!conv) return;

	if (conv->ctext) free (conv->ctext);
	conv->ctext = NULL;
	if (conv->ctextsrc) free (conv->ctextsrc);
	conv->ctextsrc = NULL;
}

void
conversion_destroy (struct conversion* conv)
{
	if (!conv) return;

#ifdef USE_ANTHY
	anthy_input_free_context (conv->aic);
	candidate_destroy (conv->can);
#endif /* USE_ANTHY */
	conversion_freectext (conv);
	free (conv);
}
struct conversion*
conversion_allocate (struct ximic* xic)
{
	struct conversion* c;

	c = malloc (sizeof (*c));
	if (c == NULL) {
		NOMEMORY ("can't allocate conversion");
		return NULL;
	}
	memset (c, 0, sizeof (*c));
	c->mode = INPUT_MODE_H_ASCII;
	c->xic  = xic;

#ifdef USE_ANTHY
	c->aic = anthy_input_create_context (config);
#endif
	control_mode (c->mode, 0);
	
	return c;
}
struct ximic*
conversion_get_xic (struct conversion* conv)
{
	return conv->xic;
}

static char*
convert2ctext (struct conversion* conv)
{
	int len;
	if (conv->ctext) return conv->ctext;
	if (!conv->ctextsrc) return NULL;

	len = eucjp2ctext (conv->ctextsrc, NULL);
	conv->ctext = malloc (sizeof (char) * (len + 1));
	if (conv->ctext == NULL) {
		NOMEMORY ("can't allocate compound text");
		return NULL;
	}

	eucjp2ctext (conv->ctextsrc, conv->ctext);
	conv->ctext[len] = '\0';
	return conv->ctext;
}

char*
conversion_get_commited_ctext (struct conversion* conv)
{
	return convert2ctext (conv);
}

#ifdef USE_ANTHY
static int
convert_preedit2ctextsrc (struct conversion* conv)
{
	int len = 0;
	struct conversion_string* cstr;
	char* s;

	TAILQ_FOREACH (cstr, &conv->cstring, entry) {
		len += strlen (cstr->buf);
	}
	conv->ctextsrc = malloc (sizeof (char) * (len + 1));
	if (!conv->ctextsrc) {
		NOMEMORY ("can't convert preedit to ctextsrc");
		return -1;
	}

	s = conv->ctextsrc;
	TAILQ_FOREACH (cstr, &conv->cstring, entry) {
		int l = strlen (cstr->buf);
		memcpy (s, cstr->buf, l);
		s += l;
	}
	*s = '\0';
	return 0;
}
#endif
char*
conversion_get_current_ctext (struct conversion* conv)
{
	int ret = -1;

	if (conv->ctextsrc) free (conv->ctextsrc);
#ifdef USE_ANTHY
	ret = convert_preedit2ctextsrc (conv);
#endif
	if (ret == -1) return NULL;
	return convert2ctext (conv);
}
void
conversion_free_commited_ctext (struct conversion* conv)
{
	conversion_freectext (conv);
}
void
conversion_free_current_ctext (struct conversion* conv)
{
	conversion_freectext (conv);
}

struct conversion_string*
conversion_get_conversion_string (struct conversion* conv)
{
	return TAILQ_FIRST (&conv->cstring);
}

int
conversion_reset (struct conversion* conv)
{
#if 1
	st_init_conv_status (conv);
	conversion_freectext (conv);
#ifdef USE_ANTHY
	anthy_input_quit (conv->aic);
	anthy_input_quit (conv->aic);
#endif /* USE_ANTHY */
	conv->status = INPUT_STATUS_NONE;
	pewindow_clear (conv->xic->pew);
#endif
	return 0;
}

void
conversion_focus_changed (struct conversion* conv, int val)
{
	pewindow_focus_changed (conv->xic->pew, val);
	if (val) control_mode (conv->mode, conv->status);
}
int
conversion_show_preedit (struct conversion* conv)
{
	if (conv->status == INPUT_STATUS_OFF) return 0;
	else                                  return 1;
}

static int
deal_hotkey (struct conversion* conv, int hktype)
{
	int s = conv->status;
	if (state_trans_functions[s].func[hktype]) {
		return state_trans_functions[s].func[hktype] (conv);
	} else {
		return CV_SEND_KEY_EVENT;
	}
}
static int
transit_state (struct conversion* conv, int state, KeySym ksym)
{
	int ret;

	if (is_ksym_x_modifier (ksym)) return CV_SEND_KEY_EVENT;

	ret = hotkeys_get_type (hkeys, state, ksym);

	if (ret != -1) return deal_hotkey (conv, ret);

	/* not hotkey */
	if (state_trans_functions[conv->status].keyfunc) {
		/* printable and shift only state is permitted */
		if ((ksym < 0x20 || ksym > 0x7E)
		    || !is_state_x_shift_only (state)) {
			return CV_SEND_KEY_EVENT;
		}
		
		return state_trans_functions[conv->status].keyfunc (conv,
								    ksym);
	} else {
		return CV_SEND_KEY_EVENT;
	}
}

static void
do_pewindow (int type, struct conversion* conv)
{
	switch (type) {
	case CV_SEND_COMMIT:
		break;
	case CV_SEND_KEY_EVENT:
		break;
	default:
		pewindow_clear (conv->xic->pew);
		pewindow_update (conv->xic->pew);
		break;
	}
}
int
conversion_emulate_hotkey (struct conversion* conv, int hkey)
{
	int ret;
	if (hkey < 0 || hkey >= HOT_KEYS_TYPE_NUM) return -1;

	ret = deal_hotkey (conv, hkey);
	do_pewindow (ret, conv);
	return 0;
}
int
conversion_pushkey (struct conversion* conv, XKeyEvent* xev)
{
	char buffer[10];
	KeySym ksym;
	int ret;

	XLookupString (xev, buffer, sizeof (buffer), &ksym, NULL);

	ret = transit_state (conv, xev->state, ksym);
	do_pewindow (ret, conv);
	return ret;
}
