/*
 * header file of conversion.c
 *
 * $Id: conversion.h,v 1.17 2002/02/09 18:29:27 taka Exp $
 */
#ifndef CONVERSION_H_INCLUDED
#define CONVERSION_H_INCLUDED
#include "queue.h"

/* used by over-the-spot style */
enum
{
	CONV_OVERSPOT_POS_START = 1 << 0,
	CONV_OVERSPOT_POS_END   = 1 << 1,
};
struct conversion_overspot
{
	char* start;
	int len;
	int x,y,w;
	int windex;
	int pos;	/* 1 means first, 2 means last */

	/* for cursor */
	int curx,cury;
	char* curstr;
	int curlen;

	SIMPLEQ_ENTRY (conversion_overspot) entry;
};
enum
{
	CONV_STAT_UNDERLINE = 1 << 0,
	CONV_STAT_REVERSE   = 1 << 1,
	CONV_STAT_HILIGHT   = 1 << 2,
};
struct conversion_string
{
	char*	buf;
	int	stat;
	int	cursor;		/* byte */

	SIMPLEQ_HEAD (,conversion_overspot) head;

	TAILQ_ENTRY (conversion_string) entry;
};

struct pewindow;
int
conversion_module_initialize (void);
void
conversion_hotkeys_add (int hktype, int state, KeySym ksym);
void
conversion_destroy (struct conversion* conv);
struct conversion*
conversion_allocate (struct ximic* xic);

struct ximic*
conversion_get_xic (struct conversion* conv);

int
conversion_pushkey (struct conversion* conv, XKeyEvent* xev);
int
conversion_emulate_hotkey (struct conversion* conv, int hkey);

char*
conversion_get_commited_ctext (struct conversion* conv);
void
conversion_free_commited_ctext (struct conversion* conv);
char*
conversion_get_current_ctext (struct conversion* conv);
void
conversion_free_current_ctext (struct conversion* conv);

struct conversion_string*
conversion_get_conversion_string (struct conversion* conv);
int
conversion_reset (struct conversion* conv);
void
conversion_focus_changed (struct conversion* conv, int val);
int
conversion_show_preedit (struct conversion* conv);

/* used as conversion_pushkey return values */
enum
{
	CV_DO_NOTHING,
	CV_SEND_KEY_EVENT,
	CV_SEND_COMMIT,
};

#endif  /* CONVERSION_H_INCLUDED */
