#!/bin/sh
AIPO_HOME=default_folder
AIPO_POSTGRES_USER=default_user
s_port_num=default_server_port
port_num=default_db_port
aipo_version=Aipo_Version

date_dir=`date +"%Y%m%d%H%M"`
count=0
tmp_dir=$date_dir
while [ $count -lt 100 ]; do
	test -d $tmp_dir
	tmp_str=$?
	if [ $tmp_str = 0 ]; then
		tmp_dir="$date_dir"$count
	else
		break
	fi
	let count=`expr $count + 1`
	if [ $count -ge 99 ]; then
		echo "ディレクトリ生成中にエラーが発生しました"
		exit 0
	fi
done
bg_dir=$date_dir$count
mkdir -p $AIPO_HOME/backup/$bg_dir
wait
chmod 757 $AIPO_HOME/backup/$bg_dir

#tomcat停止
$AIPO_HOME/jre/bin/java -Xms1m -Xmx1m -Djava.endorsed.dirs=$AIPO_HOME/tomcat/common/endorsed -classpath $AIPO_HOME/tomcat/bin/bootstrap.jar -Dcatalina.base=$AIPO_HOME/tomcat -Dcatalina.home=$AIPO_HOME/tomcat org.apache.catalina.startup.Bootstrap stop &> $AIPO_HOME/tomcat/logs/shutdown.log
wait

#データベースのバックアップ
sudo -u $AIPO_POSTGRES_USER $AIPO_HOME/postgres/bin/pg_dump -c -b -o -Fp -U $AIPO_POSTGRES_USER -p $port_num -f $AIPO_HOME/backup/$bg_dir/aipo_db_sql.dump org001 > $AIPO_HOME/backup/dump1.log 2>&1
sudo -u $AIPO_POSTGRES_USER $AIPO_HOME/postgres/bin/pg_dump -c -b -o -Fc -U $AIPO_POSTGRES_USER -p $port_num -f $AIPO_HOME/backup/$bg_dir/aipo_db.dump org001 > $AIPO_HOME/backup/dump2.log 2>&1
#データフォルダのバックアップ
${AIPO_HOME}/jre/bin/java -Xms2m -Xmx64m -cp .:${AIPO_HOME}/bin com.aimluck.eip.tools.DataBackup -backup src=${AIPO_HOME} dest=${AIPO_HOME}/backup version=${aipo_version} foldername=$bg_dir

if [ $? -ne 0 ]; then
  echo "Backup Error";
  rm -rf $AIPO_HOME/backup/$bg_dir
fi

#tomcat再開
$AIPO_HOME/jre/bin/java -Xms128m -Xmx256m -XX:NewSize=64m -XX:MaxNewSize=64m -Djava.endorsed.dirs=$AIPO_HOME/tomcat/common/endorsed -classpath $AIPO_HOME/tomcat/bin/bootstrap.jar -Dcatalina.base=$AIPO_HOME/tomcat -Dcatalina.home=$AIPO_HOME/tomcat -Djava.awt.headless=true org.apache.catalina.startup.Bootstrap start &> $AIPO_HOME/tomcat/logs/startup.log &
