package org.apache.jetspeed.om.dbregistry;


import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.DateKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.StringKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Transaction;

  
  
/**
 * This class was autogenerated by Torque on:
 *
 * [Thu Jun 10 23:17:32 JST 2004]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to PortletCategory
 */
public abstract class BasePortletCategory extends BaseObject
{
    /** The Peer class */
    private static final PortletCategoryPeer peer =
        new PortletCategoryPeer();

      
    /** The value for the id field */
    private long id;
      
    /** The value for the name field */
    private String name;
      
    /** The value for the group field */
    private String group;
      
    /** The value for the owner field */
    private long owner;
  
  
    /**
     * Get the Id
     * @return long
     */
    public long getId()
    {
        return id;
    }

                        
    /**
     * Set the value of Id
     */
    public void setId(long v ) 
    {
    
                  if (this.id != v)
              {
            this.id = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Name
     * @return String
     */
    public String getName()
    {
        return name;
    }

                        
    /**
     * Set the value of Name
     */
    public void setName(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.name, v))
              {
            this.name = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Group
     * @return String
     */
    public String getGroup()
    {
        return group;
    }

                        
    /**
     * Set the value of Group
     */
    public void setGroup(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.group, v))
              {
            this.group = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Owner
     * @return long
     */
    public long getOwner()
    {
        return owner;
    }

                              
    /**
     * Set the value of Owner
     */
    public void setOwner(long v ) throws TorqueException
    {
    
                  if (this.owner != v)
              {
            this.owner = v;
            setModified(true);
        }
    
                                  
                if (aPortletDbEntry != null && !(aPortletDbEntry.getId() == v))
                {
            aPortletDbEntry = null;
        }
      
              }

  
      
        
                  
        private PortletDbEntry aPortletDbEntry;

    /**
     * Declares an association between this object and a PortletDbEntry object
     *
     * @param PortletDbEntry v
     */
    public void setPortletDbEntry(PortletDbEntry v) throws TorqueException
    {
            if (v == null)
        {
                  setOwner(0);
              }
        else
        {
            setOwner(v.getId());
        }
            aPortletDbEntry = v;
    }

                        
    public PortletDbEntry getPortletDbEntry() throws TorqueException
    {
        if ( getOwner()>0 )
        {
                return PortletDbEntryManager.getInstance(SimpleKey.keyFor(getOwner()));
            }
        return aPortletDbEntry;
    }

    /**
     * Provides convenient way to set a relationship based on a
     * ObjectKey.  e.g.
     * <code>bar.setFooKey(foo.getPrimaryKey())</code>
     *
         */
    public void setPortletDbEntryKey(ObjectKey key) throws TorqueException
    {
    
                    setOwner(((NumberKey) key).longValue());
              }

     
                
    private static List fieldNames = null;

    /**
     * Generate a list of field names.
     */
    public static synchronized List getFieldNames()
    {
        if (fieldNames == null)
        {
            fieldNames = new ArrayList();
              fieldNames.add("Id");
              fieldNames.add("Name");
              fieldNames.add("Group");
              fieldNames.add("Owner");
              fieldNames = Collections.unmodifiableList(fieldNames);
        }
        return fieldNames;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.
     */
    public Object getByName(String name)
    {
          if (name.equals("Id"))
        {
                return new Long(getId());
            }
          if (name.equals("Name"))
        {
                return getName();
            }
          if (name.equals("Group"))
        {
                return getGroup();
            }
          if (name.equals("Owner"))
        {
                return new Long(getOwner());
            }
          return null;
    }
    
    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     */
    public Object getByPeerName(String name)
    {
          if (name.equals(PortletCategoryPeer.ID ))
        {
                return new Long(getId());
            }
          if (name.equals(PortletCategoryPeer.NAME ))
        {
                return getName();
            }
          if (name.equals(PortletCategoryPeer.GROUPE ))
        {
                return getGroup();
            }
          if (name.equals(PortletCategoryPeer.OWNER ))
        {
                return new Long(getOwner());
            }
          return null;
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     */
    public Object getByPosition(int pos)
    {
            if ( pos == 0 )
        {
                return new Long(getId());
            }
              if ( pos == 1 )
        {
                return getName();
            }
              if ( pos == 2 )
        {
                return getGroup();
            }
              if ( pos == 3 )
        {
                return new Long(getOwner());
            }
              return null;
    }
     
    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     */
    public void save() throws Exception
    {
          save(PortletCategoryPeer.getMapBuilder()
                .getDatabaseMap().getName());
      }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
       * Note: this code is here because the method body is
     * auto-generated conditionally and therefore needs to be
     * in this file instead of in the super class, BaseObject.
       */
    public void save(String dbName) throws TorqueException
    {
        Connection con = null;
          try
        {
            con = Transaction.begin(dbName);
            save(con);
            Transaction.commit(con);
        }
        catch(TorqueException e)
        {
            Transaction.safeRollback(con);
            throw e;
        }
      }

      /** flag to prevent endless save loop, if this object is referenced
        by another object which falls in this transaction. */
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     */
    public void save(Connection con) throws TorqueException
    {
          if (!alreadyInSave)
        {
            alreadyInSave = true;


  
            // If this object has been modified, then save it to the database.
            if (isModified())
            {
                if (isNew())
                {
                    PortletCategoryPeer.doInsert((PortletCategory)this, con);
                    setNew(false);
                }
                else
                {
                    PortletCategoryPeer.doUpdate((PortletCategory)this, con);
                }

                      if (isCacheOnSave())
                {
                    PortletCategoryManager.putInstance(this);
                }
              }

                      alreadyInSave = false;
        }
      }

    /**
     * Specify whether to cache the object after saving to the db.
     * This method returns false
     */
    protected boolean isCacheOnSave()
    {
        return true;
    }

                  
      /**
     * Set the PrimaryKey using ObjectKey.
     *
     * @param ObjectKey id
     */
    public void setPrimaryKey(ObjectKey id)
         {
            setId(((NumberKey)id).longValue());
        }

    /**
     * Set the PrimaryKey using a String.
     */
    public void setPrimaryKey(String key) 
    {
            setId(Long.parseLong(key));
        }

  
    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey()
    {
          return SimpleKey.keyFor(getId());
      }
 

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
       * It then fills all the association collections.
       */
      public PortletCategory copy() throws TorqueException
    {
        PortletCategory copyObj = new PortletCategory();
            copyObj.setId(id);
          copyObj.setName(name);
          copyObj.setGroup(group);
          copyObj.setOwner(owner);
  
                      copyObj.setId(0);
                              
                return copyObj;
    }

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public PortletCategoryPeer getPeer()
    {
        return peer;
    }
}
