/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.modules.screens.ALJSONScreen;
import com.aimluck.eip.schedule.AjaxScheduleMonthlySelectData;
import com.aimluck.eip.schedule.ScheduleDayContainer;
import com.aimluck.eip.schedule.ScheduleWeekContainer;
import java.util.Iterator;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ScheduleMonthlyJSONScreen
extends ALJSONScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleMonthlyJSONScreen.class.getName());

    protected String getJSONString(RunData rundata, Context context) throws Exception {
        JSONObject result = new JSONObject();
        try {
            AjaxScheduleMonthlySelectData listData = new AjaxScheduleMonthlySelectData();
            listData.initField();
            listData.setMonthlyCalendar(rundata, context);
            JSONArray month = new JSONArray();
            Iterator<ScheduleWeekContainer> it = listData.getMonthlyCalendarContainer().getWeekList().iterator();
            while (it.hasNext()) {
                JSONArray week = new JSONArray();
                for (ScheduleDayContainer dayContainer : it.next().getDayList()) {
                    JSONObject day = new JSONObject();
                    day.accumulate("year", (Object)dayContainer.getDate().getYear());
                    day.accumulate("month", (Object)dayContainer.getDate().getMonth());
                    day.accumulate("day", (Object)dayContainer.getDate().getDay());
                    day.accumulate("is_holiday", dayContainer.isHoliday());
                    day.accumulate("today", (Object)dayContainer.getToday());
                    week.add((Object)day.toString());
                }
                month.add((Object)week.toString());
            }
            result.accumulate("monthly_container", (Object)month.toString());
            result.accumulate("year", (Object)listData.getMonthlyCalendarViewMonth().getYear());
            result.accumulate("month", (Object)listData.getMonthlyCalendarViewMonth().getMonth());
            result.accumulate("next_month", (Object)listData.getMonthlyCalendarNextMonth().toString());
            result.accumulate("prev_month", (Object)listData.getMonthlyCalendarPrevMonth().toString());
            result.accumulate("today", (Object)listData.getMonthlyCalendarToday().toString());
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleMonthlyJSONScreen]", (Throwable)e);
        }
        return result.toString();
    }
}

