/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.schedule.ScheduleSearchResultData;
import com.aimluck.eip.schedule.ScheduleiCalSelectData;
import com.aimluck.eip.util.ALEipUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.model.property.XProperty;
import net.fortuna.ical4j.util.UidGenerator;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.modules.screens.RawScreen;
import org.apache.turbine.util.RunData;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class ScheduleiCalScreen
extends RawScreen
implements ALAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleiCalScreen.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOutput(RunData rundata) throws Exception {
        ScheduleiCalSelectData selectData = new ScheduleiCalSelectData();
        selectData.initField();
        ALEipUser user = ALEipUtils.getALEipUser((RunData)rundata);
        VelocityContext context = new VelocityContext();
        ALEipUtils.setupContext((RunData)rundata, (Context)context);
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.add(2, -3);
        date.set(11, 0);
        date.set(12, 0);
        date.set(13, 0);
        date.set(14, 0);
        java.util.Date startDate = date.getTime();
        date.add(2, 6);
        java.util.Date endDate = date.getTime();
        selectData.doViewList(this, rundata, (Context)context);
        List resultList = selectData.getList();
        Map<Integer, List<ScheduleSearchResultData>> dummyMaps = selectData.getDummyMaps();
        Calendar cal = new Calendar();
        cal.getProperties().add((Property)new ProdId("-//TOWN, Inc. //Aipo //JP"));
        cal.getProperties().add((Property)Version.VERSION_2_0);
        cal.getProperties().add((Property)CalScale.GREGORIAN);
        cal.getProperties().add((Property)Method.PUBLISH);
        cal.getProperties().add((Property)new XProperty("X-WR-CALNAME", user.getAliasName().getValue()));
        TimeZoneRegistry registry = TimeZoneRegistryFactory.getInstance().createRegistry();
        TimeZone timezone = registry.getTimeZone("Asia/Tokyo");
        VTimeZone tz = timezone.getVTimeZone();
        cal.getComponents().add((Component)tz);
        for (Object result : resultList) {
            String description;
            ScheduleSearchResultData rd = (ScheduleSearchResultData)result;
            java.util.Calendar cStart = java.util.Calendar.getInstance();
            cStart.setTime(rd.getStartDate().getValue());
            java.util.Calendar cEnd = java.util.Calendar.getInstance();
            cEnd.setTime(rd.getEndDate().getValue());
            DateTime dStart = null;
            DateTime dEnd = null;
            String ptn = rd.getPattern();
            if ("S".equals(rd.getPattern())) {
                cStart.add(5, 1);
                dStart = new Date(cStart.getTime());
                if (cEnd.get(11) == 0 && cEnd.get(12) == 0 && cEnd.get(13) == 0) {
                    cEnd.add(5, 2);
                } else {
                    cEnd.add(5, 1);
                }
                dEnd = new Date(cEnd.getTime());
            } else {
                dStart = new DateTime(cStart.getTime());
                dEnd = new DateTime(cEnd.getTime());
            }
            java.util.Date currentStartDate = this.getRepeatStartDate(startDate, ptn);
            Recur recur = null;
            int count = 0;
            if (ptn.charAt(0) == 'D') {
                recur = new Recur("DAILY", null);
                count = 1;
            } else if (ptn.charAt(0) == 'W' && ptn.length() == 9) {
                recur = new Recur("WEEKLY", null);
                if (ptn.charAt(1) != '0') {
                    recur.getDayList().add(WeekDay.SU);
                }
                if (ptn.charAt(2) != '0') {
                    recur.getDayList().add(WeekDay.MO);
                }
                if (ptn.charAt(3) != '0') {
                    recur.getDayList().add(WeekDay.TU);
                }
                if (ptn.charAt(4) != '0') {
                    recur.getDayList().add(WeekDay.WE);
                }
                if (ptn.charAt(5) != '0') {
                    recur.getDayList().add(WeekDay.TH);
                }
                if (ptn.charAt(6) != '0') {
                    recur.getDayList().add(WeekDay.FR);
                }
                if (ptn.charAt(7) != '0') {
                    recur.getDayList().add(WeekDay.SA);
                }
                count = 8;
            } else if (ptn.charAt(0) == 'W' && ptn.length() == 10) {
                recur = new Recur("MONTHLY", null);
                int offset = Character.getNumericValue(ptn.charAt(8));
                if (ptn.charAt(1) != '0') {
                    recur.getDayList().add(new WeekDay(WeekDay.SU, offset));
                }
                if (ptn.charAt(2) != '0') {
                    recur.getDayList().add(new WeekDay(WeekDay.MO, offset));
                }
                if (ptn.charAt(3) != '0') {
                    recur.getDayList().add(new WeekDay(WeekDay.TU, offset));
                }
                if (ptn.charAt(4) != '0') {
                    recur.getDayList().add(new WeekDay(WeekDay.WE, offset));
                }
                if (ptn.charAt(5) != '0') {
                    recur.getDayList().add(new WeekDay(WeekDay.TH, offset));
                }
                if (ptn.charAt(6) != '0') {
                    recur.getDayList().add(new WeekDay(WeekDay.FR, offset));
                }
                if (ptn.charAt(7) != '0') {
                    recur.getDayList().add(new WeekDay(WeekDay.SA, offset));
                }
                count = 9;
            } else if (ptn.charAt(0) == 'M') {
                recur = new Recur("MONTHLY", null);
                int mday = Integer.parseInt(ptn.substring(1, 3));
                recur.getMonthList().addAll(Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12));
                recur.getMonthDayList().add(Integer.valueOf(mday));
                count = 3;
            } else if (ptn.charAt(0) == 'Y') {
                recur = new Recur("YEARLY", null);
                int ymonth = Integer.parseInt(ptn.substring(1, 3));
                int yday = Integer.parseInt(ptn.substring(3, 5));
                recur.getMonthList().add(Integer.valueOf(ymonth));
                recur.getMonthDayList().add(Integer.valueOf(yday));
                count = 5;
            }
            if (count > 0) {
                int min;
                int hour;
                if (ptn.charAt(count) == 'L') {
                    if (endDate.compareTo(cStart.getTime()) < 0 || cEnd.getTime().compareTo(startDate) < 0) continue;
                    if (endDate.compareTo(cEnd.getTime()) < 0) {
                        recur.setUntil((Date)new DateTime(endDate));
                    } else {
                        recur.setUntil((Date)new DateTime(cEnd.getTime()));
                    }
                    if (cStart.getTime().compareTo(startDate) < 0) {
                        hour = cStart.get(11);
                        min = cStart.get(12);
                        cStart.setTime(currentStartDate);
                        cStart.set(11, hour);
                        cStart.set(12, min);
                        hour = cEnd.get(11);
                        min = cEnd.get(12);
                        cEnd.setTime(currentStartDate);
                        cEnd.set(11, hour);
                        cEnd.set(12, min);
                        dStart = new DateTime(cStart.getTime());
                        dEnd = new DateTime(cEnd.getTime());
                    } else {
                        java.util.Date RepeatStartDate = this.getRepeatStartDate((java.util.Date)dStart, ptn);
                        int hour2 = cStart.get(11);
                        int min2 = cStart.get(12);
                        cStart.setTime(RepeatStartDate);
                        cStart.set(11, hour2);
                        cStart.set(12, min2);
                        hour2 = cEnd.get(11);
                        min2 = cEnd.get(12);
                        cEnd.setTime(RepeatStartDate);
                        cEnd.set(11, hour2);
                        cEnd.set(12, min2);
                        dStart = new DateTime(cStart.getTime());
                        dEnd = new DateTime(cEnd.getTime());
                    }
                } else {
                    recur.setUntil((Date)new DateTime(endDate.getTime()));
                    hour = cStart.get(11);
                    min = cStart.get(12);
                    cStart.setTime(currentStartDate);
                    cStart.set(11, hour);
                    cStart.set(12, min);
                    hour = cEnd.get(11);
                    min = cEnd.get(12);
                    cEnd.setTime(currentStartDate);
                    cEnd.set(11, hour);
                    cEnd.set(12, min);
                    dStart = new DateTime(cStart.getTime());
                    dEnd = new DateTime(cEnd.getTime());
                    if (ptn.charAt(0) == 'Y' && (endDate.compareTo(cStart.getTime()) < 0 || startDate.compareTo(cEnd.getTime()) > 0)) {
                        recur = null;
                        dStart = null;
                        dEnd = null;
                    }
                }
            }
            VEvent event = new VEvent((Date)dStart, (Date)dEnd, rd.getName().getValue());
            String place = rd.getPlace().getValue();
            if (place != null && place.length() > 0) {
                event.getProperties().add((Property)new Location(place));
            }
            if ((description = rd.getDescription().getValue()) != null && description.length() > 0) {
                event.getProperties().add((Property)new Description(description));
            }
            event.getProperties().add((Property)new UidGenerator(rd.getScheduleId().getValueAsString()).generateUid());
            if (recur != null) {
                event.getProperties().add((Property)new RRule(recur));
                if (dummyMaps.containsKey((int)rd.getScheduleId().getValue())) {
                    List<ScheduleSearchResultData> list = dummyMaps.get((int)rd.getScheduleId().getValue());
                    DateList dateList = new DateList();
                    for (ScheduleSearchResultData dummy : list) {
                        java.util.Calendar dummyStart = java.util.Calendar.getInstance();
                        dummyStart.setTime(dummy.getStartDate().getValue());
                        dummyStart.set(11, cStart.get(11));
                        dummyStart.set(12, cStart.get(12));
                        dateList.add((Date)new DateTime(dummyStart.getTime()));
                    }
                    event.getProperties().add((Property)new ExDate(dateList));
                }
            }
            cal.getComponents().add((Component)event);
        }
        ServletOutputStream out = null;
        try {
            out = rundata.getResponse().getOutputStream();
            out.write(cal.toString().getBytes(ALEipConstants.DEF_CONTENT_ENCODING));
        }
        catch (Throwable t) {
            logger.error((Object)"[ScheduleiCalScreen]", t);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (Throwable result) {}
            }
        }
    }

    private java.util.Date getRepeatStartDate(java.util.Date startDate, String ptn) {
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.setTime(startDate);
        if (this.isView(cal, ptn)) {
            return startDate;
        }
        cal.add(5, 1);
        return this.getRepeatStartDate(cal.getTime(), ptn);
    }

    private boolean isView(java.util.Calendar cal, String ptn) {
        boolean result = false;
        if (ptn.charAt(0) == 'D') {
            result = true;
        } else if (ptn.charAt(0) == 'W') {
            int dow = cal.get(7);
            int dowim = cal.get(8);
            if (ptn.charAt(8) == 'N' || ptn.charAt(8) == 'L' || dowim == Character.getNumericValue(ptn.charAt(8))) {
                switch (dow) {
                    case 1: {
                        result = ptn.charAt(1) != '0';
                        break;
                    }
                    case 2: {
                        result = ptn.charAt(2) != '0';
                        break;
                    }
                    case 3: {
                        result = ptn.charAt(3) != '0';
                        break;
                    }
                    case 4: {
                        result = ptn.charAt(4) != '0';
                        break;
                    }
                    case 5: {
                        result = ptn.charAt(5) != '0';
                        break;
                    }
                    case 6: {
                        result = ptn.charAt(6) != '0';
                        break;
                    }
                    case 7: {
                        result = ptn.charAt(7) != '0';
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
            }
        } else if (ptn.charAt(0) == 'M') {
            int mday = Integer.parseInt(ptn.substring(1, 3));
            result = cal.get(5) == mday;
        } else if (ptn.charAt(0) == 'Y') {
            int ymonth = Integer.parseInt(ptn.substring(1, 3));
            int yday = Integer.parseInt(ptn.substring(3, 5));
            result = cal.get(2) == ymonth - 1 && cal.get(5) == yday;
        } else {
            return true;
        }
        return result;
    }

    protected String getContentType(RunData rundata) {
        return "text/calendar";
    }

    public void setResultData(Object obj) {
    }

    public void addResultData(Object obj) {
    }

    public void setResultDataList(List<Object> objList) {
    }

    public void addErrorMessage(String msg) {
    }

    public void addErrorMessages(List<String> msgs) {
    }

    public void setErrorMessages(List<String> msgs) {
    }

    public void setMode(String mode) {
    }

    public String getMode() {
        return null;
    }

    public void putData(RunData rundata, Context context) {
    }
}

