/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.AbstractCellScheduleFormData;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CellScheduleFormDateData
extends AbstractCellScheduleFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellScheduleFormDateData.class.getName());

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String entityId = rundata.getParameters().getString("entityid");
        if (entityId == null) {
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"entityid");
        }
        super.init(action, rundata, context);
    }

    @Override
    protected void loadCustomFormData(EipTSchedule record) {
        this.loadEditFlag(record);
        this.loadMemberAndFacility(record);
    }

    private void loadEditFlag(EipTSchedule record) {
        if ("T".equals(record.getEditFlag())) {
            if (this.isOwner()) {
                this.form_data.getEditFlag().setValue(record.getEditFlag());
            } else {
                int createUserId = record.getOwnerId();
                boolean inculudeCreateUser = false;
                List scheduleMaps = record.getEipTScheduleMaps();
                for (EipTScheduleMap map : scheduleMaps) {
                    if (createUserId != map.getUserId() || "R".equals(map.getStatus())) continue;
                    inculudeCreateUser = true;
                    break;
                }
                if (inculudeCreateUser) {
                    this.form_data.getEditFlag().setValue("F");
                } else {
                    this.form_data.getEditFlag().setValue("T");
                }
            }
        } else {
            this.form_data.getEditFlag().setValue("F");
        }
    }

    private void loadMemberAndFacility(EipTSchedule record) {
        SelectQuery mapquery = Database.query(EipTScheduleMap.class);
        Expression mapexp = ExpressionFactory.matchExp((String)"scheduleId", (Object)record.getScheduleId());
        mapquery.setQualifier(mapexp);
        List list = mapquery.fetchList();
        ArrayList<Integer> users = new ArrayList<Integer>();
        ArrayList<Integer> facilityIds = new ArrayList<Integer>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            EipTScheduleMap map = (EipTScheduleMap)list.get(i);
            if ("U".equals(map.getType())) {
                users.add(map.getUserId());
                continue;
            }
            facilityIds.add(map.getUserId());
        }
        if (users.size() > 0) {
            SelectQuery query = Database.query(TurbineUser.class);
            Expression exp = ExpressionFactory.inDbExp((String)"USER_ID", users);
            query.setQualifier(exp);
            this.form_data.getMemberList().addAll(ALEipUtils.getUsersFromSelectQuery((SelectQuery)query));
        }
        if (facilityIds.size() > 0) {
            SelectQuery fquery = Database.query(EipMFacility.class);
            Expression fexp = ExpressionFactory.inDbExp((String)"FACILITY_ID", facilityIds);
            fquery.setQualifier(fexp);
            this.form_data.getFacilityMemberList().addAll(FacilitiesUtils.getFacilitiesFromSelectQuery((SelectQuery)fquery));
        }
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) throws ALDBErrorException {
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }
}

