/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALCellNumberField;
import com.aimluck.commons.field.ALDateContainer;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.category.util.CommonCategoryUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.mail.ALAdminMailContext;
import com.aimluck.eip.mail.ALAdminMailMessage;
import com.aimluck.eip.mail.ALMailService;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.AbstractCellScheduleFormData;
import com.aimluck.eip.schedule.util.CellScheduleUtils;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CellScheduleFormNoteData
extends AbstractCellScheduleFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellScheduleFormNoteData.class.getName());
    private ALStringField name;
    private ALStringField place;
    private ALStringField note;
    private ALStringField public_flag;
    private ALCellNumberField common_category_id;
    private List<ALEipGroup> groups;
    private ALCellNumberField del_member_flag;
    private ALCellNumberField del_range_flag;
    private ALCellNumberField del_flag;

    @Override
    public boolean doViewForm(ALAction action, RunData rundata, Context context) {
        try {
            int acltype;
            EipTSchedule schedule;
            boolean isedit;
            this.init(action, rundata, context);
            boolean bl = isedit = rundata.getParameters().containsKey((Object)"entityid") && !"new".equals(rundata.getParameters().getString("entityid"));
            if (this.is_copy) {
                isedit = false;
            }
            action.setMode(isedit ? "edit_form" : "new_form");
            this.setMode(action.getMode());
            ArrayList<String> msgList = new ArrayList<String>();
            boolean res = true;
            if (isedit || this.is_copy) {
                schedule = ScheduleUtils.getEipTSchedule(rundata, context, false);
                res = this.loadFormData(rundata, context, msgList);
            } else {
                this.setFormData(rundata, context, msgList);
                schedule = (EipTSchedule)Database.create(EipTSchedule.class);
            }
            String schedule_type = this.getScheduleType().getValue();
            if ("S".equals(schedule_type)) {
                schedule.setStartDate(this.form_data.getStartDate().getValue());
                schedule.setEndDate(this.form_data.getEndDate().getValue());
                schedule.setRepeatPattern("S");
            } else if ("O".equals(schedule_type)) {
                schedule.setStartDate(this.form_data.getStartDate().getValue());
                schedule.setEndDate(this.form_data.getEndDate().getValue());
                schedule.setRepeatPattern("N");
            } else {
                char lim = 'N';
                Calendar cal = Calendar.getInstance();
                if ("ON".equals(this.form_data.getLimitFlag().getValue())) {
                    lim = 'L';
                    int year = Integer.parseInt(this.form_data.getLimitEndDate().getYear());
                    int month = Integer.parseInt(this.form_data.getLimitEndDate().getMonth()) - 1;
                    int day = Integer.parseInt(this.form_data.getLimitEndDate().getDay());
                    cal.set(year, month, day);
                    Calendar limitStartCal = Calendar.getInstance();
                    limitStartCal.setTime(this.form_data.getStartDate().getValue());
                    limitStartCal.set(1, Integer.parseInt(this.form_data.getLimitStartDate().getYear()));
                    limitStartCal.set(2, Integer.parseInt(this.form_data.getLimitStartDate().getMonth()) - 1);
                    limitStartCal.set(5, Integer.parseInt(this.form_data.getLimitStartDate().getDay()));
                    schedule.setStartDate(limitStartCal.getTime());
                    schedule.setEndDate(cal.getTime());
                } else {
                    schedule.setStartDate(this.form_data.getStartDate().getValue());
                    schedule.setEndDate(this.form_data.getEndDate().getValue());
                }
                if ("D".equals(this.form_data.getRepeatType().getValue())) {
                    schedule.setRepeatPattern(new StringBuffer().append('D').append(lim).toString());
                } else if ("W".equals(this.form_data.getRepeatType().getValue())) {
                    if (this.form_data.getRepeatWeek().getValue().equals("0")) {
                        schedule.setRepeatPattern(new StringBuffer().append('W').append(this.form_data.getWeek0().getValue() != null ? 1 : 0).append(this.form_data.getWeek1().getValue() != null ? 1 : 0).append(this.form_data.getWeek2().getValue() != null ? 1 : 0).append(this.form_data.getWeek3().getValue() != null ? 1 : 0).append(this.form_data.getWeek4().getValue() != null ? 1 : 0).append(this.form_data.getWeek5().getValue() != null ? 1 : 0).append(this.form_data.getWeek6().getValue() != null ? 1 : 0).append(lim).toString());
                    } else {
                        schedule.setRepeatPattern(new StringBuffer().append('W').append(this.form_data.getWeek0().getValue() != null ? 1 : 0).append(this.form_data.getWeek1().getValue() != null ? 1 : 0).append(this.form_data.getWeek2().getValue() != null ? 1 : 0).append(this.form_data.getWeek3().getValue() != null ? 1 : 0).append(this.form_data.getWeek4().getValue() != null ? 1 : 0).append(this.form_data.getWeek5().getValue() != null ? 1 : 0).append(this.form_data.getWeek6().getValue() != null ? 1 : 0).append(this.form_data.getRepeatWeek().getValue()).append(lim).toString());
                    }
                } else if ("M".equals(this.form_data.getRepeatType().getValue())) {
                    DecimalFormat format = new DecimalFormat("00");
                    schedule.setRepeatPattern(new StringBuffer().append('M').append(format.format(this.form_data.getMonthDay().getValue())).append(lim).toString());
                } else {
                    DecimalFormat format = new DecimalFormat("00");
                    schedule.setRepeatPattern(new StringBuffer().append('Y').append(format.format(this.form_data.getYearMonth().getValue())).append(format.format(this.form_data.getYearDay().getValue())).append(lim).toString());
                }
            }
            context.put("isDuplicateFacility", (Object)"false");
            List<FacilityResultData> facilityList = CellScheduleUtils.getShareFacilityMemberList(rundata);
            if (facilityList.size() > 0) {
                ArrayList<Integer> fids = new ArrayList<Integer>();
                for (FacilityResultData facility : facilityList) {
                    fids.add((int)facility.getFacilityId().getValue());
                }
                if (ScheduleUtils.isDuplicateFacilitySchedule(schedule, fids, null, null)) {
                    context.put("isDuplicateFacility", (Object)"true");
                }
            }
            int n = acltype = "new_form".equals(this.getMode()) ? 4 : 8;
            if (!this.facilityCheckAclPermission(rundata, acltype)) {
                if (acltype == 8) {
                    int[] old_ids = ScheduleUtils.getFacilityIds(schedule);
                    boolean check = false;
                    if (old_ids.length != facilityList.size()) {
                        msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_NO_PERMISSION_TO_MAKE_A_RESERVATION"));
                        res = false;
                    } else {
                        for (int old_id : old_ids) {
                            for (FacilityResultData record : facilityList) {
                                FacilityResultData frd = record;
                                int facilityid = (int)frd.getFacilityId().getValue();
                                if (old_id != facilityid) continue;
                                check = true;
                                break;
                            }
                            if (!check) {
                                msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_NO_PERMISSION_TO_MAKE_A_RESERVATION"));
                                res = false;
                            }
                            check = false;
                        }
                    }
                } else if (facilityList.size() > 0) {
                    msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_NO_PERMISSION_TO_MAKE_A_RESERVATION"));
                    res = false;
                }
            }
            res = res && this.form_data.validateDelegate(msgList, this.getLoginUser(), this.getEntityId(), this.getScheduleType().getValue());
            action.setResultData((Object)this);
            action.addErrorMessages(msgList);
            action.putData(rundata, context);
            return res;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
    }

    @Override
    public void initField() {
        this.name = new ALStringField();
        this.name.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_TITLE"));
        this.name.setTrim(true);
        this.place = new ALStringField();
        this.place.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_PLACE"));
        this.place.setTrim(true);
        this.note = new ALStringField();
        this.note.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_NOTE"));
        this.note.setTrim(false);
        this.public_flag = new ALStringField();
        this.public_flag.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_PUBLIC"));
        this.public_flag.setTrim(true);
        this.public_flag.setValue("O");
        this.del_member_flag = new ALCellNumberField();
        this.del_member_flag.setValue(0L);
        this.del_range_flag = new ALCellNumberField();
        this.del_range_flag.setValue(0L);
        this.del_flag = new ALCellNumberField();
        this.del_flag.setValue(0L);
        this.common_category_id = new ALCellNumberField();
        this.common_category_id.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_CATEGORY"));
        this.common_category_id.setValue(1L);
        super.initField();
    }

    @Override
    protected void setValidator() {
        this.getName().setNotNull(true);
        this.getName().limitMaxLength(50);
        this.getPlace().limitMaxLength(50);
        this.getNote().limitMaxLength(1000);
        super.setValidator();
    }

    @Override
    protected boolean validate(List<String> msgList) throws ALDBErrorException, ALPageNotFoundException {
        this.getName().validate(msgList);
        this.getPlace().validate(msgList);
        this.getNote().validate(msgList);
        if ("P".equals(this.public_flag.getValue()) && this.form_data.getFacilityMemberList().size() > 0) {
            msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_HIDE"));
        }
        return super.validate(msgList);
    }

    @Override
    protected void loadCustomFormData(EipTSchedule record) {
        this.name.setValue(record.getName());
        this.place.setValue(record.getPlace());
        this.note.setValue(record.getNote());
        this.public_flag.setValue(record.getPublicFlag());
        this.form_data.getWeek0().setValue("");
        this.form_data.getWeek1().setValue("");
        this.form_data.getWeek2().setValue("");
        this.form_data.getWeek3().setValue("");
        this.form_data.getWeek4().setValue("");
        this.form_data.getWeek5().setValue("");
        this.form_data.getWeek6().setValue("");
    }

    @Override
    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        Field[] fields = ((Object)((Object)this)).getClass().getDeclaredFields();
        boolean res = ScheduleUtils.setFormDataDelegate(rundata, context, (ALData)this, fields, msgList);
        if (!res) {
            return res;
        }
        return super.setFormData(rundata, context, msgList);
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) throws ALDBErrorException {
        EipTSchedule schedule = null;
        try {
            if (this.isSpan()) {
                Calendar startDate = Calendar.getInstance();
                startDate.setTime(this.form_data.getStartDate().getValue());
                startDate.set(11, 0);
                startDate.set(12, 0);
                Calendar endDate = Calendar.getInstance();
                endDate.setTime(this.form_data.getEndDate().getValue());
                endDate.set(11, 0);
                endDate.set(12, 0);
                this.form_data.getStartDate().setValue(startDate.getTime());
                this.form_data.getEndDate().setValue(endDate.getTime());
            } else {
                GregorianCalendar startcal = new GregorianCalendar();
                startcal.setTime(this.form_data.getStartDate().getValue());
                Calendar endcal = Calendar.getInstance();
                endcal.setTime(this.form_data.getEndDate().getValue());
                endcal.set(1, startcal.get(1));
                endcal.set(2, startcal.get(2));
                endcal.set(5, startcal.get(5));
                this.form_data.getEndDate().setValue(endcal.getTime());
            }
            int ownerid = ALEipUtils.getUserId((RunData)rundata);
            schedule = (EipTSchedule)Database.create(EipTSchedule.class);
            schedule.setParentId(Integer.valueOf(0));
            schedule.setName(this.getName().getValue());
            schedule.setPlace(this.getPlace().getValue());
            schedule.setNote(this.getNote().getValue());
            schedule.setPublicFlag(this.getPublicFlag().getValue());
            if (this.form_data.getMemberList().size() > 1) {
                schedule.setEditFlag(this.form_data.getEditFlag().getValue());
            } else {
                schedule.setEditFlag("F");
            }
            schedule.setOwnerId(Integer.valueOf(ownerid));
            Date now = new Date();
            schedule.setCreateDate(now);
            schedule.setCreateUserId(Integer.valueOf(ownerid));
            schedule.setUpdateDate(now);
            schedule.setUpdateUserId(Integer.valueOf(ownerid));
            if (this.isSpan()) {
                schedule.setEndDate(this.form_data.getEndDate().getValue());
                schedule.setRepeatPattern("S");
                schedule.setStartDate(this.form_data.getStartDate().getValue());
            } else if (!this.isRepeat()) {
                schedule.setEndDate(this.form_data.getEndDate().getValue());
                schedule.setRepeatPattern("N");
                schedule.setStartDate(this.form_data.getStartDate().getValue());
            } else {
                char lim = 'N';
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.form_data.getEndDate().getValue());
                if ("ON".equals(this.form_data.getLimitFlag().getValue())) {
                    lim = 'L';
                    cal.set(this.form_data.getLimitEndDate().getValue().getYear(), this.form_data.getLimitEndDate().getValue().getMonth() - 1, this.form_data.getLimitEndDate().getValue().getDay());
                    ALDateContainer aLDateContainer = this.form_data.getLimitStartDate().getValue();
                    Calendar limitStartCal = Calendar.getInstance();
                    limitStartCal.setTime(this.form_data.getStartDate().getValue());
                    limitStartCal.set(1, aLDateContainer.getYear());
                    limitStartCal.set(2, aLDateContainer.getMonth() - 1);
                    limitStartCal.set(5, aLDateContainer.getDay());
                    schedule.setStartDate(limitStartCal.getTime());
                } else {
                    schedule.setStartDate(this.form_data.getStartDate().getValue());
                }
                schedule.setEndDate(cal.getTime());
                if ("D".equals(this.form_data.getRepeatType().getValue())) {
                    schedule.setRepeatPattern(new StringBuffer().append('D').append(lim).toString());
                } else if ("W".equals(this.form_data.getRepeatType().getValue())) {
                    if ("0".equals(this.form_data.getRepeatWeek().getValue())) {
                        schedule.setRepeatPattern(new StringBuffer().append('W').append(this.form_data.getWeek0().getValue() != null ? 1 : 0).append(this.form_data.getWeek1().getValue() != null ? 1 : 0).append(this.form_data.getWeek2().getValue() != null ? 1 : 0).append(this.form_data.getWeek3().getValue() != null ? 1 : 0).append(this.form_data.getWeek4().getValue() != null ? 1 : 0).append(this.form_data.getWeek5().getValue() != null ? 1 : 0).append(this.form_data.getWeek6().getValue() != null ? 1 : 0).append(lim).toString());
                    } else {
                        schedule.setRepeatPattern(new StringBuffer().append('W').append(this.form_data.getWeek0().getValue() != null ? 1 : 0).append(this.form_data.getWeek1().getValue() != null ? 1 : 0).append(this.form_data.getWeek2().getValue() != null ? 1 : 0).append(this.form_data.getWeek3().getValue() != null ? 1 : 0).append(this.form_data.getWeek4().getValue() != null ? 1 : 0).append(this.form_data.getWeek5().getValue() != null ? 1 : 0).append(this.form_data.getWeek6().getValue() != null ? 1 : 0).append(this.form_data.getRepeatWeek().getValue().charAt(0)).append(lim).toString());
                    }
                } else if ("M".equals(this.form_data.getRepeatType().getValue())) {
                    DecimalFormat decimalFormat = new DecimalFormat("00");
                    schedule.setRepeatPattern(new StringBuffer().append('M').append(decimalFormat.format(this.form_data.getMonthDay().getValue())).append(lim).toString());
                } else {
                    DecimalFormat decimalFormat = new DecimalFormat("00");
                    schedule.setRepeatPattern(new StringBuffer().append('Y').append(decimalFormat.format(this.form_data.getYearMonth().getValue())).append(decimalFormat.format(this.form_data.getYearDay().getValue())).append(lim).toString());
                }
            }
            EipTCommonCategory category1 = CommonCategoryUtils.getEipTCommonCategory((Long)1L);
            for (ALEipUser aLEipUser : this.form_data.getMemberList()) {
                int userid = (int)aLEipUser.getUserId().getValue();
                EipTScheduleMap map = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
                map.setEipTSchedule(schedule);
                map.setUserId(Integer.valueOf(userid));
                if (userid == ALEipUtils.getUserId((RunData)rundata)) {
                    map.setStatus("O");
                } else {
                    map.setStatus("T");
                }
                EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory((Long)this.common_category_id.getValue());
                if (category == null) {
                    map.setCommonCategoryId(Integer.valueOf(1));
                    map.setEipTSchedule(schedule);
                    map.setEipTCommonCategory(category1);
                } else {
                    map.setCommonCategoryId(Integer.valueOf((int)this.common_category_id.getValue()));
                    map.setEipTSchedule(schedule);
                    map.setEipTCommonCategory(category);
                }
                map.setType("U");
            }
            boolean isFacility = false;
            if ("O".equals(this.public_flag.getValue()) || "C".equals(this.public_flag.getValue())) {
                for (FacilityResultData frd : this.form_data.getFacilityMemberList()) {
                    isFacility = true;
                    int facilityid = (int)frd.getFacilityId().getValue();
                    EipTScheduleMap map = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
                    map.setEipTSchedule(schedule);
                    map.setUserId(Integer.valueOf(facilityid));
                    map.setStatus("O");
                    map.setType("F");
                    map.setEipTCommonCategory(category1);
                    map.setCommonCategoryId(Integer.valueOf(1));
                }
            }
            if (isFacility && !this.facilityCheckAclPermission(rundata, 4)) {
                msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_NO_PERMISSION_TO_MAKE_A_RESERVATION"));
                return false;
            }
            Database.commit();
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"mode", (String)"insert");
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(schedule.getScheduleId().intValue(), 240, schedule.getName());
            ALEipUser aLEipUser = this.getLoginUser();
            List<ALEipUser> memberList = this.form_data.getMemberList();
            if (aLEipUser != null) {
                String loginName = aLEipUser.getName().getValue();
                ArrayList<String> recipients = new ArrayList<String>();
                for (ALEipUser user : memberList) {
                    if (aLEipUser.getUserId().getValue() == user.getUserId().getValue()) continue;
                    recipients.add(user.getName().getValue());
                }
                ScheduleUtils.createShareScheduleActivity(schedule, loginName, recipients, "new", ownerid);
                if ("O".equals(this.public_flag.toString())) {
                    ScheduleUtils.createNewScheduleActivity(schedule, loginName, "new", ownerid);
                }
            }
        }
        catch (RuntimeException e) {
            Database.rollback();
            logger.error((Object)"[CellScheduleFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"[CellScheduleFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        try {
            int msgType = ALMailUtils.getSendDestType((int)24);
            if (msgType > 0) {
                List destMemberList = ALMailUtils.getALEipUserAddrs(this.form_data.getMemberList(), (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
                String subject = ALLocalizationUtils.getl10nFormat((String)"SCHEDULE_SUB_SCHEDULE", (Object[])new Object[]{ALOrgUtilsService.getAlias()});
                String org_id = ALOrgUtilsService.getAlias();
                ArrayList<ALAdminMailMessage> arrayList = new ArrayList<ALAdminMailMessage>();
                for (ALEipUserAddr destMember : destMemberList) {
                    ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                    message.setPcSubject(subject);
                    message.setCellularSubject(subject);
                    message.setPcBody(ScheduleUtils.createMsgForPc(rundata, schedule, this.form_data.getMemberList(), "new"));
                    message.setCellularBody(ScheduleUtils.createMsgForCellPhone(rundata, schedule, this.form_data.getMemberList(), destMember.getUserId(), "new"));
                    arrayList.add(message);
                }
                ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(org_id, ALEipUtils.getUserId((RunData)rundata), arrayList, ALMailUtils.getSendDestType((int)24)));
            }
        }
        catch (Exception ex) {
            msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_DONOT_SEND_MAIL"));
            logger.error((Object)"schedule", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        EipTSchedule schedule = null;
        try {
            if (this.isSpan()) {
                Calendar startDate = Calendar.getInstance();
                startDate.setTime(this.form_data.getStartDate().getValue());
                startDate.set(11, 0);
                startDate.set(12, 0);
                Calendar endDate = Calendar.getInstance();
                endDate.setTime(this.form_data.getEndDate().getValue());
                endDate.set(11, 0);
                endDate.set(12, 0);
                this.form_data.getStartDate().setValue(startDate.getTime());
                this.form_data.getEndDate().setValue(endDate.getTime());
            } else {
                GregorianCalendar startcal = new GregorianCalendar();
                startcal.setTime(this.form_data.getStartDate().getValue());
                Calendar endcal = Calendar.getInstance();
                endcal.setTime(this.form_data.getEndDate().getValue());
                endcal.set(1, startcal.get(1));
                endcal.set(2, startcal.get(2));
                endcal.set(5, startcal.get(5));
                this.form_data.getEndDate().setValue(endcal.getTime());
            }
            schedule = ScheduleUtils.getEipTSchedule(rundata, context, false);
            if (schedule == null) {
                return false;
            }
            int ownerid = ALEipUtils.getUserId((RunData)rundata);
            if (ownerid != schedule.getOwnerId() && "F".equals(schedule.getEditFlag())) {
                return true;
            }
            List<FacilityResultData> facilityList = CellScheduleUtils.getShareFacilityMemberList(rundata);
            if (!this.facilityCheckAclPermission(rundata, 8)) {
                int[] old_ids = ScheduleUtils.getFacilityIds(schedule);
                if (old_ids.length != facilityList.size()) {
                    msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_NO_PERMISSION_TO_MAKE_A_RESERVATION"));
                    return false;
                }
                boolean check = false;
                for (int old_id : old_ids) {
                    for (FacilityResultData record : facilityList) {
                        FacilityResultData frd = record;
                        int facilityid = (int)frd.getFacilityId().getValue();
                        if (old_id != facilityid) continue;
                        check = true;
                        break;
                    }
                    if (!check) {
                        msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_NO_PERMISSION_TO_MAKE_A_RESERVATION"));
                        return false;
                    }
                    check = false;
                }
            }
            SelectQuery mapquery = Database.query(EipTScheduleMap.class);
            Expression mapexp = ExpressionFactory.matchExp((String)"scheduleId", (Object)schedule.getScheduleId());
            mapquery.setQualifier(mapexp);
            List list = mapquery.fetchList();
            if (list != null && list.size() > 0) {
                EipTScheduleMap map = (EipTScheduleMap)list.get(0);
                EipTCommonCategory category = map.getEipTCommonCategory();
                if (category == null) {
                    this.common_category_id.setValue(1L);
                } else {
                    this.common_category_id.setValue(category.getCommonCategoryId().longValue());
                }
            }
            EipTCommonCategory category1 = CommonCategoryUtils.getEipTCommonCategory((Long)1L);
            if (this.form_data.getEditRepeatFlag().getValue() == 1L) {
                Object scheduleMaps;
                EipTSchedule newSchedule = (EipTSchedule)Database.create(EipTSchedule.class);
                newSchedule.setParentId(schedule.getScheduleId());
                newSchedule.setName(this.name.getValue());
                newSchedule.setPlace(this.place.getValue());
                newSchedule.setNote(this.note.getValue());
                newSchedule.setPublicFlag(this.public_flag.getValue());
                newSchedule.setEditFlag("F");
                newSchedule.setOwnerId(Integer.valueOf(ownerid));
                Date now = new Date();
                newSchedule.setCreateDate(now);
                newSchedule.setCreateUserId(Integer.valueOf(ownerid));
                newSchedule.setUpdateDate(now);
                newSchedule.setUpdateUserId(Integer.valueOf(ownerid));
                newSchedule.setEndDate(this.form_data.getEndDate().getValue());
                newSchedule.setRepeatPattern("N");
                newSchedule.setStartDate(this.form_data.getStartDate().getValue());
                int allsize = this.form_data.getMemberList().size() + this.form_data.getFacilityMemberList().size();
                if (allsize > 0) {
                    EipTScheduleMap map;
                    scheduleMaps = schedule.getEipTScheduleMaps();
                    for (ALEipUser user : this.form_data.getMemberList()) {
                        int userid = (int)user.getUserId().getValue();
                        map = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
                        map.setEipTSchedule(newSchedule);
                        map.setUserId(Integer.valueOf(userid));
                        if (userid == ALEipUtils.getUserId((RunData)rundata)) {
                            map.setStatus("O");
                        } else if ("T".equals(this.form_data.getChangeTmpreserveFlag().getValue())) {
                            map.setStatus("T");
                        } else {
                            EipTScheduleMap tmpMap = this.getScheduleMap((List<EipTScheduleMap>)scheduleMaps, userid);
                            if (tmpMap != null) {
                                map.setStatus(tmpMap.getStatus());
                            } else {
                                map.setStatus("T");
                            }
                        }
                        EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory((Long)this.common_category_id.getValue());
                        if (category == null) {
                            map.setCommonCategoryId(Integer.valueOf(1));
                            map.setEipTCommonCategory(category1);
                        } else {
                            map.setCommonCategoryId(Integer.valueOf((int)this.common_category_id.getValue()));
                            map.setEipTCommonCategory(category);
                        }
                        map.setType("U");
                    }
                    if ("O".equals(this.public_flag.getValue()) || "C".equals(this.public_flag.getValue())) {
                        for (FacilityResultData frd : this.form_data.getFacilityMemberList()) {
                            int facilityid = (int)frd.getFacilityId().getValue();
                            map = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
                            map.setEipTSchedule(newSchedule);
                            map.setUserId(Integer.valueOf(facilityid));
                            map.setStatus("O");
                            map.setType("F");
                            map.setEipTCommonCategory(category1);
                            map.setCommonCategoryId(Integer.valueOf(1));
                        }
                    }
                }
                scheduleMaps = schedule.getEipTScheduleMaps();
                ArrayList<Integer> memberIdList = new ArrayList<Integer>();
                Iterator frd = scheduleMaps.iterator();
                while (frd.hasNext()) {
                    EipTScheduleMap map = (EipTScheduleMap)frd.next();
                    memberIdList.add(map.getUserId());
                }
                int memberListSize = this.form_data.getMemberList().size();
                for (int i = 0; i < memberListSize; ++i) {
                    int memberId = (int)this.form_data.getMemberList().get(i).getUserId().getValue();
                    if (ScheduleUtils.isContains(memberIdList, memberId)) continue;
                    memberIdList.add(memberId);
                }
                int memberIdListSize = memberIdList.size();
                int[] memberIds = new int[memberIdListSize];
                for (int i = 0; i < memberIdListSize; ++i) {
                    memberIds[i] = (Integer)memberIdList.get(i);
                }
                ScheduleUtils.insertDummySchedule(schedule, ownerid, this.form_data.getViewDate().getValue(), this.form_data.getViewDate().getValue(), memberIds);
            } else {
                EipTScheduleMap map;
                schedule.setName(this.name.getValue());
                schedule.setPlace(this.place.getValue());
                schedule.setNote(this.note.getValue());
                schedule.setPublicFlag(this.public_flag.getValue());
                if (schedule.getOwnerId() == ALEipUtils.getUserId((RunData)rundata) || schedule.getOwnerId() == 0) {
                    schedule.setEditFlag(this.form_data.getEditFlag().getValue());
                }
                int ownerUserId = schedule.getOwnerId();
                boolean rejectOwnerUser = false;
                List tmpScheduleMaps = schedule.getEipTScheduleMaps();
                for (Object map2 : tmpScheduleMaps) {
                    if (ownerUserId != map2.getUserId() || !"R".equals(map2.getStatus())) continue;
                    rejectOwnerUser = true;
                    break;
                }
                boolean includeOwnerUser = false;
                for (ALEipUser eipUser : this.form_data.getMemberList()) {
                    if ((long)ownerUserId != eipUser.getUserId().getValue()) continue;
                    includeOwnerUser = true;
                    break;
                }
                if (rejectOwnerUser || !includeOwnerUser) {
                    schedule.setOwnerId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
                }
                schedule.setUpdateDate(new Date());
                schedule.setUpdateUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
                String schedule_type = this.getScheduleType().getValue();
                if ("S".equals(schedule_type)) {
                    schedule.setStartDate(this.form_data.getStartDate().getValue());
                    schedule.setEndDate(this.form_data.getEndDate().getValue());
                    schedule.setRepeatPattern("S");
                } else if ("O".equals(schedule_type)) {
                    schedule.setStartDate(this.form_data.getStartDate().getValue());
                    schedule.setEndDate(this.form_data.getEndDate().getValue());
                    schedule.setRepeatPattern("N");
                } else {
                    DecimalFormat format;
                    String tmpPattern;
                    char lim = 'N';
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(this.form_data.getEndDate().getValue());
                    if ("ON".equals(this.form_data.getLimitFlag().getValue())) {
                        lim = 'L';
                        cal.set(this.form_data.getLimitEndDate().getValue().getYear(), this.form_data.getLimitEndDate().getValue().getMonth() - 1, this.form_data.getLimitEndDate().getValue().getDay());
                        ALDateContainer container = this.form_data.getLimitStartDate().getValue();
                        Calendar limitStartCal = Calendar.getInstance();
                        limitStartCal.setTime(this.form_data.getStartDate().getValue());
                        limitStartCal.set(1, container.getYear());
                        limitStartCal.set(2, container.getMonth() - 1);
                        limitStartCal.set(5, container.getDay());
                        schedule.setStartDate(limitStartCal.getTime());
                    } else {
                        schedule.setStartDate(this.form_data.getStartDate().getValue());
                    }
                    schedule.setEndDate(cal.getTime());
                    if ("D".equals(this.form_data.getRepeatType().getValue())) {
                        tmpPattern = new StringBuffer().append('D').append(lim).toString();
                        schedule.setRepeatPattern(tmpPattern);
                    } else if ("W".equals(this.form_data.getRepeatType().getValue())) {
                        if ("0".equals(this.form_data.getRepeatWeek().getValue())) {
                            tmpPattern = new StringBuffer().append('W').append(this.form_data.getWeek0().getValue() != null ? 1 : 0).append(this.form_data.getWeek1().getValue() != null ? 1 : 0).append(this.form_data.getWeek2().getValue() != null ? 1 : 0).append(this.form_data.getWeek3().getValue() != null ? 1 : 0).append(this.form_data.getWeek4().getValue() != null ? 1 : 0).append(this.form_data.getWeek5().getValue() != null ? 1 : 0).append(this.form_data.getWeek6().getValue() != null ? 1 : 0).append(lim).toString();
                            schedule.setRepeatPattern(tmpPattern);
                        } else {
                            tmpPattern = new StringBuffer().append('W').append(this.form_data.getWeek0().getValue() != null ? 1 : 0).append(this.form_data.getWeek1().getValue() != null ? 1 : 0).append(this.form_data.getWeek2().getValue() != null ? 1 : 0).append(this.form_data.getWeek3().getValue() != null ? 1 : 0).append(this.form_data.getWeek4().getValue() != null ? 1 : 0).append(this.form_data.getWeek5().getValue() != null ? 1 : 0).append(this.form_data.getWeek6().getValue() != null ? 1 : 0).append(this.form_data.getRepeatWeek().getValue().charAt(0)).append(lim).toString();
                            schedule.setRepeatPattern(tmpPattern);
                        }
                    } else if ("M".equals(this.form_data.getRepeatType().getValue())) {
                        format = new DecimalFormat("00");
                        schedule.setRepeatPattern(new StringBuffer().append('M').append(format.format(this.form_data.getMonthDay().getValue())).append(lim).toString());
                    } else {
                        format = new DecimalFormat("00");
                        schedule.setRepeatPattern(new StringBuffer().append('Y').append(format.format(this.form_data.getYearMonth().getValue())).append(format.format(this.form_data.getYearDay().getValue())).append(lim).toString());
                    }
                }
                SelectQuery query = Database.query(EipTScheduleMap.class);
                Expression exp = ExpressionFactory.matchExp((String)"scheduleId", (Object)schedule.getScheduleId());
                query.setQualifier(exp);
                List schedulemaps = query.fetchList();
                Database.deleteAll((List)schedulemaps);
                for (ALEipUser user : this.form_data.getMemberList()) {
                    int userid = (int)user.getUserId().getValue();
                    map = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
                    map.setEipTSchedule(schedule);
                    map.setUserId(Integer.valueOf(userid));
                    if (userid == schedule.getOwnerId()) {
                        map.setStatus("O");
                    } else if ("T".equals(this.form_data.getChangeTmpreserveFlag().getValue())) {
                        map.setStatus("T");
                    } else {
                        EipTScheduleMap tmpMap = this.getScheduleMap(schedulemaps, userid);
                        if (tmpMap != null) {
                            map.setStatus(tmpMap.getStatus());
                        } else {
                            map.setStatus("T");
                        }
                    }
                    EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory((Long)this.common_category_id.getValue());
                    if (category == null) {
                        map.setCommonCategoryId(Integer.valueOf(1));
                        map.setEipTSchedule(schedule);
                        map.setEipTCommonCategory(category1);
                    } else {
                        map.setCommonCategoryId(Integer.valueOf((int)this.common_category_id.getValue()));
                        map.setEipTSchedule(schedule);
                        map.setEipTCommonCategory(category);
                    }
                    map.setType("U");
                }
                if ("O".equals(this.public_flag.getValue()) || "C".equals(this.public_flag.getValue())) {
                    for (FacilityResultData frd : this.form_data.getFacilityMemberList()) {
                        int facilityid = (int)frd.getFacilityId().getValue();
                        map = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
                        map.setEipTSchedule(schedule);
                        map.setUserId(Integer.valueOf(facilityid));
                        map.setStatus("O");
                        map.setType("F");
                        map.setEipTCommonCategory(category1);
                        map.setCommonCategoryId(Integer.valueOf(1));
                    }
                }
            }
            Database.commit();
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"mode", (String)"update");
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(schedule.getScheduleId().intValue(), 240, schedule.getName());
            ALEipUser loginUser = this.getLoginUser();
            List<ALEipUser> memberList = this.form_data.getMemberList();
            if (loginUser != null) {
                String loginName = loginUser.getName().getValue();
                ArrayList<String> recipients = new ArrayList<String>();
                for (ALEipUser user : memberList) {
                    if (loginUser.getUserId().getValue() == user.getUserId().getValue()) continue;
                    recipients.add(user.getName().getValue());
                }
                ScheduleUtils.createShareScheduleActivity(schedule, loginName, recipients, "edit", ownerid);
                if ("O".equals(this.public_flag.toString())) {
                    ScheduleUtils.createNewScheduleActivity(schedule, loginName, "edit", ownerid);
                }
            }
        }
        catch (RuntimeException e) {
            Database.rollback();
            logger.error((Object)"[ScheduleFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"[ScheduleFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        try {
            int msgType = ALMailUtils.getSendDestType((int)24);
            if (msgType > 0) {
                List destMemberList = ALMailUtils.getALEipUserAddrs(this.form_data.getMemberList(), (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
                String subject = ALLocalizationUtils.getl10nFormat((String)"SCHEDULE_SUB_SCHEDULE", (Object[])new Object[]{ALOrgUtilsService.getAlias()});
                String org_id = ALOrgUtilsService.getAlias();
                ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
                for (ALEipUserAddr destMember : destMemberList) {
                    ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                    message.setPcSubject(subject);
                    message.setCellularSubject(subject);
                    message.setPcBody(ScheduleUtils.createMsgForPc(rundata, schedule, this.form_data.getMemberList(), "edit"));
                    message.setCellularBody(ScheduleUtils.createMsgForCellPhone(rundata, schedule, this.form_data.getMemberList(), destMember.getUserId(), "edit"));
                    messageList.add(message);
                }
                ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(org_id, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)24)));
            }
        }
        catch (Exception ex) {
            msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_DONOT_SEND_MAIL"));
            logger.error((Object)"schedule", (Throwable)ex);
            return false;
        }
        return true;
    }

    private EipTScheduleMap getScheduleMap(List<EipTScheduleMap> scheduleMaps, int userid) {
        for (EipTScheduleMap map : scheduleMaps) {
            if (map.getUserId() != userid) continue;
            return map;
        }
        return null;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            if (rundata.getParameters().containsKey((Object)"del_flag")) {
                this.del_flag.setValue(rundata.getParameters().getString("del_flag"));
            }
            if (this.del_flag.getValue() == 1L) {
                this.del_member_flag.setValue(0L);
                this.del_range_flag.setValue(1L);
            } else if (this.del_flag.getValue() == 2L) {
                this.del_member_flag.setValue(1L);
                this.del_range_flag.setValue(0L);
            } else if (this.del_flag.getValue() == 3L) {
                this.del_member_flag.setValue(1L);
                this.del_range_flag.setValue(1L);
            } else {
                this.del_member_flag.setValue(0L);
                this.del_range_flag.setValue(0L);
            }
            EipTSchedule schedule = ScheduleUtils.getEipTSchedule(rundata, context, false);
            if (schedule == null) {
                return false;
            }
            List<ALEipUser> members = ScheduleUtils.getUsers(rundata, context, true);
            if (members != null && members.size() > 0) {
                this.form_data.getMemberList().addAll(members);
            }
            boolean isMember = false;
            int loginuserId = (int)this.getLoginUser().getUserId().getValue();
            int membersSize = this.form_data.getMemberList().size();
            ALEipUser eipUser = null;
            for (int i = 0; i < membersSize; ++i) {
                eipUser = this.form_data.getMemberList().get(i);
                if ((long)loginuserId != eipUser.getUserId().getValue()) continue;
                isMember = true;
                break;
            }
            if (!isMember) {
                logger.error((Object)"[ScheduleFormData] ALPageNotFoundException: The user does not have the auth to delete the schedule.");
                throw new ALPageNotFoundException();
            }
            if (loginuserId != schedule.getOwnerId() && "F".equals(schedule.getEditFlag()) && 1L != this.del_member_flag.getValue()) {
                return true;
            }
            int delFlag = -1;
            delFlag = this.del_member_flag.getValue() == 0L ? (this.del_range_flag.getValue() == 0L ? 0 : 1) : (this.del_range_flag.getValue() == 0L ? 2 : 3);
            if (delFlag == 0) {
                this.deleteSchedule(schedule);
            } else if (delFlag == 1) {
                if (!"N".equals(schedule.getRepeatPattern())) {
                    int ownerid = ALEipUtils.getUserId((RunData)rundata);
                    int memberIdListSize = this.form_data.getMemberList().size();
                    int[] memberIdList = new int[memberIdListSize];
                    for (int i = 0; i < memberIdListSize; ++i) {
                        memberIdList[i] = (int)this.form_data.getMemberList().get(i).getUserId().getValue();
                    }
                    ScheduleUtils.insertDummySchedule(schedule, ownerid, this.form_data.getViewDate().getValue(), this.form_data.getViewDate().getValue(), memberIdList);
                }
            } else if (delFlag == 2) {
                List<EipTScheduleMap> scheduleMaps = ScheduleUtils.getEipTScheduleMaps(schedule);
                if (scheduleMaps != null && scheduleMaps.size() > 0) {
                    int rejectedScheduleCount = 0;
                    ArrayList<EipTScheduleMap> userScheduleMap = new ArrayList<EipTScheduleMap>();
                    for (EipTScheduleMap scheduleMap : scheduleMaps) {
                        if (!"U".equals(scheduleMap.getType())) continue;
                        userScheduleMap.add(scheduleMap);
                        if (!"R".equals(scheduleMap.getStatus())) continue;
                        ++rejectedScheduleCount;
                    }
                    int scheduleUserCount = userScheduleMap.size();
                    if (rejectedScheduleCount >= scheduleUserCount - 1) {
                        this.deleteSchedule(schedule);
                    } else {
                        for (EipTScheduleMap scheduleMap : userScheduleMap) {
                            if ((long)scheduleMap.getUserId().intValue() != this.getLoginUser().getUserId().getValue() || (long)scheduleMap.getUserId().intValue() != this.getLoginUser().getUserId().getValue() && (long)schedule.getCreateUserId().intValue() != this.getLoginUser().getUserId().getValue()) continue;
                            if ("O".equals(scheduleMap.getStatus())) {
                                schedule.setOwnerId(Integer.valueOf(0));
                                if ("F".equals(schedule.getEditFlag())) {
                                    schedule.setEditFlag("T");
                                }
                            }
                            scheduleMap.setStatus("R");
                        }
                    }
                }
            } else if (delFlag == 3) {
                if (!"N".equals(schedule.getRepeatPattern())) {
                    int ownerid = ALEipUtils.getUserId((RunData)rundata);
                    this.form_data.getMemberList().clear();
                    this.form_data.getMemberList().add(this.getLoginUser());
                    int memberIdListSize = this.form_data.getMemberList().size();
                    int[] memberIdList = new int[memberIdListSize];
                    for (int i = 0; i < memberIdListSize; ++i) {
                        memberIdList[i] = (int)this.form_data.getMemberList().get(i).getUserId().getValue();
                    }
                    ScheduleUtils.insertDummySchedule(schedule, ownerid, this.form_data.getViewDate().getValue(), this.form_data.getViewDate().getValue(), memberIdList);
                }
            } else {
                Database.delete((Persistent)schedule);
            }
            Database.commit();
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"mode", (String)"delete");
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(schedule.getScheduleId().intValue(), 240, schedule.getName());
        }
        catch (RuntimeException e) {
            Database.rollback();
            logger.error((Object)"[ScheduleFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"[ScheduleFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    private void deleteSchedule(EipTSchedule schedule) {
        int scheduleId = schedule.getScheduleId();
        Database.delete((Persistent)schedule);
        SelectQuery query = Database.query(EipTSchedule.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"parentId", (Object)scheduleId);
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"eipTScheduleMaps.status", (Object)"D");
        query.andQualifier(exp2);
        List dellist = query.fetchList();
        if (dellist != null && dellist.size() > 0) {
            Database.deleteAll((List)dellist);
        }
    }

    private boolean facilityCheckAclPermission(RunData rundata, int aclType) {
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "schedule_facility", aclType);
        return this.hasAuthority;
    }

    public ALStringField getName() {
        return this.name;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALStringField getPlace() {
        return this.place;
    }

    public ALStringField getPublicFlag() {
        return this.public_flag;
    }

    @Override
    public List<ALEipGroup> getGroupList() {
        return this.groups;
    }
}

