/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.CellScheduleResultData;
import com.aimluck.eip.schedule.ScheduleWeeklySelectData;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Ordering;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CellScheduleWeekSelectData
extends ALAbstractSelectData<List<EipTScheduleMap>, List<EipTScheduleMap>> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleWeeklySelectData.class.getName());
    private ALDateTimeField startDate;
    private ALDateTimeField endDate;
    private ALDateTimeField nextweekDate;
    private ALDateTimeField prevweekDate;
    private String aclPortletFeature;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.startDate = new ALDateTimeField("yyyy-MM-dd");
        this.endDate = new ALDateTimeField("yyyy-MM-dd");
        this.nextweekDate = new ALDateTimeField("yyyy-MM-dd");
        this.prevweekDate = new ALDateTimeField("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        if (rundata.getParameters().getString("start_date") != null) {
            String str = rundata.getParameters().getString("start_date");
            ALDateTimeField date = new ALDateTimeField("yyyy-MM-dd");
            date.setValue(str);
            cal.setTime(date.getValue());
        }
        cal.set(11, 0);
        cal.set(12, 0);
        this.startDate.setValue(cal.getTime());
        cal.add(5, 6);
        this.endDate.setValue(cal.getTime());
        cal.add(5, 1);
        this.nextweekDate.setValue(cal.getTime());
        cal.add(5, -14);
        this.prevweekDate.setValue(cal.getTime());
        this.aclPortletFeature = "schedule_self";
    }

    protected Object getResultData(List<EipTScheduleMap> scheduleDayList) throws ALPageNotFoundException, ALDBErrorException {
        ArrayList<CellScheduleResultData> resultList = new ArrayList<CellScheduleResultData>();
        int s = scheduleDayList.size();
        EipTScheduleMap map = null;
        for (int k = 0; k < s; ++k) {
            CellScheduleResultData rd = new CellScheduleResultData();
            rd.initField();
            map = scheduleDayList.get(k);
            rd.setScheduleId(map.getScheduleId());
            rd.setName(map.getEipTSchedule().getName());
            rd.setStartDate(map.getEipTSchedule().getStartDate());
            rd.setEndDate(map.getEipTSchedule().getEndDate());
            rd.setPublic(map.getEipTSchedule().getPublicFlag().equals("O"));
            rd.setRepeat(map.getEipTSchedule().getRepeatPattern().equals("S"));
            rd.setPattern(map.getEipTSchedule().getRepeatPattern());
            rd.setMember(true);
            if (rd.getPattern().equals("S")) {
                rd.setSpan(true);
            }
            resultList.add(rd);
        }
        return resultList;
    }

    protected ResultList<List<EipTScheduleMap>> selectList(RunData rundata, Context context) {
        List list2;
        ArrayList<List> scheduleMapList = new ArrayList<List>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.startDate.getValue());
        int userid = ALEipUtils.getUserId((RunData)rundata);
        Expression expm1 = ExpressionFactory.matchExp((String)"userId", (Object)userid);
        Expression expm2 = ExpressionFactory.noMatchExp((String)"status", (Object)"D");
        Expression expm3 = ExpressionFactory.noMatchExp((String)"status", (Object)"R");
        Expression expm4 = ExpressionFactory.matchExp((String)"type", (Object)"U");
        Expression mapExpression = expm1.andExp(expm2).andExp(expm3).andExp(expm4);
        for (int k = 0; k < 7; ++k) {
            SelectQuery query = Database.query(EipTScheduleMap.class);
            Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"eipTSchedule.endDate", (Object)cal.getTime());
            cal.add(5, 1);
            Expression exp12 = ExpressionFactory.lessExp((String)"eipTSchedule.startDate", (Object)cal.getTime());
            Expression exp13 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"N");
            Expression exp14 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"S");
            Expression exp10 = exp11.andExp(exp12.andExp(exp13.orExp(exp14)));
            Expression exp21 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"DN");
            Expression exp22 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"DL");
            Expression exp20 = exp21.orExp(exp22.andExp(exp11).andExp(exp12));
            query.setQualifier(exp10.orExp(exp20).andExp(mapExpression));
            ArrayList<Ordering> orders = new ArrayList<Ordering>();
            orders.add(new Ordering("eipTSchedule.startDate", true));
            orders.add(new Ordering("eipTSchedule.endDate", true));
            query.getQuery().addOrderings(orders);
            List list = query.fetchList();
            scheduleMapList.add(list);
        }
        SelectQuery query = Database.query(EipTScheduleMap.class);
        Expression exp2 = ExpressionFactory.noMatchExp((String)"eipTSchedule.repeatPattern", (Object)"N");
        Expression exp3 = ExpressionFactory.noMatchExp((String)"eipTSchedule.repeatPattern", (Object)"S");
        query.setQualifier(mapExpression.andExp(exp2).andExp(exp3));
        List list = query.fetchList();
        EipTSchedule schedule = null;
        for (int k = 0; k < list.size(); ++k) {
            int day;
            schedule = ((EipTScheduleMap)list.get(k)).getEipTSchedule();
            String pattern = schedule.getRepeatPattern();
            if (pattern.startsWith("W")) {
                for (int l = 0; l < 7; ++l) {
                    List list22;
                    if (pattern.charAt(l + 1) != '1') continue;
                    int index = (l - cal.get(7) + 7 + 1) % 7;
                    Calendar cal3 = Calendar.getInstance();
                    cal3.setTime(cal.getTime());
                    cal3.add(5, -(7 - index));
                    if (pattern.length() != 9 && cal3.get(8) != Character.getNumericValue(pattern.charAt(8))) continue;
                    Calendar cal2 = Calendar.getInstance();
                    cal2.setTime(this.startDate.getValue());
                    cal2.add(5, index);
                    if (pattern.endsWith("L")) {
                        if (schedule.getEndDate().compareTo(cal2.getTime()) < 0) continue;
                        cal2.add(5, 1);
                        if (schedule.getStartDate().compareTo(cal2.getTime()) >= 0) continue;
                        list22 = (List)scheduleMapList.get(index);
                        list22.add(list.get(k));
                        scheduleMapList.set(index, list22);
                        continue;
                    }
                    list22 = (List)scheduleMapList.get(index);
                    list22.add(list.get(k));
                    scheduleMapList.set(index, list22);
                }
                continue;
            }
            if (pattern.startsWith("M")) {
                day = Integer.parseInt(pattern.substring(1, pattern.length() - 1));
                Calendar cal2 = Calendar.getInstance();
                Calendar cal_event = Calendar.getInstance();
                cal2.setTime(this.startDate.getValue());
                cal2.set(5, day);
                cal_event.setTime(this.startDate.getValue());
                int index = day - cal_event.get(5);
                if (index < 0) {
                    index += cal_event.getActualMaximum(5);
                    cal2.add(2, 1);
                }
                if (index < 0 || index > 6 || cal_event.getActualMaximum(5) < day) continue;
                if (pattern.endsWith("L")) {
                    if (schedule.getEndDate().compareTo(cal2.getTime()) < 0) continue;
                    cal2.add(5, 1);
                    if (schedule.getStartDate().compareTo(cal2.getTime()) >= 0) continue;
                    List list23 = (List)scheduleMapList.get(index);
                    list23.add(list.get(k));
                    scheduleMapList.set(index, list23);
                    continue;
                }
                List list24 = (List)scheduleMapList.get(index);
                list24.add(list.get(k));
                scheduleMapList.set(index, list24);
                continue;
            }
            if (!pattern.startsWith("Y")) continue;
            day = Integer.parseInt(pattern.substring(3, 5));
            int month = Integer.parseInt(pattern.substring(1, 3));
            Calendar cal2 = Calendar.getInstance();
            Calendar cal_event = Calendar.getInstance();
            cal2.setTime(this.startDate.getValue());
            cal2.set(5, day);
            cal2.set(2, month - 1);
            cal_event.setTime(this.startDate.getValue());
            int index = day - cal_event.get(5);
            if (index < 0) {
                index += cal_event.getActualMaximum(5);
                cal_event.add(2, 1);
            }
            if (index < 0 || index > 6 || cal_event.getActualMaximum(5) < day || cal_event.get(2) + 1 != month) continue;
            if (pattern.endsWith("L")) {
                if (schedule.getEndDate().compareTo(cal2.getTime()) < 0) continue;
                cal2.add(5, 1);
                if (schedule.getStartDate().compareTo(cal2.getTime()) >= 0) continue;
                list2 = (List)scheduleMapList.get(index);
                list2.add(list.get(k));
                scheduleMapList.set(index, list2);
                continue;
            }
            list2 = (List)scheduleMapList.get(index);
            list2.add(list.get(k));
            scheduleMapList.set(index, list2);
        }
        SelectQuery queryD = Database.query(EipTScheduleMap.class);
        Expression expD2 = ExpressionFactory.matchExp((String)"status", (Object)"D");
        queryD.setQualifier(expm1.andExp(expm4).andExp(expD2));
        List listD = queryD.fetchList();
        for (int k = 0; k < 7; ++k) {
            Calendar calD = Calendar.getInstance();
            calD.setTime(this.startDate.getValue());
            calD.add(5, k);
            EipTSchedule scheduleD = null;
            for (int l = 0; l < listD.size(); ++l) {
                scheduleD = ((EipTScheduleMap)listD.get(l)).getEipTSchedule();
                if (scheduleD.getEndDate().compareTo(calD.getTime()) < 0) continue;
                calD.add(5, 1);
                if (scheduleD.getStartDate().compareTo(calD.getTime()) < 0) {
                    list2 = (List)scheduleMapList.get(k);
                    EipTSchedule scheduleM = null;
                    for (int m = 0; m < list2.size(); ++m) {
                        scheduleM = ((EipTScheduleMap)list2.get(m)).getEipTSchedule();
                        if (scheduleD.getParentId().intValue() != scheduleM.getScheduleId().intValue()) continue;
                        list2.remove(m);
                        scheduleMapList.set(k, list2);
                        break;
                    }
                }
                calD.add(5, -1);
            }
        }
        int size = scheduleMapList.size();
        for (int i = 0; i < size; ++i) {
            List slist = (List)scheduleMapList.get(i);
            Collections.sort(slist, new Comparator<EipTScheduleMap>(){

                @Override
                public int compare(EipTScheduleMap a, EipTScheduleMap b) {
                    Calendar cal = Calendar.getInstance();
                    Calendar cal2 = Calendar.getInstance();
                    EipTSchedule p1 = null;
                    EipTSchedule p2 = null;
                    try {
                        p1 = a.getEipTSchedule();
                        p2 = b.getEipTSchedule();
                    }
                    catch (Exception e) {
                        logger.error((Object)"schedule", (Throwable)e);
                    }
                    if (p1.getRepeatPattern().equals("S")) {
                        if (!p2.getRepeatPattern().equals("S")) {
                            return -1;
                        }
                    } else if (p2.getRepeatPattern().equals("S")) {
                        return 1;
                    }
                    cal.setTime(p1.getStartDate());
                    cal.set(0, 0, 0);
                    cal2.setTime(p2.getStartDate());
                    cal2.set(0, 0, 0);
                    if (cal.getTime().compareTo(cal2.getTime()) != 0) {
                        return cal.getTime().compareTo(cal2.getTime());
                    }
                    cal.setTime(p1.getEndDate());
                    cal.set(0, 0, 0);
                    cal2.setTime(p2.getEndDate());
                    cal2.set(0, 0, 0);
                    return cal.getTime().compareTo(cal2.getTime());
                }
            });
            scheduleMapList.set(i, slist);
        }
        return new ResultList(scheduleMapList);
    }

    protected Object getResultDataDetail(List<EipTScheduleMap> object) {
        return null;
    }

    protected List<EipTScheduleMap> selectDetail(RunData rundata, Context context) {
        return null;
    }

    protected Attributes getColumnMap() {
        return null;
    }

    public String getNow() {
        Calendar cal = Calendar.getInstance();
        StringBuffer day = new StringBuffer();
        day.append(cal.get(1)).append("-").append(cal.get(2) + 1).append("-").append(cal.get(5));
        return day.toString();
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }

    protected ALDateTimeField getStartDate() {
        return this.startDate;
    }
}

