/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipHolidaysManager;
import com.aimluck.eip.common.ALHoliday;
import com.aimluck.eip.schedule.ScheduleResultData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ScheduleDayContainer
implements ALData {
    private ALDateTimeField today;
    private List<ScheduleResultData> scheduleList;
    private ScheduleResultData spanRd;
    private boolean is_hasspan = false;
    private ALHoliday holiday;

    public void initField() {
        this.today = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        this.scheduleList = new ArrayList<ScheduleResultData>();
        this.spanRd = null;
    }

    public List<ScheduleResultData> getScheduleList() {
        return this.scheduleList;
    }

    public void setDate(Date date) {
        this.today.setValue(date);
        ALEipHolidaysManager holidaysManager = ALEipHolidaysManager.getInstance();
        this.holiday = holidaysManager.isHoliday(date);
    }

    public ALDateTimeField getDate() {
        return this.today;
    }

    public String getToday() {
        return this.today.toString("yyyy-MM-dd");
    }

    public void setHasspan(boolean bool) {
        this.is_hasspan = bool;
    }

    public boolean isSpanNull() {
        return this.spanRd == null;
    }

    public boolean isHasspan() {
        return this.is_hasspan;
    }

    public void addResultData(ScheduleResultData rd) {
        int size = this.scheduleList.size();
        boolean canAdd = true;
        boolean repeat_del = false;
        for (int i = 0; i < size; ++i) {
            repeat_del = false;
            ScheduleResultData rd2 = this.scheduleList.get(i);
            if (rd.isRepeat() && rd2.isDummy() && rd.getScheduleId().getValue() == rd2.getParentId().getValue() && ScheduleUtils.equalsToDate(rd.getStartDate().getValue(), rd2.getStartDate().getValue(), false)) {
                canAdd = false;
                break;
            }
            if (rd2.isRepeat() && rd.isDummy() && rd2.getScheduleId().getValue() == rd.getParentId().getValue() && ScheduleUtils.equalsToDate(rd.getStartDate().getValue(), rd2.getStartDate().getValue(), false)) {
                this.scheduleList.remove(rd2);
                canAdd = true;
                repeat_del = true;
            }
            if (repeat_del || rd.isDummy() || rd2.isDummy() || !(rd.getStartDate().getValue().before(rd2.getStartDate().getValue()) && rd2.getStartDate().getValue().before(rd.getEndDate().getValue()) || rd2.getStartDate().getValue().before(rd.getStartDate().getValue()) && rd.getStartDate().getValue().before(rd2.getEndDate().getValue()) || rd.getStartDate().getValue().before(rd2.getEndDate().getValue()) && rd2.getEndDate().getValue().before(rd.getEndDate().getValue()) || rd2.getStartDate().getValue().before(rd.getEndDate().getValue()) && rd.getEndDate().getValue().before(rd2.getEndDate().getValue())) && (!rd.getEndDate().getValue().equals(rd2.getEndDate().getValue()) || !rd.getStartDate().getValue().equals(rd2.getStartDate().getValue()))) continue;
            rd2.setDuplicate(true);
            rd.setDuplicate(true);
        }
        if (canAdd) {
            this.scheduleList.add(rd);
        }
    }

    public void setSpanResultData(ScheduleResultData rd) {
        this.spanRd = rd;
    }

    public ScheduleResultData getSpanResultData() {
        return this.spanRd;
    }

    public boolean isHoliday() {
        return this.holiday != null;
    }

    public ALHoliday getHoliday() {
        return this.holiday;
    }
}

