/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateContainer;
import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.category.util.CommonCategoryUtils;
import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.mail.ALAdminMailContext;
import com.aimluck.eip.mail.ALAdminMailMessage;
import com.aimluck.eip.mail.ALMailService;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.MailSendException;
import com.aimluck.eip.schedule.ScheduleOnedayGroupSelectData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.timeline.util.TimelineUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ScheduleFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleFormData.class.getName());
    private static final int FLAG_EDIT_REPEAT_DEF = -1;
    private static final int FLAG_EDIT_REPEAT_ALL = 0;
    private static final int FLAG_EDIT_REPEAT_ONE = 1;
    public static final int FLAG_DEL_MEMBER_ALL = 0;
    public static final int FLAG_DEL_MEMBER_ONE = 1;
    public static final int FLAG_DEL_RANGE_ALL = 0;
    public static final int FLAG_DEL_RANGE_ONE = 1;
    private ALDateTimeField start_date;
    private ALDateTimeField end_date;
    private ALStringField name;
    private ALStringField place;
    private ALStringField note;
    private ALStringField public_flag;
    private ALStringField repeat_type;
    private ALStringField week_0;
    private ALStringField week_1;
    private ALStringField week_2;
    private ALStringField week_3;
    private ALStringField week_4;
    private ALStringField week_5;
    private ALStringField week_6;
    private ALStringField repeat_week;
    private ALStringField limit_flag;
    private ALDateField limit_start_date;
    private ALDateField limit_end_date;
    private ALNumberField month_day;
    private ALNumberField year_month;
    private ALNumberField year_day;
    private ArrayList<ALEipUser> memberList;
    private int currentYear;
    private boolean is_member;
    private boolean is_repeat;
    private boolean is_span;
    private ALStringField all_day_flag;
    private ALEipUser login_user;
    private String tmpStart;
    private String tmpEnd;
    private ScheduleOnedayGroupSelectData selectData;
    private List<ALEipGroup> groups;
    private ALNumberField edit_repeat_flag;
    private String tmpView;
    private ALDateTimeField view_date;
    private ALStringField edit_flag;
    private ALStringField change_tmpreserve_flag;
    private ALNumberField del_member_flag;
    private ALNumberField del_range_flag;
    private boolean is_owner;
    private boolean is_facility;
    private List<Object> facilityList;
    private List<FacilityResultData> facilityAllList;
    private ALNumberField common_category_id;
    private String mail_flag = "A";
    private final int msg_type = 0;
    private String orgId;
    private ALEipUser loginUser;
    private boolean ignore_duplicate_facility;
    private boolean is_copy;
    private boolean is_same_date;
    private String aclPortletFeature = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String scheduleId;
        this.is_facility = rundata.getParameters().getBoolean("is_facility");
        this.is_member = rundata.getParameters().getBoolean("is_member");
        this.is_repeat = rundata.getParameters().getBoolean("is_repeat");
        this.is_span = rundata.getParameters().getBoolean("is_span");
        this.is_copy = rundata.getParameters().getBoolean("is_copy");
        String tmp_mail_flag = rundata.getParameters().getString("mail_flag");
        this.mail_flag = "A".equals(tmp_mail_flag) ? "A" : ("N".equals(tmp_mail_flag) ? "N" : "A");
        this.ignore_duplicate_facility = rundata.getParameters().getBoolean("ignore_duplicate_facility", false);
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
        this.groups = ALEipUtils.getMyGroups((RunData)rundata);
        this.is_owner = true;
        this.orgId = Database.getDomainName();
        this.loginUser = ALEipUtils.getALEipUser((RunData)rundata);
        this.facilityAllList = new ArrayList<FacilityResultData>();
        this.facilityAllList.addAll(FacilitiesUtils.getFacilityAllList());
        if (this.tmpEnd != null && !this.tmpEnd.equals("") && this.tmpStart != null && !this.tmpStart.equals("") && this.is_span && this.tmpStart.equals(this.tmpEnd)) {
            this.all_day_flag.setValue("ON");
        }
        if ((scheduleId = rundata.getParameters().getString("entityid")) == null || scheduleId.equals("new")) {
            String[] members = rundata.getParameters().getStrings("member_to");
            if (members != null && members.length > 0) {
                this.aclPortletFeature = "schedule_other";
                String user_name = this.login_user.getName().toString();
                for (String member : members) {
                    if (!user_name.equals(member)) continue;
                    this.aclPortletFeature = "schedule_self";
                    break;
                }
            } else {
                this.aclPortletFeature = "schedule_self";
            }
        } else {
            this.aclPortletFeature = ScheduleUtils.hasRelation(rundata) ? "schedule_self" : "schedule_other";
        }
        super.init(action, rundata, context);
    }

    public void loadParametersViewDate(RunData rundata, Context context) {
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            if (rundata.getParameters().containsKey((Object)"view_date")) {
                ALDateTimeField dummy = new ALDateTimeField("yyyy-MM-dd");
                this.tmpView = rundata.getParameters().getString("view_date");
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpView", (String)this.tmpView);
                dummy.setValue(this.tmpView);
                if (!dummy.validate(new ArrayList())) {
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"tmpView");
                    logger.debug((Object)"[ScheduleFormData] Parameter cannot validate");
                    ALEipUtils.redirectPageNotFound((RunData)rundata);
                    return;
                }
            } else if ((this.tmpView == null || this.tmpView.equals("")) && this.tmpStart != null && !this.tmpStart.equals("")) {
                this.tmpView = this.tmpStart;
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpView", (String)this.tmpView);
            }
        }
    }

    public void loadParameters(RunData rundata, Context context) {
        ALDateTimeField dummy = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        dummy.setNotNull(true);
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            Date date;
            if (rundata.getParameters().containsKey((Object)"form_start")) {
                this.tmpStart = rundata.getParameters().getString("form_start");
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpStart", (String)this.tmpStart);
                dummy.setValue(this.tmpStart);
                if (!dummy.validate(new ArrayList())) {
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"form_start");
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"form_end");
                    logger.debug((Object)"[ScheduleFormData] Parameter cannot validate");
                    ALEipUtils.redirectPageNotFound((RunData)rundata);
                    return;
                }
            } else {
                date = new Date();
                Calendar tmpStartCal = Calendar.getInstance();
                tmpStartCal.setTime(date);
                int startHour = tmpStartCal.get(11);
                if (startHour != 23) {
                    tmpStartCal.set(11, startHour + 1);
                    tmpStartCal.set(12, 0);
                }
                dummy.setValue(tmpStartCal.getTime());
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpStart", (String)dummy.toString());
            }
            if (rundata.getParameters().containsKey((Object)"form_end")) {
                this.tmpEnd = rundata.getParameters().getString("form_end");
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpEnd", (String)this.tmpEnd);
                dummy.setValue(this.tmpEnd);
                if (!dummy.validate(new ArrayList())) {
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"form_start");
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"form_end");
                    logger.debug((Object)"[ScheduleFormData] Parameter cannot validate");
                    ALEipUtils.redirectPageNotFound((RunData)rundata);
                    return;
                }
            } else {
                date = new Date();
                Calendar tmpEndCal = Calendar.getInstance();
                tmpEndCal.setTime(date);
                int endHour = tmpEndCal.get(11);
                if (endHour != 22 && endHour != 23) {
                    tmpEndCal.set(11, endHour + 2);
                    tmpEndCal.set(12, 0);
                } else if (endHour == 22) {
                    tmpEndCal.set(11, endHour + 1);
                    tmpEndCal.set(12, 55);
                }
                dummy.setValue(tmpEndCal.getTime());
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpEnd", (String)dummy.toString());
            }
        }
        this.tmpStart = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tmpStart");
        this.tmpEnd = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tmpEnd");
        this.loadParametersViewDate(rundata, context);
    }

    public void initField() {
        Date now = new Date();
        Calendar cal = Calendar.getInstance();
        int min = cal.get(12);
        for (int _min = 5; _min <= 60; _min += 5) {
            if (_min - 5 > min || min > _min) continue;
            cal.set(12, _min);
            break;
        }
        this.start_date = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        if (this.tmpStart == null || this.tmpStart.equals("")) {
            this.start_date.setValue(now);
        } else {
            this.start_date.setValue(this.tmpStart);
        }
        this.start_date.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_START_DATE"));
        this.end_date = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        if (this.tmpEnd == null || this.tmpEnd.equals("")) {
            if (this.tmpStart == null || this.tmpStart.equals("")) {
                this.end_date.setValue(now);
            } else {
                this.end_date.setValue(this.tmpStart);
            }
        } else {
            this.end_date.setValue(this.tmpEnd);
        }
        this.end_date.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_END_DATE"));
        if (this.start_date.toString().equals(this.end_date.toString())) {
            this.is_same_date = true;
            Calendar tmpEndCal = Calendar.getInstance();
            tmpEndCal.setTime(this.end_date.getValue());
            int endHour = tmpEndCal.get(11);
            if (endHour != 23) {
                tmpEndCal.set(11, endHour);
            }
            this.end_date.setValue(tmpEndCal.getTime());
        } else {
            this.is_same_date = false;
        }
        Calendar tmpStartCal = Calendar.getInstance();
        tmpStartCal.setTime(this.start_date.getValue());
        int startMinute = tmpStartCal.get(12);
        if (startMinute > 55) {
            int startHour = tmpStartCal.get(11);
            if (startHour != 23) {
                tmpStartCal.set(11, startHour + 1);
                tmpStartCal.set(12, 0);
            } else {
                tmpStartCal.set(12, 55);
            }
        } else if (startMinute % 5 != 0) {
            tmpStartCal.set(12, startMinute + (5 - startMinute % 5));
        }
        this.start_date.setValue(tmpStartCal.getTime());
        Calendar tmpEndCal = Calendar.getInstance();
        tmpEndCal.setTime(this.end_date.getValue());
        int endMinute = tmpEndCal.get(12);
        if (endMinute > 55) {
            int endHour = tmpEndCal.get(11);
            if (endHour != 23) {
                tmpEndCal.set(11, endHour + 1);
                tmpEndCal.set(12, 0);
            } else {
                tmpEndCal.set(12, 55);
            }
        } else if (endMinute % 5 != 0) {
            tmpEndCal.set(12, endMinute + (5 - endMinute % 5));
        }
        this.end_date.setValue(tmpEndCal.getTime());
        this.repeat_type = new ALStringField();
        this.repeat_type.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_REPEAT_TYPE"));
        this.repeat_type.setValue("D");
        this.repeat_type.setTrim(true);
        this.week_0 = new ALStringField();
        this.week_0.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_SUNDAY"));
        this.week_0.setTrim(true);
        this.week_1 = new ALStringField();
        this.week_1.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_MANDAY"));
        this.week_1.setTrim(true);
        this.week_2 = new ALStringField();
        this.week_2.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_TUSEDAY"));
        this.week_2.setTrim(true);
        this.week_3 = new ALStringField();
        this.week_3.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_WEDNESDAY"));
        this.week_3.setTrim(true);
        this.week_4 = new ALStringField();
        this.week_4.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_THURSDAY"));
        this.week_4.setTrim(true);
        this.week_5 = new ALStringField();
        this.week_5.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_FRIDAY"));
        this.week_5.setTrim(true);
        this.week_6 = new ALStringField();
        this.week_6.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_SATURDAY"));
        this.week_6.setTrim(true);
        this.repeat_week = new ALStringField();
        this.repeat_week.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_REPEAT_WEEK"));
        this.repeat_week.setTrim(true);
        this.month_day = new ALNumberField();
        this.month_day.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_REPEAT_MONTH"));
        this.year_day = new ALNumberField();
        this.year_day.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_REPEAT_YEAR_DAY"));
        this.year_month = new ALNumberField();
        this.year_month.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_REPEAT_YEAR_MONTH"));
        this.limit_flag = new ALStringField();
        this.limit_flag.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_REPEAT"));
        this.limit_flag.setValue("OFF");
        this.limit_flag.setTrim(true);
        this.limit_start_date = new ALDateField();
        this.limit_start_date.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_REPEAT_LIMIT"));
        this.limit_start_date.setValue(this.start_date.getValue());
        this.limit_end_date = new ALDateField();
        this.limit_end_date.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_REPEAT_LIMIT"));
        ALDateTimeField tmp_date = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        if (this.tmpEnd == null || this.tmpEnd.equals("")) {
            if (this.tmpStart == null || this.tmpStart.equals("")) {
                tmp_date.setValue(now);
                this.limit_end_date.setValue(tmp_date.getValue());
            } else {
                tmp_date.setValue(this.tmpStart);
                this.limit_end_date.setValue(tmp_date.getValue());
            }
        } else {
            tmp_date.setValue(this.tmpEnd);
            this.limit_end_date.setValue(tmp_date.getValue());
        }
        this.all_day_flag = new ALStringField();
        this.all_day_flag.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_ALL_DAY"));
        this.all_day_flag.setTrim(true);
        this.all_day_flag.setValue("OFF");
        this.name = new ALStringField();
        this.name.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_TITLE"));
        this.name.setTrim(true);
        this.place = new ALStringField();
        this.place.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_PLACE"));
        this.place.setTrim(true);
        this.note = new ALStringField();
        this.note.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_NOTE"));
        this.note.setTrim(false);
        this.public_flag = new ALStringField();
        this.public_flag.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_PUBLIC"));
        this.public_flag.setTrim(true);
        this.public_flag.setValue("O");
        this.edit_repeat_flag = new ALNumberField();
        this.edit_repeat_flag.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_REPEAT_EDIT_AREA"));
        this.edit_repeat_flag.setValue(-1L);
        this.view_date = new ALDateTimeField("yyyy-MM-dd");
        if (this.tmpView == null || this.tmpView.equals("")) {
            this.view_date.setValue(now);
        } else {
            this.view_date.setValue(this.tmpView);
        }
        this.view_date.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_SELECT_DATE"));
        this.edit_flag = new ALStringField();
        this.edit_flag.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_EDIT_DELETE_PERMISSION"));
        this.edit_flag.setTrim(true);
        this.edit_flag.setValue("T");
        this.change_tmpreserve_flag = new ALStringField();
        this.change_tmpreserve_flag.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_TEMP_SCHEDULE"));
        this.change_tmpreserve_flag.setTrim(true);
        this.change_tmpreserve_flag.setValue("F");
        this.memberList = new ArrayList();
        this.currentYear = Calendar.getInstance().get(1);
        this.del_member_flag = new ALNumberField();
        this.del_member_flag.setValue(0L);
        this.del_range_flag = new ALNumberField();
        this.del_range_flag.setValue(0L);
        this.facilityList = new ArrayList<Object>();
        this.common_category_id = new ALNumberField();
        this.common_category_id.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_CATEGORY"));
        this.common_category_id.setValue(1L);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            try {
                Object[] facilityIds;
                Object[] memberNames;
                if (!this.is_span && rundata.getParameters().containsKey((Object)"end_date_hour") && rundata.getParameters().containsKey((Object)"end_date_minute")) {
                    if ("".equals(rundata.getParameters().get("end_date_hour")) && "".equals(rundata.getParameters().get("end_date_minute"))) {
                        this.end_date = this.start_date;
                    } else if ("".equals(rundata.getParameters().get("end_date_hour")) || "".equals(rundata.getParameters().get("end_date_minute"))) {
                        this.end_date = null;
                    }
                }
                if (this.all_day_flag.getValue().equals("ON") && this.is_span) {
                    this.end_date.setValue(this.start_date.getValue());
                }
                if ((memberNames = rundata.getParameters().getStrings("member_to")) != null && memberNames.length > 0) {
                    SelectQuery query = Database.query(TurbineUser.class);
                    Expression exp = ExpressionFactory.inExp((String)"loginName", (Object[])memberNames);
                    query.setQualifier(exp);
                    this.memberList.addAll(ALEipUtils.getUsersFromSelectQuery((SelectQuery)query));
                }
                if (this.memberList.size() == 0) {
                    this.memberList.add(this.login_user);
                }
                if (!ScheduleUtils.isZeroLength((String[])(facilityIds = rundata.getParameters().getStrings("facility_to")))) {
                    SelectQuery fquery = Database.query(EipMFacility.class);
                    Expression fexp = ExpressionFactory.inDbExp((String)"FACILITY_ID", (Object[])facilityIds);
                    fquery.setQualifier(fexp);
                    List facilities = fquery.fetchList();
                    for (EipMFacility facility : facilities) {
                        FacilityResultData rd = new FacilityResultData();
                        rd.initField();
                        rd.setFacilityId(facility.getFacilityId().longValue());
                        rd.setFacilityName(facility.getFacilityName());
                        this.facilityList.add(rd);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)"schedule", (Throwable)ex);
            }
        }
        return res;
    }

    protected void setValidator() {
        this.name.setNotNull(true);
        this.name.limitMaxLength(50);
        this.place.limitMaxLength(50);
        this.note.limitMaxLength(1000);
    }

    protected boolean validate(List<String> msgList) throws ALDBErrorException, ALPageNotFoundException {
        try {
            ScheduleUtils.validateDelegate(this.getStartDate(), this.getEndDate(), this.getRepeatType(), this.is_repeat, this.is_span, this.getWeek0(), this.getWeek1(), this.getWeek2(), this.getWeek3(), this.getWeek4(), this.getWeek5(), this.getWeek6(), this.getRepeatWeek(), this.getLimitFlag(), this.getLimitStartDate(), this.getLimitEndDate(), this.getMonthDay(), this.getYearMonth(), this.getYearDay(), this.loginUser, null, msgList, false);
        }
        catch (NumberFormatException nfe) {
            logger.error((Object)"[ScheduleFormData] NumberFormatException: Limit Date is wrong.");
            throw new ALPageNotFoundException();
        }
        this.name.validate(msgList);
        this.place.validate(msgList);
        this.note.validate(msgList);
        this.common_category_id.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTSchedule record = ScheduleUtils.getEipTSchedule(rundata, context, false);
            if (record == null) {
                return false;
            }
            this.is_owner = (long)record.getOwnerId().intValue() == this.login_user.getUserId().getValue();
            this.name.setValue(record.getName());
            this.place.setValue(record.getPlace());
            this.note.setValue(record.getNote());
            this.public_flag.setValue(record.getPublicFlag());
            this.mail_flag = record.getMailFlag();
            if ("T".equals(record.getEditFlag())) {
                if (this.is_owner) {
                    this.edit_flag.setValue(record.getEditFlag());
                } else {
                    int createUserId = record.getOwnerId();
                    boolean inculudeCreateUser = false;
                    List scheduleMaps = record.getEipTScheduleMaps();
                    for (EipTScheduleMap map : scheduleMaps) {
                        if (createUserId != map.getUserId() || "R".equals(map.getStatus())) continue;
                        inculudeCreateUser = true;
                        break;
                    }
                    if (inculudeCreateUser) {
                        this.edit_flag.setValue("F");
                    } else {
                        this.edit_flag.setValue("T");
                    }
                }
            } else {
                this.edit_flag.setValue("F");
            }
            String ptn = record.getRepeatPattern();
            int count = 0;
            this.is_repeat = true;
            this.is_span = false;
            if (ptn.charAt(0) == 'D') {
                this.repeat_type.setValue("D");
                count = 1;
            } else if (ptn.charAt(0) == 'W' && ptn.length() == 9) {
                this.repeat_type.setValue("W");
                this.week_0.setValue(ptn.charAt(1) != '0' ? "TRUE" : null);
                this.week_1.setValue(ptn.charAt(2) != '0' ? "TRUE" : null);
                this.week_2.setValue(ptn.charAt(3) != '0' ? "TRUE" : null);
                this.week_3.setValue(ptn.charAt(4) != '0' ? "TRUE" : null);
                this.week_4.setValue(ptn.charAt(5) != '0' ? "TRUE" : null);
                this.week_5.setValue(ptn.charAt(6) != '0' ? "TRUE" : null);
                this.week_6.setValue(ptn.charAt(7) != '0' ? "TRUE" : null);
                count = 8;
            } else if (ptn.charAt(0) == 'W' && ptn.length() == 10) {
                this.repeat_type.setValue("W");
                this.week_0.setValue(ptn.charAt(1) != '0' ? "TRUE" : null);
                this.week_1.setValue(ptn.charAt(2) != '0' ? "TRUE" : null);
                this.week_2.setValue(ptn.charAt(3) != '0' ? "TRUE" : null);
                this.week_3.setValue(ptn.charAt(4) != '0' ? "TRUE" : null);
                this.week_4.setValue(ptn.charAt(5) != '0' ? "TRUE" : null);
                this.week_5.setValue(ptn.charAt(6) != '0' ? "TRUE" : null);
                this.week_6.setValue(ptn.charAt(7) != '0' ? "TRUE" : null);
                this.repeat_week.setValue("0");
                switch (ptn.charAt(8)) {
                    case '1': {
                        this.repeat_week.setValue("1");
                        break;
                    }
                    case '2': {
                        this.repeat_week.setValue("2");
                        break;
                    }
                    case '3': {
                        this.repeat_week.setValue("3");
                        break;
                    }
                    case '4': {
                        this.repeat_week.setValue("4");
                        break;
                    }
                    case '5': {
                        this.repeat_week.setValue("5");
                        break;
                    }
                }
                count = 9;
            } else if (ptn.charAt(0) == 'M') {
                this.repeat_type.setValue("M");
                this.month_day.setValue((long)Integer.parseInt(ptn.substring(1, 3)));
                count = 3;
            } else if (ptn.charAt(0) == 'Y') {
                this.repeat_type.setValue("Y");
                this.year_month.setValue((long)Integer.parseInt(ptn.substring(1, 3)));
                this.year_day.setValue((long)Integer.parseInt(ptn.substring(3, 5)));
                count = 5;
            } else if (ptn.charAt(0) == 'S') {
                this.is_span = true;
                this.is_repeat = false;
            } else {
                this.is_repeat = false;
            }
            if (this.is_repeat) {
                Calendar tmpViewCal = Calendar.getInstance();
                tmpViewCal.setTime(this.view_date.getValue());
                Calendar tmpStartCal = Calendar.getInstance();
                tmpStartCal.setTime(record.getStartDate());
                tmpViewCal.set(11, tmpStartCal.get(11));
                tmpViewCal.set(12, tmpStartCal.get(12));
                this.start_date.setValue(tmpViewCal.getTime());
                Calendar tmpStopCal = Calendar.getInstance();
                tmpStopCal.setTime(record.getEndDate());
                tmpViewCal.set(11, tmpStopCal.get(11));
                tmpViewCal.set(12, tmpStopCal.get(12));
                this.end_date.setValue(tmpViewCal.getTime());
                if (ptn.charAt(count) == 'N') {
                    this.limit_start_date.setValue(this.view_date.getValue());
                    this.limit_end_date.setValue(this.view_date.getValue());
                    this.limit_flag.setValue("OFF");
                } else {
                    this.limit_flag.setValue("ON");
                    this.limit_start_date.setValue(record.getStartDate());
                    this.limit_end_date.setValue(record.getEndDate());
                }
                this.edit_repeat_flag.setValue(0L);
            }
            if (this.is_span) {
                this.start_date.setValue(record.getStartDate());
                this.end_date.setValue(record.getEndDate());
                this.limit_start_date.setValue(record.getStartDate());
                this.limit_end_date.setValue(record.getEndDate());
                Calendar startDate = Calendar.getInstance();
                startDate.setTime(record.getStartDate());
                Calendar endDate = Calendar.getInstance();
                endDate.setTime(record.getEndDate());
                startDate.add(5, 1);
                startDate.add(13, -1);
                Date sDate = startDate.getTime();
                if (record.getStartDate().equals(record.getEndDate()) || sDate.equals(record.getEndDate())) {
                    this.all_day_flag.setValue("ON");
                }
            }
            if (!this.is_repeat && !this.is_span) {
                this.start_date.setValue(record.getStartDate());
                this.end_date.setValue(record.getEndDate());
                this.limit_start_date.setValue(record.getStartDate());
                this.limit_end_date.setValue(record.getEndDate());
            }
            this.is_same_date = this.start_date.toString().equals(this.end_date.toString());
            SelectQuery mapquery = Database.query(EipTScheduleMap.class);
            Expression mapexp = ExpressionFactory.matchExp((String)"scheduleId", (Object)record.getScheduleId());
            mapquery.setQualifier(mapexp);
            List scheduleMaps = mapquery.fetchList();
            ArrayList<Integer> userIds = new ArrayList<Integer>();
            ArrayList<Integer> facilityIds = new ArrayList<Integer>();
            for (EipTScheduleMap map : scheduleMaps) {
                if ("U".equals(map.getType())) {
                    userIds.add(map.getUserId());
                    EipTCommonCategory category = map.getEipTCommonCategory();
                    if (category == null) {
                        this.common_category_id.setValue(1L);
                        continue;
                    }
                    this.common_category_id.setValue(category.getCommonCategoryId().longValue());
                    continue;
                }
                facilityIds.add(map.getUserId());
            }
            if (userIds.size() > 0) {
                SelectQuery query = Database.query(TurbineUser.class);
                Expression exp = ExpressionFactory.inDbExp((String)"USER_ID", userIds);
                query.setQualifier(exp);
                this.memberList.addAll(ALEipUtils.getUsersFromSelectQuery((SelectQuery)query));
            } else {
                this.memberList.add(this.login_user);
            }
            if (facilityIds.size() > 0) {
                SelectQuery fquery = Database.query(EipMFacility.class);
                Expression fexp = ExpressionFactory.inDbExp((String)"FACILITY_ID", facilityIds);
                fquery.setQualifier(fexp);
                this.facilityList.addAll(FacilitiesUtils.getFacilitiesFromSelectQuery((SelectQuery)fquery));
            }
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) throws ALDBErrorException {
        EipTSchedule schedule = null;
        try {
            int f_size = this.facilityList.size();
            if (!this.facilityCheckAclPermission(rundata, 4) && f_size > 0) {
                msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_NO_PERMISSION_TO_MAKE_A_RESERVATION"));
                return false;
            }
            if (this.is_span) {
                Calendar startDate = Calendar.getInstance();
                startDate.setTime(this.start_date.getValue());
                startDate.set(11, 0);
                startDate.set(12, 0);
                Calendar endDate = Calendar.getInstance();
                endDate.setTime(this.end_date.getValue());
                endDate.set(11, 0);
                endDate.set(12, 0);
                this.start_date.setValue(startDate.getTime());
                this.end_date.setValue(endDate.getTime());
            } else {
                GregorianCalendar startcal = new GregorianCalendar();
                startcal.setTime(this.start_date.getValue());
                Calendar endcal = Calendar.getInstance();
                endcal.setTime(this.end_date.getValue());
                endcal.set(1, startcal.get(1));
                endcal.set(2, startcal.get(2));
                endcal.set(5, startcal.get(5));
                this.end_date.setValue(endcal.getTime());
            }
            int ownerid = ALEipUtils.getUserId((RunData)rundata);
            schedule = (EipTSchedule)Database.create(EipTSchedule.class);
            schedule.setParentId(Integer.valueOf(0));
            schedule.setName(this.name.getValue());
            schedule.setPlace(this.place.getValue());
            schedule.setNote(this.note.getValue());
            schedule.setPublicFlag(this.public_flag.getValue());
            if (this.memberList.size() >= 1) {
                schedule.setEditFlag(this.edit_flag.getValue());
            } else {
                schedule.setEditFlag("F");
            }
            schedule.setMailFlag(this.mail_flag);
            schedule.setOwnerId(Integer.valueOf(ownerid));
            Date now = new Date();
            schedule.setCreateDate(now);
            schedule.setCreateUserId(Integer.valueOf(ownerid));
            schedule.setUpdateDate(now);
            schedule.setUpdateUserId(Integer.valueOf(ownerid));
            if (this.is_span) {
                schedule.setEndDate(this.end_date.getValue());
                schedule.setRepeatPattern("S");
                schedule.setStartDate(this.start_date.getValue());
            } else if (!this.is_repeat) {
                schedule.setEndDate(this.end_date.getValue());
                schedule.setRepeatPattern("N");
                schedule.setStartDate(this.start_date.getValue());
            } else {
                char lim = 'N';
                Iterator<Object> cal = Calendar.getInstance();
                ((Calendar)((Object)cal)).setTime(this.end_date.getValue());
                if ("ON".equals(this.limit_flag.getValue())) {
                    lim = 'L';
                    ((Calendar)((Object)cal)).set(this.limit_end_date.getValue().getYear(), this.limit_end_date.getValue().getMonth() - 1, this.limit_end_date.getValue().getDay());
                    ALDateContainer aLDateContainer = this.limit_start_date.getValue();
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(this.start_date.getValue());
                    calendar.set(1, aLDateContainer.getYear());
                    calendar.set(2, aLDateContainer.getMonth() - 1);
                    calendar.set(5, aLDateContainer.getDay());
                    schedule.setStartDate(calendar.getTime());
                } else {
                    schedule.setStartDate(this.start_date.getValue());
                }
                schedule.setEndDate(((Calendar)((Object)cal)).getTime());
                if ("D".equals(this.repeat_type.getValue())) {
                    schedule.setRepeatPattern(new StringBuffer().append('D').append(lim).toString());
                } else if ("W".equals(this.repeat_type.getValue())) {
                    if ("0".equals(this.repeat_week.getValue())) {
                        schedule.setRepeatPattern(new StringBuffer().append('W').append(this.week_0.getValue() != null ? 1 : 0).append(this.week_1.getValue() != null ? 1 : 0).append(this.week_2.getValue() != null ? 1 : 0).append(this.week_3.getValue() != null ? 1 : 0).append(this.week_4.getValue() != null ? 1 : 0).append(this.week_5.getValue() != null ? 1 : 0).append(this.week_6.getValue() != null ? 1 : 0).append(lim).toString());
                    } else {
                        schedule.setRepeatPattern(new StringBuffer().append('W').append(this.week_0.getValue() != null ? 1 : 0).append(this.week_1.getValue() != null ? 1 : 0).append(this.week_2.getValue() != null ? 1 : 0).append(this.week_3.getValue() != null ? 1 : 0).append(this.week_4.getValue() != null ? 1 : 0).append(this.week_5.getValue() != null ? 1 : 0).append(this.week_6.getValue() != null ? 1 : 0).append(this.repeat_week.getValue().charAt(0)).append(lim).toString());
                    }
                } else if ("M".equals(this.repeat_type.getValue())) {
                    DecimalFormat decimalFormat = new DecimalFormat("00");
                    schedule.setRepeatPattern(new StringBuffer().append('M').append(decimalFormat.format(this.month_day.getValue())).append(lim).toString());
                } else {
                    DecimalFormat decimalFormat = new DecimalFormat("00");
                    schedule.setRepeatPattern(new StringBuffer().append('Y').append(decimalFormat.format(this.year_month.getValue())).append(decimalFormat.format(this.year_day.getValue())).append(lim).toString());
                }
            }
            EipTCommonCategory category1 = CommonCategoryUtils.getEipTCommonCategory((Long)1L);
            for (ALEipUser aLEipUser : this.memberList) {
                EipTScheduleMap eipTScheduleMap = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
                int userid = (int)aLEipUser.getUserId().getValue();
                eipTScheduleMap.setEipTSchedule(schedule);
                eipTScheduleMap.setUserId(Integer.valueOf(userid));
                if (userid == ALEipUtils.getUserId((RunData)rundata)) {
                    eipTScheduleMap.setStatus("O");
                } else {
                    eipTScheduleMap.setStatus("T");
                }
                EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory((Long)this.common_category_id.getValue());
                if (category == null) {
                    eipTScheduleMap.setCommonCategoryId(Integer.valueOf(1));
                    eipTScheduleMap.setEipTSchedule(schedule);
                    eipTScheduleMap.setEipTCommonCategory(category1);
                } else {
                    eipTScheduleMap.setCommonCategoryId(Integer.valueOf((int)this.common_category_id.getValue()));
                    eipTScheduleMap.setEipTSchedule(schedule);
                    eipTScheduleMap.setEipTCommonCategory(category);
                }
                eipTScheduleMap.setType("U");
            }
            if ("O".equals(this.public_flag.toString()) || "C".equals(this.public_flag.toString())) {
                for (Object object : this.facilityList) {
                    FacilityResultData facilityResultData = (FacilityResultData)object;
                    EipTScheduleMap map = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
                    int facilityid = (int)facilityResultData.getFacilityId().getValue();
                    map.setEipTSchedule(schedule);
                    map.setUserId(Integer.valueOf(facilityid));
                    map.setStatus("O");
                    map.setType("F");
                    map.setEipTCommonCategory(category1);
                    map.setCommonCategoryId(Integer.valueOf(1));
                }
            }
            if (!this.ignore_duplicate_facility && this.facilityList.size() > 0) {
                ArrayList<Integer> facilityIds = new ArrayList<Integer>();
                for (Object object : this.facilityList) {
                    FacilityResultData frd = (FacilityResultData)object;
                    facilityIds.add((int)frd.getFacilityId().getValue());
                }
                if (ScheduleUtils.isDuplicateFacilitySchedule(schedule, facilityIds, null, null)) {
                    if (msgList.size() == 0) {
                        msgList.add("duplicate_facility");
                    }
                    Database.rollback();
                    return false;
                }
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(schedule.getScheduleId().intValue(), 240, schedule.getName());
            String loginName = this.loginUser.getName().getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ALEipUser user : this.memberList) {
                if (this.loginUser.getUserId().getValue() == user.getUserId().getValue()) continue;
                arrayList.add(user.getName().getValue());
            }
            ScheduleUtils.createShareScheduleActivity(schedule, loginName, arrayList, "new", ownerid);
            if ("O".equals(this.public_flag.toString())) {
                ScheduleUtils.createNewScheduleActivity(schedule, loginName, "new", ownerid);
            }
        }
        catch (CayenneRuntimeException e) {
            if (e.getCause().getMessage().indexOf("Incorrect string value:") == 0) {
                msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_UNAVAILABLE_CHARACTER"));
            }
            Database.rollback();
            logger.error((Object)"[ScheduleFormData]", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"[ScheduleFormData]", (Throwable)e);
            return false;
        }
        if ("A".equals(schedule.getMailFlag()) || "I".equals(schedule.getMailFlag())) {
            try {
                int msgType = ALMailUtils.getSendDestType((int)24);
                if (msgType > 0) {
                    List destMemberList = ALMailUtils.getALEipUserAddrs(this.memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
                    String subject = "[" + ALOrgUtilsService.getAlias() + "]\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb";
                    String orgId = Database.getDomainName();
                    ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
                    for (ALEipUserAddr aLEipUserAddr : destMemberList) {
                        ALAdminMailMessage message = new ALAdminMailMessage(aLEipUserAddr);
                        message.setPcSubject(subject);
                        message.setCellularSubject(subject);
                        message.setPcBody(ScheduleUtils.createMsgForPc(rundata, schedule, this.memberList, "new"));
                        message.setCellularBody(ScheduleUtils.createMsgForCellPhone(rundata, schedule, this.memberList, aLEipUserAddr.getUserId(), "new"));
                        messageList.add(message);
                    }
                    ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)24)));
                }
            }
            catch (Exception ex) {
                msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_DONOT_SEND_MAIL"));
                logger.error((Object)"schedule", (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        ArrayList<ALEipUser> newmemberList = new ArrayList<ALEipUser>();
        EipTSchedule schedule = null;
        EipTSchedule newSchedule = null;
        EipTSchedule tmpSchedule = null;
        try {
            Object memberIdList;
            EipTScheduleMap map;
            int facilityid;
            Object frd;
            if (this.is_span) {
                Calendar startDate = Calendar.getInstance();
                startDate.setTime(this.start_date.getValue());
                startDate.set(11, 0);
                startDate.set(12, 0);
                Calendar endDate = Calendar.getInstance();
                endDate.setTime(this.end_date.getValue());
                endDate.set(11, 0);
                endDate.set(12, 0);
                this.start_date.setValue(startDate.getTime());
                this.end_date.setValue(endDate.getTime());
            } else {
                GregorianCalendar startcal = new GregorianCalendar();
                startcal.setTime(this.start_date.getValue());
                Calendar endcal = Calendar.getInstance();
                endcal.setTime(this.end_date.getValue());
                endcal.set(1, startcal.get(1));
                endcal.set(2, startcal.get(2));
                endcal.set(5, startcal.get(5));
                this.end_date.setValue(endcal.getTime());
            }
            schedule = ScheduleUtils.getEipTSchedule(rundata, context, false);
            if (schedule == null) {
                return false;
            }
            tmpSchedule = schedule;
            int ownerid = schedule.getOwnerId();
            if (!this.facilityCheckAclPermission(rundata, 8)) {
                int[] old_ids = ScheduleUtils.getFacilityIds(schedule);
                if (old_ids.length != this.facilityList.size()) {
                    msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_NO_PERMISSION_TO_MAKE_A_RESERVATION"));
                    return false;
                }
                boolean check = false;
                for (Iterator<ALEipUser> old_id : (Iterator<ALEipUser>)old_ids) {
                    for (Object record : this.facilityList) {
                        frd = (FacilityResultData)record;
                        facilityid = (int)frd.getFacilityId().getValue();
                        if (old_id != facilityid) continue;
                        check = true;
                        break;
                    }
                    if (!check) {
                        msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_NO_PERMISSION_TO_MAKE_A_RESERVATION"));
                        return false;
                    }
                    check = false;
                }
            }
            List scheduleMapList = schedule.getEipTScheduleMaps();
            ArrayList<Integer> oldmemberIdList = new ArrayList<Integer>();
            for (Object record : scheduleMapList) {
                EipTScheduleMap map2 = (EipTScheduleMap)record;
                if (!"U".equals(map2.getType())) continue;
                oldmemberIdList.add(map2.getUserId());
            }
            for (ALEipUser user : this.memberList) {
                int memberId = (int)user.getUserId().getValue();
                if (this.isContains(oldmemberIdList, memberId)) continue;
                newmemberList.add(ALEipUtils.getALEipUser((int)memberId));
            }
            EipTCommonCategory category1 = CommonCategoryUtils.getEipTCommonCategory((Long)1L);
            if (this.edit_repeat_flag.getValue() == 1L) {
                EipTScheduleMap map3;
                newSchedule = (EipTSchedule)Database.create(EipTSchedule.class);
                newSchedule.setParentId(schedule.getScheduleId());
                newSchedule.setName(this.name.getValue());
                newSchedule.setPlace(this.place.getValue());
                newSchedule.setNote(this.note.getValue());
                newSchedule.setPublicFlag(this.public_flag.getValue());
                newSchedule.setEditFlag("F");
                newSchedule.setEditFlag(schedule.getEditFlag());
                newSchedule.setMailFlag(this.mail_flag);
                newSchedule.setOwnerId(Integer.valueOf(ownerid));
                Date now = new Date();
                newSchedule.setCreateDate(now);
                newSchedule.setCreateUserId(Integer.valueOf(ownerid));
                newSchedule.setUpdateDate(now);
                newSchedule.setUpdateUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
                newSchedule.setEndDate(this.end_date.getValue());
                newSchedule.setRepeatPattern("N");
                newSchedule.setStartDate(this.start_date.getValue());
                int allsize = this.memberList.size() + this.facilityList.size();
                if (allsize > 0) {
                    List scheduleMaps = schedule.getEipTScheduleMaps();
                    for (ALEipUser user : this.memberList) {
                        map = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
                        int userid = (int)user.getUserId().getValue();
                        map.setEipTSchedule(newSchedule);
                        map.setUserId(Integer.valueOf(userid));
                        if (userid == ownerid) {
                            map.setStatus("O");
                        } else if ("T".equals(this.change_tmpreserve_flag.getValue())) {
                            map.setStatus("T");
                        } else {
                            EipTScheduleMap tmpMap = this.getScheduleMap(scheduleMaps, userid, "U");
                            if (tmpMap != null) {
                                map.setStatus(tmpMap.getStatus());
                            } else {
                                map.setStatus("T");
                            }
                        }
                        EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory((Long)this.common_category_id.getValue());
                        if (category == null) {
                            map.setCommonCategoryId(Integer.valueOf(1));
                            map.setEipTCommonCategory(category1);
                        } else {
                            map.setCommonCategoryId(Integer.valueOf((int)this.common_category_id.getValue()));
                            map.setEipTCommonCategory(category);
                        }
                        map.setType("U");
                    }
                    if ("O".equals(this.public_flag.toString()) || "C".equals(this.public_flag.toString())) {
                        for (Object record : this.facilityList) {
                            frd = (FacilityResultData)record;
                            facilityid = (int)frd.getFacilityId().getValue();
                            map3 = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
                            map3.setEipTSchedule(newSchedule);
                            map3.setUserId(Integer.valueOf(facilityid));
                            map3.setStatus("O");
                            map3.setType("F");
                            map3.setEipTCommonCategory(category1);
                            map3.setCommonCategoryId(Integer.valueOf(1));
                        }
                    }
                }
                List scheduleMaps = schedule.getEipTScheduleMaps();
                memberIdList = new ArrayList();
                ArrayList<Integer> facilityIdList = new ArrayList<Integer>();
                for (Object record : scheduleMaps) {
                    map3 = (EipTScheduleMap)record;
                    if ("U".equals(map3.getType())) {
                        memberIdList.add(map3.getUserId());
                        continue;
                    }
                    facilityIdList.add(map3.getUserId());
                }
                for (ALEipUser user : this.memberList) {
                    int memberId = (int)user.getUserId().getValue();
                    if (this.isContains((List<Integer>)memberIdList, memberId)) continue;
                    memberIdList.add(memberId);
                }
                int memberIdListSize = memberIdList.size();
                int[] memberIds = new int[memberIdListSize];
                for (int i = 0; i < memberIdListSize; ++i) {
                    memberIds[i] = (Integer)memberIdList.get(i);
                }
                ListIterator<Object> record = this.facilityList.listIterator(this.facilityList.size());
                while (record.hasNext()) {
                    int facilityId = (int)((FacilityResultData)record).getFacilityId().getValue();
                    if (this.isContains(facilityIdList, facilityId)) continue;
                    this.facilityList.add(facilityId);
                }
                int facilityIdListSize = facilityIdList.size();
                int[] facilityIds = new int[facilityIdListSize];
                for (int i = 0; i < facilityIdListSize; ++i) {
                    facilityIds[i] = (Integer)facilityIdList.get(i);
                }
                if (!this.ignore_duplicate_facility && facilityIdList.size() > 0 && ScheduleUtils.isDuplicateFacilitySchedule(newSchedule, facilityIdList, schedule.getScheduleId(), this.view_date.getValue())) {
                    if (msgList.size() == 0) {
                        msgList.add("duplicate_facility");
                    }
                    Database.rollback();
                    return false;
                }
                ScheduleUtils.insertDummySchedule(schedule, ownerid, this.view_date.getValue(), this.view_date.getValue(), memberIds, facilityIds);
                tmpSchedule = newSchedule;
            } else {
                schedule.setName(this.name.getValue());
                schedule.setPlace(this.place.getValue());
                schedule.setNote(this.note.getValue());
                schedule.setPublicFlag(this.public_flag.getValue());
                schedule.setMailFlag(this.mail_flag);
                if (schedule.getOwnerId() == ALEipUtils.getUserId((RunData)rundata) || schedule.getOwnerId() == 0) {
                    schedule.setEditFlag(this.edit_flag.getValue());
                }
                int ownerUserId = schedule.getOwnerId();
                boolean rejectOwnerUser = false;
                List tmpScheduleMaps = schedule.getEipTScheduleMaps();
                memberIdList = tmpScheduleMaps.iterator();
                while (memberIdList.hasNext()) {
                    Object record;
                    record = memberIdList.next();
                    map = (EipTScheduleMap)record;
                    if (ownerUserId != map.getUserId() || !"R".equals(map.getStatus())) continue;
                    rejectOwnerUser = true;
                    break;
                }
                if (rejectOwnerUser) {
                    schedule.setOwnerId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
                }
                schedule.setUpdateDate(new Date());
                schedule.setUpdateUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
                if (this.is_span) {
                    schedule.setEndDate(this.end_date.getValue());
                    schedule.setRepeatPattern("S");
                    schedule.setStartDate(this.start_date.getValue());
                } else if (!this.is_repeat) {
                    schedule.setEndDate(this.end_date.getValue());
                    schedule.setRepeatPattern("N");
                    schedule.setStartDate(this.start_date.getValue());
                } else {
                    DecimalFormat format;
                    String tmpPattern;
                    char lim = 'N';
                    Iterator<Object> cal = Calendar.getInstance();
                    ((Calendar)((Object)cal)).setTime(this.end_date.getValue());
                    if ("ON".equals(this.limit_flag.getValue())) {
                        lim = 'L';
                        ((Calendar)((Object)cal)).set(this.limit_end_date.getValue().getYear(), this.limit_end_date.getValue().getMonth() - 1, this.limit_end_date.getValue().getDay());
                        ALDateContainer container = this.limit_start_date.getValue();
                        Calendar limitStartCal = Calendar.getInstance();
                        limitStartCal.setTime(this.start_date.getValue());
                        limitStartCal.set(1, container.getYear());
                        limitStartCal.set(2, container.getMonth() - 1);
                        limitStartCal.set(5, container.getDay());
                        schedule.setStartDate(limitStartCal.getTime());
                    } else {
                        schedule.setStartDate(this.start_date.getValue());
                    }
                    schedule.setEndDate(((Calendar)((Object)cal)).getTime());
                    if ("D".equals(this.repeat_type.getValue())) {
                        tmpPattern = new StringBuffer().append('D').append(lim).toString();
                        schedule.setRepeatPattern(tmpPattern);
                    } else if ("W".equals(this.repeat_type.getValue())) {
                        if ("0".equals(this.repeat_week.getValue())) {
                            tmpPattern = new StringBuffer().append('W').append(this.week_0.getValue() != null ? 1 : 0).append(this.week_1.getValue() != null ? 1 : 0).append(this.week_2.getValue() != null ? 1 : 0).append(this.week_3.getValue() != null ? 1 : 0).append(this.week_4.getValue() != null ? 1 : 0).append(this.week_5.getValue() != null ? 1 : 0).append(this.week_6.getValue() != null ? 1 : 0).append(lim).toString();
                            schedule.setRepeatPattern(tmpPattern);
                        } else {
                            tmpPattern = new StringBuffer().append('W').append(this.week_0.getValue() != null ? 1 : 0).append(this.week_1.getValue() != null ? 1 : 0).append(this.week_2.getValue() != null ? 1 : 0).append(this.week_3.getValue() != null ? 1 : 0).append(this.week_4.getValue() != null ? 1 : 0).append(this.week_5.getValue() != null ? 1 : 0).append(this.week_6.getValue() != null ? 1 : 0).append(this.repeat_week.getValue().charAt(0)).append(lim).toString();
                            schedule.setRepeatPattern(tmpPattern);
                        }
                    } else if ("M".equals(this.repeat_type.getValue())) {
                        format = new DecimalFormat("00");
                        schedule.setRepeatPattern(new StringBuffer().append('M').append(format.format(this.month_day.getValue())).append(lim).toString());
                    } else {
                        format = new DecimalFormat("00");
                        schedule.setRepeatPattern(new StringBuffer().append('Y').append(format.format(this.year_month.getValue())).append(format.format(this.year_day.getValue())).append(lim).toString());
                    }
                }
                List scheduleMaps = schedule.getEipTScheduleMaps();
                Database.deleteAll((List)scheduleMaps);
                for (ALEipUser user : this.memberList) {
                    EipTScheduleMap map4 = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
                    int userid = (int)user.getUserId().getValue();
                    map4.setScheduleId(schedule.getScheduleId());
                    map4.setEipTSchedule(schedule);
                    map4.setUserId(Integer.valueOf(userid));
                    if (userid == schedule.getOwnerId()) {
                        map4.setStatus("O");
                    } else if ("T".equals(this.change_tmpreserve_flag.getValue())) {
                        map4.setStatus("T");
                    } else {
                        EipTScheduleMap tmpMap = this.getScheduleMap(scheduleMaps, userid, "U");
                        if (tmpMap != null) {
                            map4.setStatus(tmpMap.getStatus());
                        } else {
                            map4.setStatus("T");
                        }
                    }
                    EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory((Long)this.common_category_id.getValue());
                    if (category == null) {
                        map4.setCommonCategoryId(Integer.valueOf(1));
                        map4.setEipTSchedule(schedule);
                        map4.setEipTCommonCategory(category1);
                    } else {
                        map4.setCommonCategoryId(Integer.valueOf((int)this.common_category_id.getValue()));
                        map4.setEipTSchedule(schedule);
                        map4.setEipTCommonCategory(category);
                    }
                    map4.setType("U");
                    schedule.addToEipTScheduleMaps(map4);
                }
                if ("O".equals(this.public_flag.toString()) || "C".equals(this.public_flag.toString())) {
                    for (Object record : this.facilityList) {
                        FacilityResultData frd2 = (FacilityResultData)record;
                        int facilityid2 = (int)frd2.getFacilityId().getValue();
                        EipTScheduleMap map5 = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
                        map5.setEipTSchedule(schedule);
                        map5.setUserId(Integer.valueOf(facilityid2));
                        map5.setStatus("O");
                        map5.setType("F");
                        map5.setEipTCommonCategory(category1);
                        map5.setCommonCategoryId(Integer.valueOf(1));
                    }
                }
                if (!this.ignore_duplicate_facility && this.facilityList.size() > 0) {
                    ArrayList<Integer> fids = new ArrayList<Integer>();
                    FacilityResultData facility = null;
                    for (Object record : this.facilityList) {
                        facility = (FacilityResultData)record;
                        fids.add((int)facility.getFacilityId().getValue());
                    }
                    if (ScheduleUtils.isDuplicateFacilitySchedule(schedule, fids, null, null)) {
                        if (msgList.size() == 0) {
                            msgList.add("duplicate_facility");
                        }
                        Database.rollback();
                        return false;
                    }
                }
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(schedule.getScheduleId().intValue(), 240, schedule.getName());
            String loginName = this.loginUser.getName().getValue();
            ArrayList<String> recipients = new ArrayList<String>();
            for (ALEipUser user : this.memberList) {
                if (this.loginUser.getUserId().getValue() == user.getUserId().getValue()) continue;
                recipients.add(user.getName().getValue());
            }
            int userid = ALEipUtils.getUserId((RunData)rundata);
            ScheduleUtils.createShareScheduleActivity(tmpSchedule, loginName, recipients, "edit", userid);
            if ("O".equals(this.public_flag.toString())) {
                ScheduleUtils.createNewScheduleActivity(schedule, loginName, "edit", userid);
            }
        }
        catch (RuntimeException e) {
            Database.rollback();
            logger.error((Object)"[ScheduleFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"[ScheduleFormData]", (Throwable)e);
            msgList.add(ALLocalizationUtils.getl10n((String)"ERROR_UPDATE_FAILURE"));
            return false;
        }
        if ("A".equals(schedule.getMailFlag()) || "U".equals(schedule.getMailFlag())) {
            try {
                int msgType = ALMailUtils.getSendDestType((int)24);
                if (msgType > 0) {
                    ArrayList<ALAdminMailMessage> messageList;
                    List destMemberList = ALMailUtils.getALEipUserAddrs(this.memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
                    String subject = "[" + ALOrgUtilsService.getAlias() + "]\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb";
                    if (this.edit_repeat_flag.getValue() == 1L) {
                        messageList = new ArrayList<ALAdminMailMessage>();
                        for (ALEipUserAddr destMember : destMemberList) {
                            ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                            message.setPcSubject(subject);
                            message.setCellularSubject(subject);
                            message.setPcBody(ScheduleUtils.createMsgForPc(rundata, newSchedule, this.memberList, "edit"));
                            message.setCellularBody(ScheduleUtils.createMsgForCellPhone(rundata, newSchedule, this.memberList, destMember.getUserId(), "edit"));
                        }
                        ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(this.orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)24)));
                    } else {
                        messageList = new ArrayList();
                        for (ALEipUserAddr destMember : destMemberList) {
                            ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                            message.setPcSubject(subject);
                            message.setCellularSubject(subject);
                            message.setPcBody(ScheduleUtils.createMsgForPc(rundata, schedule, this.memberList, "edit"));
                            message.setCellularBody(ScheduleUtils.createMsgForCellPhone(rundata, schedule, this.memberList, destMember.getUserId(), "edit"));
                            messageList.add(message);
                        }
                        ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(this.orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)24)));
                    }
                }
            }
            catch (Exception ex) {
                msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_DONOT_SEND_MAIL"));
                logger.error((Object)"schedule", (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    private EipTScheduleMap getScheduleMap(List<?> scheduleMaps, int userid, String type) {
        for (Object record : scheduleMaps) {
            EipTScheduleMap map = (EipTScheduleMap)record;
            if (map.getUserId() != userid || !type.equals(map.getType())) continue;
            return map;
        }
        return null;
    }

    private void deleteMemberAllRangeAll(EipTSchedule schedule, List<ALEipUser> members) throws ALDBErrorException, ALPageNotFoundException {
        this.deleteSchedule(schedule);
    }

    private void deleteMemberAllRangeOneday(EipTSchedule schedule, List<ALEipUser> members) throws ALDBErrorException, ALPageNotFoundException {
        if (!"N".equals(schedule.getRepeatPattern())) {
            int ownerid = (int)this.loginUser.getUserId().getValue();
            int memberIdListSize = this.memberList.size();
            int[] memberIdList = new int[memberIdListSize];
            for (int i = 0; i < memberIdListSize; ++i) {
                memberIdList[i] = (int)this.memberList.get(i).getUserId().getValue();
            }
            int[] facilityIdList = ScheduleUtils.getFacilityIds(schedule);
            ScheduleUtils.insertDummySchedule(schedule, ownerid, this.view_date.getValue(), this.view_date.getValue(), memberIdList, facilityIdList);
        }
    }

    private void deleteMemberOneRangeAll(EipTSchedule schedule, List<ALEipUser> members, boolean isFacility, int deleteUserId, boolean acl_delete_other) throws ALPageNotFoundException, ALDBErrorException {
        block9: {
            List<EipTScheduleMap> scheduleMaps = ScheduleUtils.getEipTScheduleMaps(schedule);
            if (scheduleMaps == null || scheduleMaps.size() <= 0) break block9;
            if (isFacility) {
                for (EipTScheduleMap reocrd : scheduleMaps) {
                    EipTScheduleMap scheduleMap = reocrd;
                    if (!"F".equals(scheduleMap.getType()) || scheduleMap.getUserId() != deleteUserId) continue;
                    Database.delete((Persistent)scheduleMap);
                }
            } else {
                EipTScheduleMap scheduleMap;
                ArrayList<EipTScheduleMap> tmpScheduleMaps = new ArrayList<EipTScheduleMap>();
                int countRejectSchedule = 0;
                for (EipTScheduleMap reocrd : scheduleMaps) {
                    scheduleMap = reocrd;
                    if (!"U".equals(scheduleMap.getType())) continue;
                    tmpScheduleMaps.add(scheduleMap);
                    if (!"R".equals(scheduleMap.getStatus())) continue;
                    ++countRejectSchedule;
                }
                int scheduleMapsSize = tmpScheduleMaps.size();
                if (countRejectSchedule >= scheduleMapsSize - 1) {
                    this.deleteSchedule(schedule);
                } else {
                    for (int i = 0; i < scheduleMapsSize; ++i) {
                        scheduleMap = (EipTScheduleMap)tmpScheduleMaps.get(i);
                        if (scheduleMap.getUserId() != deleteUserId) continue;
                        int loginUserId = (int)this.login_user.getUserId().getValue();
                        if (scheduleMap.getUserId() != loginUserId && schedule.getCreateUserId() != loginUserId && !acl_delete_other) continue;
                        if ("O".equals(scheduleMap.getStatus())) {
                            schedule.setOwnerId(Integer.valueOf(0));
                            if ("F".equals(schedule.getEditFlag())) {
                                schedule.setEditFlag("T");
                            }
                        }
                        scheduleMap.setStatus("R");
                    }
                }
            }
        }
    }

    private void deleteMemberOneRangeOneday(EipTSchedule schedule, List<ALEipUser> members, boolean isFacility, int deleteUserId, boolean acl_delete_other, RunData rundata, Context context) throws ALDBErrorException, ALPageNotFoundException {
        if (!"N".equals(schedule.getRepeatPattern())) {
            int loginUserId = (int)this.loginUser.getUserId().getValue();
            if (isFacility) {
                this.memberList = new ArrayList();
                this.loadFormData(rundata, context, new ArrayList<String>());
                for (int i = 0; this.facilityList.size() > i; ++i) {
                    if (((FacilityResultData)this.facilityList.get(i)).getFacilityId().getValue() != (long)deleteUserId) continue;
                    this.facilityList.remove(i);
                    break;
                }
                this.edit_repeat_flag.setValue(1L);
                this.updateFormData(rundata, context, new ArrayList<String>());
            } else {
                int user_count = 0;
                List maps = schedule.getEipTScheduleMaps();
                for (Object record : maps) {
                    EipTScheduleMap map = (EipTScheduleMap)record;
                    if (!map.getType().equals("U")) continue;
                    ++user_count;
                }
                SelectQuery dummy_query = Database.query(EipTSchedule.class);
                Expression exp1 = ExpressionFactory.matchExp((String)"parentId", (Object)schedule.getScheduleId());
                Expression exp2 = ExpressionFactory.matchExp((String)"startDate", (Object)this.view_date.getValue());
                Expression exp3 = ExpressionFactory.matchExp((String)"endDate", (Object)this.view_date.getValue());
                dummy_query.setQualifier(exp1);
                dummy_query.andQualifier(exp2);
                dummy_query.andQualifier(exp3);
                List list = dummy_query.fetchList();
                int dummy_count = 0;
                for (EipTSchedule dummy : list) {
                    List dummymaps = dummy.getEipTScheduleMaps();
                    for (Object record : dummymaps) {
                        EipTScheduleMap dummymap = (EipTScheduleMap)record;
                        if (!dummymap.getType().equals("U")) continue;
                        ++dummy_count;
                    }
                }
                int[] facilityIdList = null;
                if (dummy_count >= user_count - 1) {
                    facilityIdList = ScheduleUtils.getFacilityIds(schedule);
                }
                ScheduleUtils.insertDummySchedule(schedule, loginUserId, this.view_date.getValue(), this.view_date.getValue(), new int[]{deleteUserId}, facilityIdList);
            }
        }
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        block29: {
            try {
                EipTSchedule schedule;
                if (rundata.getParameters().containsKey((Object)"del_member_flag")) {
                    this.del_member_flag.setValue(rundata.getParameters().getString("del_member_flag"));
                }
                if (rundata.getParameters().containsKey((Object)"del_range_flag")) {
                    this.del_range_flag.setValue(rundata.getParameters().getString("del_range_flag"));
                }
                int userid = 0;
                if (rundata.getParameters().containsKey((Object)"userid")) {
                    userid = rundata.getParameters().getInt("userid");
                }
                boolean is_facility = false;
                if (rundata.getParameters().containsKey((Object)"type")) {
                    is_facility = "F".equals(rundata.getParameters().getString("type"));
                }
                if ((schedule = ScheduleUtils.getEipTSchedule(rundata, context, false)) == null) {
                    return false;
                }
                List<ALEipUser> members = ScheduleUtils.getUsers(rundata, context, true);
                if (members != null && members.size() > 0) {
                    this.memberList.addAll(members);
                }
                boolean acl_delete_other = ScheduleUtils.hasAuthorityForOtherSchedule(rundata, 16);
                boolean isMember = false;
                int loginuserId = (int)this.login_user.getUserId().getValue();
                for (ALEipUser user : this.memberList) {
                    if ((long)loginuserId != user.getUserId().getValue()) continue;
                    isMember = true;
                    break;
                }
                if (!acl_delete_other && !isMember && schedule.getCreateUserId() != loginuserId) {
                    logger.error((Object)"[ScheduleFormData] ALPageNotFoundException: The user does not have the auth to delete the schedule.");
                    throw new ALPermissionException();
                }
                if (!acl_delete_other && loginuserId != schedule.getOwnerId() && "F".equals(schedule.getEditFlag()) && 1L != this.del_member_flag.getValue()) {
                    logger.error((Object)"[ScheduleFormData] ALPageNotFoundException: The user does not have the auth to delete the schedule.");
                    throw new ALPermissionException();
                }
                if (this.del_member_flag.getValue() == 0L) {
                    if (this.del_range_flag.getValue() == 0L) {
                        this.deleteMemberAllRangeAll(schedule, members);
                    } else {
                        this.deleteMemberAllRangeOneday(schedule, members);
                    }
                } else if (this.del_range_flag.getValue() == 0L) {
                    this.deleteMemberOneRangeAll(schedule, members, is_facility, userid, acl_delete_other);
                } else {
                    this.deleteMemberOneRangeOneday(schedule, members, is_facility, userid, acl_delete_other, rundata, context);
                }
                Database.commit();
                if (this.del_member_flag.getValue() == 0L && this.del_range_flag.getValue() == 0L) {
                    TimelineUtils.deleteTimelineActivity((RunData)rundata, (Context)context, (String)"Schedule", (String)schedule.getScheduleId().toString());
                } else if (this.del_member_flag.getValue() == 1L) {
                    SelectQuery query2 = Database.query(EipTScheduleMap.class);
                    Expression exp11 = ExpressionFactory.matchExp((String)"scheduleId", (Object)Integer.valueOf(rundata.getParameters().getString("entityid")));
                    query2.andQualifier(exp11);
                    List scheduleMap = query2.fetchList();
                    if (scheduleMap.size() == 0) {
                        TimelineUtils.deleteTimelineActivity((RunData)rundata, (Context)context, (String)"Schedule", (String)schedule.getScheduleId().toString());
                    }
                }
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(schedule.getScheduleId().intValue(), 240, schedule.getName());
                String loginName = this.loginUser.getName().getValue();
                ArrayList<String> recipients = new ArrayList<String>();
                for (ALEipUser user : this.memberList) {
                    if (this.loginUser.getUserId().getValue() == user.getUserId().getValue()) continue;
                    recipients.add(user.getName().getValue());
                }
                int ownerid = ALEipUtils.getUserId((RunData)rundata);
                ScheduleUtils.createShareScheduleActivity(schedule, loginName, recipients, "delete", ownerid);
                if ("O".equals(schedule.getPublicFlag()) && recipients != null && recipients.size() > 0) {
                    ScheduleUtils.createNewScheduleActivity(schedule, loginName, "delete", ownerid);
                }
                if (!"A".equals(schedule.getMailFlag()) && !"I".equals(schedule.getMailFlag())) break block29;
                try {
                    int msgType = ALMailUtils.getSendDestType((int)24);
                    if (msgType > 0) {
                        List destMemberList = ALMailUtils.getALEipUserAddrs(this.memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
                        String subject = "[" + ALOrgUtilsService.getAlias() + "]\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb";
                        String orgId = Database.getDomainName();
                        ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
                        for (ALEipUserAddr destMember : destMemberList) {
                            ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                            message.setPcSubject(subject);
                            message.setCellularSubject(subject);
                            message.setPcBody(ScheduleUtils.createMsgForPc(rundata, schedule, this.memberList, "delete"));
                            message.setCellularBody(ScheduleUtils.createMsgForCellPhone(rundata, schedule, this.memberList, destMember.getUserId(), "delete"));
                            messageList.add(message);
                        }
                        ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)24)));
                    }
                }
                catch (Exception e) {
                    throw new MailSendException();
                }
            }
            catch (RuntimeException e) {
                Database.rollback();
                logger.error((Object)"[ScheduleFormData]", (Throwable)e);
                throw new ALDBErrorException();
            }
            catch (MailSendException e) {
                msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_DONOT_SEND_MAIL"));
                logger.error((Object)"schedule", (Throwable)e);
                return false;
            }
            catch (Exception e) {
                Database.rollback();
                logger.error((Object)"[ScheduleFormData]", (Throwable)e);
                throw new ALDBErrorException();
            }
        }
        return true;
    }

    public boolean doViewForm(ALAction action, RunData rundata, Context context) {
        try {
            boolean isedit;
            this.init(action, rundata, context);
            boolean bl = isedit = rundata.getParameters().containsKey((Object)"entityid") && !"new".equals(rundata.getParameters().getString("entityid"));
            if (this.is_copy) {
                isedit = false;
            }
            int aclType = 4;
            if (isedit) {
                aclType = 8;
            }
            this.doCheckAclPermission(rundata, context, aclType);
            action.setMode(isedit ? "edit_form" : "new_form");
            this.setMode(action.getMode());
            ArrayList<String> msgList = new ArrayList<String>();
            boolean res = isedit || this.is_copy ? this.loadFormData(rundata, context, msgList) : this.setFormData(rundata, context, msgList);
            action.setResultData((Object)this);
            if (!msgList.isEmpty()) {
                action.addErrorMessages(msgList);
            }
            action.putData(rundata, context);
            return res;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    public boolean doInsert(ALAction action, RunData rundata, Context context) {
        boolean res = super.doInsert(action, rundata, context);
        return res;
    }

    public boolean doUpdate(ALAction action, RunData rundata, Context context) {
        boolean res = super.doUpdate(action, rundata, context);
        return res;
    }

    private boolean facilityCheckAclPermission(RunData rundata, int aclType) {
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "schedule_facility", aclType);
        return this.hasAuthority;
    }

    private void post(ALAction action, RunData rundata, Context context) {
        this.selectData = new ScheduleOnedayGroupSelectData();
        this.selectData.initField();
        if (this.tmpView != null && !this.tmpView.equals("")) {
            this.selectData.setTmpViewDate(this.tmpView);
        } else {
            this.start_date.setNotNull(true);
            if (this.start_date.validate(new ArrayList())) {
                this.selectData.setTmpViewDate(this.start_date.toString());
            } else if (this.tmpStart == null || this.tmpStart.equals("")) {
                ALDateTimeField now = new ALDateTimeField("yyyy-MM-dd-HH-mm");
                now.setValue(new Date());
                this.selectData.setTmpViewDate(now.toString());
            } else {
                this.selectData.setTmpViewDate(this.tmpStart);
            }
        }
        this.selectData.doSelectList(action, rundata, context);
    }

    private boolean includeWeek(int selectedWeek, int startWeek, int endWeek) {
        if (startWeek <= endWeek) {
            return startWeek <= selectedWeek && selectedWeek <= endWeek;
        }
        return selectedWeek >= startWeek || endWeek >= selectedWeek;
    }

    private void deleteSchedule(EipTSchedule schedule) {
        Integer scheduleId = schedule.getScheduleId();
        Database.delete((Persistent)schedule);
        SelectQuery query = Database.query(EipTSchedule.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"parentId", (Object)scheduleId);
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"eipTScheduleMaps.status", (Object)"D");
        query.andQualifier(exp2);
        List dellist = query.fetchList();
        Database.deleteAll((List)dellist);
    }

    private boolean isContains(List<Integer> memberIdList, int userId) {
        int size = memberIdList.size();
        Integer tmpInt = null;
        for (int i = 0; i < size; ++i) {
            tmpInt = memberIdList.get(i);
            if (userId != tmpInt) continue;
            return true;
        }
        return false;
    }

    public ALDateTimeField getStartDate() {
        return this.start_date;
    }

    public ALDateTimeField getStartDateSub() {
        ALDateTimeField tmpDate = new ALDateTimeField("yyyy/MM/dd");
        tmpDate.setValue(this.start_date.getValue());
        return tmpDate;
    }

    public ALDateTimeField getStartDateTime() {
        ALDateTimeField tmpDate = new ALDateTimeField("HH:mm");
        tmpDate.setValue(this.start_date.getValue());
        return tmpDate;
    }

    public ALDateTimeField getEndDate() {
        return this.end_date;
    }

    public ALDateTimeField getEndDateSub() {
        ALDateTimeField tmpDate = new ALDateTimeField("yyyy/MM/dd");
        tmpDate.setValue(this.end_date.getValue());
        return tmpDate;
    }

    public ALDateTimeField getEndDateTime() {
        ALDateTimeField tmpDate = new ALDateTimeField("HH:mm");
        tmpDate.setValue(this.end_date.getValue());
        return tmpDate;
    }

    public List<ALEipUser> getMemberList() {
        return this.memberList;
    }

    public List<ALEipUser> getUsers(String groupname) {
        return ALEipUtils.getUsers((String)groupname);
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public ALStringField getName() {
        return this.name;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALStringField getPlace() {
        return this.place;
    }

    public int getCurrentYear() {
        return this.currentYear;
    }

    public boolean isMember() {
        return this.is_member || this.memberList.size() > 1;
    }

    public boolean isOwner() {
        return this.is_owner;
    }

    public ALEipUser getLoginUser() {
        return this.login_user;
    }

    public ScheduleOnedayGroupSelectData getSelectData() {
        return this.selectData;
    }

    public ALStringField getPublicFlag() {
        return this.public_flag;
    }

    public String getMailFlag() {
        return this.mail_flag;
    }

    public boolean isRepeat() {
        return this.is_repeat;
    }

    public boolean isSpan() {
        return this.is_span;
    }

    public boolean isCopy() {
        return this.is_copy;
    }

    public ALDateField getLimitStartDate() {
        return this.limit_start_date;
    }

    public ALDateTimeField getLimitStartDateSub() {
        ALDateTimeField tmpDate = new ALDateTimeField("yyyy/MM/dd");
        try {
            tmpDate.setValue(this.limit_start_date.getValue().getDate());
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleFormData]", (Throwable)e);
        }
        return tmpDate;
    }

    public ALDateField getLimitEndDate() {
        return this.limit_end_date;
    }

    public ALDateTimeField getLimitEndDateSub() {
        ALDateTimeField tmpDate = new ALDateTimeField("yyyy/MM/dd");
        try {
            tmpDate.setValue(this.limit_end_date.getValue().getDate());
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleFormData]", (Throwable)e);
        }
        return tmpDate;
    }

    public ALStringField getLimitFlag() {
        return this.limit_flag;
    }

    public ALStringField getAllDayFlag() {
        return this.all_day_flag;
    }

    public ALNumberField getMonthDay() {
        return this.month_day;
    }

    public ALNumberField getYearMonth() {
        return this.year_month;
    }

    public ALNumberField getYearDay() {
        return this.year_day;
    }

    public ALStringField getRepeatType() {
        return this.repeat_type;
    }

    public ALStringField getWeek0() {
        return this.week_0;
    }

    public ALStringField getWeek1() {
        return this.week_1;
    }

    public ALStringField getWeek2() {
        return this.week_2;
    }

    public ALStringField getWeek3() {
        return this.week_3;
    }

    public ALStringField getWeek4() {
        return this.week_4;
    }

    public ALStringField getWeek5() {
        return this.week_5;
    }

    public ALStringField getWeek6() {
        return this.week_6;
    }

    public ALStringField getRepeatWeek() {
        return this.repeat_week;
    }

    public List<ALEipGroup> getGroupList() {
        return this.groups;
    }

    public ALNumberField getEditRepeatFlag() {
        return this.edit_repeat_flag;
    }

    public ALStringField getEditFlag() {
        return this.edit_flag;
    }

    public ALStringField getChangeTmpreserveFlag() {
        return this.change_tmpreserve_flag;
    }

    public ALDateTimeField getViewDate() {
        return this.view_date;
    }

    public String getOnlyViewDateText() {
        return ALLocalizationUtils.getl10nFormat((String)"SCHEDULE_ONLY_DATE_FORMAT", (Object[])new Object[]{this.view_date.getYear(), this.view_date.getMonth(), this.view_date.getDay()});
    }

    public int getInt(long num) {
        return (int)num;
    }

    public boolean isFacility() {
        return this.is_facility || this.facilityList.size() > 0;
    }

    public List<Object> getFacilityList() {
        return this.facilityList;
    }

    public List<FacilityResultData> getFacilityAllList() {
        return this.facilityAllList;
    }

    public ALNumberField getCommonCategoryId() {
        return this.common_category_id;
    }

    public int getMsgType() {
        return 0;
    }

    public boolean getIsSameDate() {
        return this.is_same_date;
    }

    public boolean getIsSameTime() {
        return this.start_date.getTime().equals(this.end_date.getTime());
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }

    public boolean isDisplayManHour() {
        return !Registry.getEntry((String)Registry.PORTLET, (String)"ManHour").isHidden();
    }
}

