/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.cayenne.om.portlet.VEipTScheduleList;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.ScheduleResultData;
import com.aimluck.eip.schedule.ScheduleTermWeekContainer;
import com.aimluck.eip.schedule.ScheduleToDoResultData;
import com.aimluck.eip.schedule.ScheduleToDoWeekContainer;
import com.aimluck.eip.schedule.ScheduleWeekContainer;
import com.aimluck.eip.schedule.ScheduleWeeklySelectData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ScheduleWeeklyGroupSelectData
extends ScheduleWeeklySelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleWeeklyGroupSelectData.class.getName());
    private Map<Integer, List<ScheduleTermWeekContainer>> termmap;
    private Map<Integer, List<ScheduleTermWeekContainer>> facilitytermmap;
    private Map<Integer, ScheduleWeekContainer> map;
    private List<ALEipUser> members;
    private List<ALEipGroup> groups;
    private List<ALEipGroup> facilitiyGroups;
    private Integer userid;
    private String myGroupURI;
    private Map<Integer, List<ScheduleToDoWeekContainer>> todomap;
    private String portletId;
    private Map<Integer, ScheduleWeekContainer> facilitymap;
    private List<FacilityResultData> facilityList;
    private boolean hasAuthoritySelfInsert = false;
    private boolean hasAuthorityFacilityInsert = false;
    private boolean hasAclviewOther = false;
    private TurbineGroup target_group_name;

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        if (rundata.getParameters().containsKey((Object)"filter")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"com.aimluck.eip.schedule.filter", (String)rundata.getParameters().getString("filter"));
        }
        if (rundata.getParameters().containsKey((Object)"filtertype")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"com.aimluck.eip.schedule.filtertype", (String)rundata.getParameters().getString("filtertype"));
        }
        this.viewtype = "weekly-group";
        try {
            VelocityPortlet portlet;
            String groupName;
            this.termmap = new LinkedHashMap<Integer, List<ScheduleTermWeekContainer>>();
            this.facilitytermmap = new LinkedHashMap<Integer, List<ScheduleTermWeekContainer>>();
            this.map = new LinkedHashMap<Integer, ScheduleWeekContainer>();
            this.todomap = new LinkedHashMap<Integer, List<ScheduleToDoWeekContainer>>();
            this.facilitymap = new LinkedHashMap<Integer, ScheduleWeekContainer>();
            this.groups = ALEipUtils.getMyGroups((RunData)rundata);
            this.facilitiyGroups = ALEipUtils.getALEipGroups();
            this.userid = ALEipUtils.getUserId((RunData)rundata);
            String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"com.aimluck.eip.schedule.filter");
            this.target_group_name = this.getGroup(filter);
            if (filter == null && (groupName = (portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context)).getPortletConfig().getInitParameter("p3a-group")) != null) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"com.aimluck.eip.schedule.filter", (String)groupName);
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"com.aimluck.eip.schedule.filtertype", (String)"group");
            }
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            this.hasAclviewOther = aclhandler.hasAuthority(this.userid.intValue(), "schedule_other", 1);
            this.hasAuthoritySelfInsert = aclhandler.hasAuthority(this.userid.intValue(), "schedule_self", 4);
            this.hasAuthorityFacilityInsert = aclhandler.hasAuthority(this.userid.intValue(), "schedule_facility", 4);
            this.myGroupURI = ScheduleUtils.getPortletURIinPersonalConfigPane(rundata, "MyGroup");
        }
        catch (Exception ex) {
            logger.error((Object)"schedule", (Throwable)ex);
        }
    }

    @Override
    protected ResultList<VEipTScheduleList> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        try {
            List<VEipTScheduleList> list = this.getScheduleList(rundata, context);
            if (this.viewTodo == 1) {
                this.loadTodo(rundata, context);
            }
            ScheduleUtils.sortByTime(list);
            return new ResultList(ScheduleUtils.sortByDummySchedule(list));
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleWeeklyGroupSelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
    }

    @Override
    protected Object getResultData(VEipTScheduleList record) throws ALPageNotFoundException, ALDBErrorException {
        ScheduleResultData rd = new ScheduleResultData();
        rd.initField();
        try {
            if ("R".equals(record.getStatus())) {
                return rd;
            }
            boolean is_member = record.isMember();
            if (!"D".equals(record.getStatus()) && "P".equals(record.getPublicFlag()) && this.userid.intValue() != record.getUserId().intValue() && this.userid.intValue() != record.getOwnerId().intValue() && !is_member) {
                return rd;
            }
            if (!this.hasAclviewOther && !is_member) {
                return rd;
            }
            if ("C".equals(record.getPublicFlag()) && this.userid.intValue() != record.getUserId().intValue() && this.userid.intValue() != record.getOwnerId().intValue() && !is_member) {
                rd.setName(ALLocalizationUtils.getl10n((String)"SCHEDULE_CLOSE_PUBLIC_WORD"));
                rd.setTmpreserve(false);
            } else {
                rd.setName(record.getName());
                rd.setTmpreserve("T".equals(record.getStatus()));
            }
            rd.setScheduleId(record.getScheduleId());
            rd.setParentId(record.getParentId());
            rd.setStartDate(record.getStartDate());
            rd.setEndDate(record.getEndDate());
            rd.setPublic("O".equals(record.getPublicFlag()));
            rd.setHidden("P".equals(record.getPublicFlag()));
            rd.setDummy("D".equals(record.getStatus()));
            rd.setLoginuser(record.getUserId().intValue() == this.userid.intValue());
            rd.setOwner(record.getOwnerId().intValue() == this.userid.intValue());
            rd.setMember(record.isMember());
            rd.setPattern(record.getRepeatPattern());
            ScheduleWeekContainer weekCon = null;
            weekCon = "U".equals(record.getType()) ? this.map.get(record.getUserId()) : this.facilitymap.get(record.getUserId());
            if (rd.getPattern().equals("S")) {
                int col;
                int count;
                int stime = -((int)((this.getViewStart().getValue().getTime() - rd.getStartDate().getValue().getTime()) / 86400000L));
                int etime = -((int)((this.getViewStart().getValue().getTime() - rd.getEndDate().getValue().getTime()) / 86400000L));
                if (stime < 0) {
                    stime = 0;
                }
                if ((count = stime) + (col = etime - stime + 1) > 7) {
                    col = 7 - count;
                }
                rd.setRowspan(col);
                if (col > 0) {
                    if ("U".equals(record.getType())) {
                        List<ScheduleTermWeekContainer> terms = this.termmap.get(record.getUserId());
                        if (terms != null) {
                            ScheduleUtils.addTermSchedule(terms, this.getViewStart().getValue(), count, rd);
                        }
                    } else {
                        List<ScheduleTermWeekContainer> terms = this.facilitytermmap.get(record.getUserId());
                        if (terms != null) {
                            ScheduleUtils.addTermSchedule(terms, this.getViewStart().getValue(), count, rd);
                        }
                    }
                }
                return rd;
            }
            weekCon.addResultData(rd);
        }
        catch (Exception e) {
            logger.error((Object)"schedule", (Throwable)e);
            return null;
        }
        return rd;
    }

    protected List<VEipTScheduleList> getScheduleList(RunData rundata, Context context) {
        String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"com.aimluck.eip.schedule.filter");
        String filter_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"com.aimluck.eip.schedule.filtertype");
        if (filter == null || filter_type == null || filter.equals("")) {
            this.members = new ArrayList<ALEipUser>();
            this.members.add(ALEipUtils.getALEipUser((RunData)rundata));
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.tmpCal.getTime());
            ScheduleWeekContainer week = new ScheduleWeekContainer();
            week.initField();
            week.setViewStartDate(cal);
            this.termmap.put(this.userid, new ArrayList());
            this.map.put(this.userid, week);
            this.todomap.put(this.userid, new ArrayList());
            return ScheduleUtils.getScheduleList(this.userid, this.getViewStart().getValue(), this.getViewEndCrt().getValue(), Arrays.asList(this.userid), null);
        }
        List ulist = ALEipUtils.getUserIds((String)filter);
        int size = ulist.size();
        if (size == 0) {
            ulist.add(-1);
        } else {
            for (int i = 0; i < size; ++i) {
                Integer id = (Integer)ulist.get(i);
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.tmpCal.getTime());
                ScheduleWeekContainer week = new ScheduleWeekContainer();
                week.initField();
                week.setViewStartDate(cal);
                this.termmap.put(id, new ArrayList());
                this.map.put(id, week);
                this.todomap.put(id, new ArrayList());
            }
        }
        ArrayList<Integer> facilityIds = null;
        String[] filteres = filter.split(";");
        if ("Facility".equals(filter)) {
            facilityIds = this.getFacilityIdAllList();
        } else if ("group".equals(filter_type) && !"f".equals(filteres[0])) {
            facilityIds = FacilitiesUtils.getFacilityIds((String)filteres[0]);
        } else if ("f".equals(filteres[0])) {
            facilityIds = FacilitiesUtils.getFacilityGroupIds((Integer)Integer.valueOf(filteres[1]));
        } else if (ScheduleUtils.isNumberValue(filter)) {
            facilityIds = FacilitiesUtils.getFacilityGroupIds((Integer)Integer.valueOf(filter));
        } else {
            VelocityPortlet portlet;
            String groupName;
            facilityIds = new ArrayList<Integer>();
            String[] split = filter.split(",");
            if (split.length == 2 && (groupName = (portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context)).getPortletConfig().getInitParameter("p3a-group")) != null) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"com.aimluck.eip.schedule.filter", (String)groupName);
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"com.aimluck.eip.schedule.filtertype", (String)"group");
            }
        }
        int f_size = facilityIds.size();
        if (f_size == 0) {
            facilityIds.add(-1);
        } else {
            for (int i = 0; i < f_size; ++i) {
                Integer id = (Integer)facilityIds.get(i);
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.tmpCal.getTime());
                ScheduleWeekContainer week = new ScheduleWeekContainer();
                week.initField();
                week.setViewStartDate(cal);
                this.facilitytermmap.put(id, new ArrayList());
                this.facilitymap.put(id, week);
            }
        }
        this.members = ALEipUtils.getUsers((String)filter);
        String flag_changeturn = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"flagchangeturn");
        if ("0".equals(flag_changeturn)) {
            ALEipUser eipUser = null;
            int memberSize = this.members.size();
            for (int i = 0; i < memberSize; ++i) {
                eipUser = this.members.get(i);
                if (eipUser.getUserId().getValue() != (long)this.userid.intValue()) continue;
                this.members.remove(i);
                this.members.add(0, eipUser);
            }
        }
        if ("Facility".equals(filter)) {
            this.facilityList = FacilitiesUtils.getFacilityList((String)filter);
        } else if ("facilitygroup".equals(filter_type) || "f".equals(filteres[0])) {
            if ("f".equals(filteres[0])) {
                this.facilityList = FacilitiesUtils.getFacilityGroupList((Integer)Integer.valueOf(filteres[1]));
            } else if (ScheduleUtils.isNumberValue(filter)) {
                this.facilityList = FacilitiesUtils.getFacilityGroupList((Integer)Integer.valueOf(filter));
            }
        } else {
            this.facilityList = FacilitiesUtils.getFacilityList((String)filter);
        }
        this.current_filter = !"f".equals(filteres[0]) ? filter : filteres[1];
        this.current_filter_type = filter_type;
        return ScheduleUtils.getScheduleList(this.userid, this.getViewStart().getValue(), this.getViewEndCrt().getValue(), ulist, facilityIds);
    }

    private List<Integer> getFacilityIdAllList() {
        ArrayList<Integer> facilityIdAllList = new ArrayList<Integer>();
        try {
            SelectQuery query = Database.query(EipMFacility.class).select("FACILITY_ID");
            List aList = query.fetchList();
            for (EipMFacility record : aList) {
                facilityIdAllList.add(record.getFacilityId());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"schedule", (Throwable)ex);
        }
        return facilityIdAllList;
    }

    @Override
    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("group", "userId");
        return map;
    }

    @Override
    public void loadTodo(RunData rundata, Context context) {
        try {
            List todos = this.getSelectQueryForTodo(rundata, context).fetchList();
            int todossize = todos.size();
            for (int i = 0; i < todossize; ++i) {
                List<ScheduleToDoWeekContainer> usertodos1;
                int col;
                int count;
                EipTTodo record = (EipTTodo)todos.get(i);
                ScheduleToDoResultData rd = new ScheduleToDoResultData();
                rd.initField();
                String todo_url = "";
                todo_url = this.userid.intValue() == record.getTurbineUser().getUserId().intValue() ? ScheduleUtils.getPortletURItoTodoDetailPane(rundata, "ToDo", record.getTodoId().longValue(), this.portletId) : ScheduleUtils.getPortletURItoTodoPublicDetailPane(rundata, "ToDo", record.getTodoId().longValue(), this.portletId);
                rd.setTodoId(record.getTodoId().intValue());
                rd.setTodoName(record.getTodoName());
                rd.setUserId(record.getTurbineUser().getUserId().intValue());
                rd.setStartDate(record.getStartDate());
                rd.setEndDate(record.getEndDate());
                rd.setTodoUrl(todo_url);
                rd.setPublicFlag("T".equals(record.getPublicFlag()));
                int stime = ScheduleUtils.equalsToDate(ToDoUtils.getEmptyDate(), rd.getStartDate().getValue(), false) ? 0 : -((int)((this.getViewStart().getValue().getTime() - rd.getStartDate().getValue().getTime()) / 86400000L));
                int etime = -((int)((this.getViewStart().getValue().getTime() - rd.getEndDate().getValue().getTime()) / 86400000L));
                if (stime < 0) {
                    stime = 0;
                }
                if ((count = stime) + (col = etime - stime + 1) > 7) {
                    col = 7 - count;
                }
                rd.setRowspan(col);
                if (col <= 0 || (usertodos1 = this.todomap.get(record.getTurbineUser().getUserId())) == null) continue;
                ScheduleUtils.addToDo(usertodos1, this.getViewStart().getValue(), count, rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"schedule", (Throwable)ex);
            return;
        }
    }

    private SelectQuery<EipTTodo> getSelectQueryForTodo(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTTodo.class);
        Expression exp1 = ExpressionFactory.noMatchExp((String)"state", (Object)100);
        query.setQualifier(exp1);
        Expression exp01 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)this.userid);
        Expression exp02 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)this.userid);
        Expression exp03 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"T");
        Expression exp04 = ExpressionFactory.matchExp((String)"addonScheduleFlg", (Object)"T");
        query.andQualifier(exp01.orExp(exp02.andExp(exp03)).andExp(exp04));
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.getViewStart().getValue());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.getViewEnd().getValue());
        Expression exp21 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.getViewEnd().getValue());
        Expression exp22 = ExpressionFactory.matchExp((String)"endDate", (Object)ToDoUtils.getEmptyDate());
        Expression exp31 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.getViewStart().getValue());
        Expression exp32 = ExpressionFactory.matchExp((String)"startDate", (Object)ToDoUtils.getEmptyDate());
        query.andQualifier(exp11.andExp(exp12).orExp(exp21.andExp(exp22)).orExp(exp31.andExp(exp32)));
        return query;
    }

    public ScheduleWeekContainer getContainer(long id) {
        return this.map.get((int)id);
    }

    public List<ALEipUser> getMemberList() {
        return this.members;
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List<ALEipGroup> getGroupList() {
        return this.groups;
    }

    public boolean isMatch(long id) {
        return this.userid == (int)id;
    }

    public String getMyGroupURI() {
        return this.myGroupURI;
    }

    public List<ScheduleTermWeekContainer> getTermContainer(long id) {
        return this.termmap.get((int)id);
    }

    public List<ScheduleTermWeekContainer> getFacilityTermContainer(long id) {
        return this.facilitytermmap.get((int)id);
    }

    public List<ScheduleToDoWeekContainer> getToDoContainer(long id) {
        return this.todomap.get((int)id);
    }

    @Override
    public void setPortletId(String id) {
        this.portletId = id;
    }

    public List<FacilityResultData> getFacilityList() {
        return this.facilityList;
    }

    public ScheduleWeekContainer getFacilityContainer(long id) {
        return this.facilitymap.get((int)id);
    }

    public long getUserId() {
        return this.userid.longValue();
    }

    @Override
    public String getAclPortletFeature() {
        return "schedule_self";
    }

    public List<ALEipGroup> getFacilitiyGroupList() {
        return this.facilitiyGroups;
    }

    @Override
    public boolean hasAuthoritySelfInsert() {
        return this.hasAuthoritySelfInsert;
    }

    public boolean hasAuthorityFacilityInsert() {
        return this.hasAuthorityFacilityInsert;
    }

    public TurbineGroup getGroup(String filter) {
        Expression exp1 = ExpressionFactory.matchExp((String)"groupName", (Object)filter);
        SelectQuery query = Database.query(TurbineGroup.class);
        query.setQualifier(exp1);
        List list = query.fetchList();
        if (list.isEmpty()) {
            return null;
        }
        return (TurbineGroup)list.get(0);
    }

    public TurbineGroup getTargetGroupName() {
        return this.target_group_name;
    }

    @Override
    public String getViewStartFormat() {
        return ALLocalizationUtils.getl10nFormat((String)"SCHEDULE_DATE_FORMAT_NOSPACE", (Object[])new Object[]{this.getViewStart().getYear(), this.getViewStart().getMonth(), this.getViewStart().getDay()});
    }

    @Override
    public String getViewEndFormat() {
        return ALLocalizationUtils.getl10nFormat((String)"SCHEDULE_DATE_FORMAT_NOSPACE", (Object[])new Object[]{this.getViewEnd().getYear(), this.getViewEnd().getMonth(), this.getViewEnd().getDay()});
    }
}

