/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.mail.ALAdminMailContext;
import com.aimluck.eip.mail.ALAdminMailMessage;
import com.aimluck.eip.mail.ALMailService;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.schedule.AjaxScheduleDayContainer;
import com.aimluck.eip.schedule.AjaxScheduleResultData;
import com.aimluck.eip.schedule.AjaxScheduleWeeklyGroupSelectData;
import com.aimluck.eip.schedule.AjaxTermScheduleDayContainer;
import com.aimluck.eip.schedule.AjaxTermScheduleWeekContainer;
import com.aimluck.eip.schedule.beans.ScheduleBean;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.services.quota.ALQuotaService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ScheduleWeeklyJSONFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleWeeklyJSONFormData.class.getName());
    private ALDateTimeField startDate;
    private ALDateTimeField endDate;
    private ALDateTimeField viewDate;
    private String start_date;
    private String end_date;
    private String view_date;
    private int entityId;
    private String aclPortletFeature;
    private int userId;
    private EipTSchedule schedule;
    private boolean isEdit;
    private String orgId;
    private int edit_repeat_flag;
    private List<ALEipUser> memberList;
    private List<EipTScheduleMap> scheduleMaps;
    private int ownerId;
    private ArrayList<String> msgList;
    private boolean isViewList;
    private boolean ignore_duplicate_facility;

    public void initField() {
        this.aclPortletFeature = "schedule_self";
    }

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.start_date = null;
        this.end_date = null;
        this.view_date = null;
        this.entityId = 0;
        this.userId = 0;
        this.isEdit = false;
        this.memberList = new ArrayList<ALEipUser>();
        this.scheduleMaps = null;
        this.ownerId = 0;
        this.edit_repeat_flag = 0;
        this.startDate = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        this.endDate = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        this.viewDate = new ALDateTimeField("yyyy-MM-dd");
        this.msgList = new ArrayList();
        this.isViewList = false;
        this.orgId = Database.getDomainName();
        this.aclPortletFeature = "schedule_self";
        this.ignore_duplicate_facility = false;
    }

    public String doViewList(ALAction action, RunData rundata, Context context, List<String> msgList) {
        try {
            ScheduleBean bean;
            AjaxScheduleResultData rd;
            this.doCheckAclPermission(rundata, context, 1);
            ArrayList termScheduleList = new ArrayList();
            List<Object> _scheduleList = new ArrayList();
            ArrayList<ScheduleBean> scheduleList = new ArrayList<ScheduleBean>();
            ArrayList<String> holidayList = new ArrayList<String>();
            ArrayList<String> dateList = new ArrayList<String>();
            ArrayList<String> dayOfWeekList = new ArrayList<String>();
            AjaxScheduleWeeklyGroupSelectData listData = new AjaxScheduleWeeklyGroupSelectData();
            listData.initField();
            listData.doSelectList(null, rundata, context);
            JSONObject json = new JSONObject();
            json.put((Object)"hasAcl", (Object)this.hasAcl(rundata));
            json.put((Object)"today", (Object)listData.getToday().toString());
            json.put((Object)"prevDate", (Object)listData.getPrevDate().toString());
            json.put((Object)"nextDate", (Object)listData.getNextDate().toString());
            json.put((Object)"prevWeek", (Object)listData.getPrevWeek().toString());
            json.put((Object)"nextWeek", (Object)listData.getNextWeek().toString());
            json.put((Object)"prevMonth", (Object)listData.getPrevMonth().toString());
            json.put((Object)"nextMonth", (Object)listData.getNextMonth().toString());
            List<AjaxScheduleDayContainer> dayList = listData.getContainer().getDayList();
            List<AjaxTermScheduleWeekContainer> termList = listData.getWeekTermContainerList();
            int dayListSize = dayList.size();
            Date containerDate = null;
            for (AjaxTermScheduleWeekContainer termContainer : termList) {
                if (!termContainer.hasVisibleTerm()) continue;
                List<AjaxTermScheduleDayContainer> termDayList = termContainer.getDayList();
                ArrayList<ScheduleBean> _termScheduleList = new ArrayList<ScheduleBean>();
                int termDayListSize = termDayList.size();
                for (int k = 0; k < termDayListSize; ++k) {
                    AjaxTermScheduleDayContainer termDayContainer = termDayList.get(k);
                    if (k == 0) {
                        containerDate = termDayContainer.getDate().getValue();
                    }
                    if ((rd = termDayContainer.getTermResultData()) == null || containerDate == null) continue;
                    int stime = (int)(rd.getStartDate().getValue().getTime() / 86400000L);
                    int etime = (int)(rd.getEndDate().getValue().getTime() / 86400000L);
                    int ctime = (int)(containerDate.getTime() / 86400000L);
                    int col = etime - stime + 1;
                    int rindex = stime - ctime;
                    bean = new ScheduleBean();
                    bean.initField();
                    bean.setResultData(rd);
                    if (!rd.isPublic() && !rd.isMember()) {
                        bean.setName(ALLocalizationUtils.getl10n((String)"SCHEDULE_CLOSE_PUBLIC_WORD"));
                    }
                    bean.setColspanReal(col);
                    bean.setIndex(k);
                    bean.setIndexReal(rindex);
                    if (rd.isHidden() && !rd.isMember()) continue;
                    _termScheduleList.add(bean);
                }
                if (rundata.getParameters().getString("m_empty").equals("empty")) continue;
                termScheduleList.add(_termScheduleList);
            }
            for (int i = 0; i < dayListSize; ++i) {
                AjaxScheduleDayContainer container = dayList.get(i);
                if (i == 0) {
                    containerDate = container.getDate().getValue();
                }
                dateList.add(container.getDate().toString());
                dayOfWeekList.add(container.getDate().getDayOfWeek());
                _scheduleList = container.getScheduleList();
                if (container.isHoliday()) {
                    holidayList.add(container.getHoliday().getName().getValue());
                } else {
                    holidayList.add("");
                }
                if (i == 0) {
                    json.put((Object)"startDate", (Object)container.getDate().toString());
                } else if (i == dayListSize - 1) {
                    json.put((Object)"endDate", (Object)container.getDate().toString());
                }
                int scheSize = _scheduleList.size();
                for (int j = 0; j < scheSize; ++j) {
                    rd = (AjaxScheduleResultData)_scheduleList.get(j);
                    if (rd.isDummy()) continue;
                    bean = new ScheduleBean();
                    bean.initField();
                    bean.setResultData(rd);
                    if (!rd.isPublic() && !rd.isMember()) {
                        bean.setName(ALLocalizationUtils.getl10n((String)"SCHEDULE_CLOSE_PUBLIC_WORD"));
                    }
                    bean.setIndex(i);
                    if (rundata.getParameters().getString("m_empty") == null || rundata.getParameters().getString("m_empty").equals("empty") || rd.isHidden() && !rd.isMember()) continue;
                    scheduleList.add(bean);
                }
            }
            json.put((Object)"termSchedule", termScheduleList);
            json.put((Object)"schedule", scheduleList);
            json.put((Object)"holiday", holidayList);
            json.put((Object)"date", dateList);
            json.put((Object)"dayOfWeek", dayOfWeekList);
            if (msgList != null && msgList.size() > 0) {
                json.put((Object)"errList", msgList);
            }
            return json.toString();
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return null;
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleWeeklyJSONFormData]", (Throwable)e);
            return null;
        }
    }

    protected boolean isOverQuota() {
        return ALQuotaService.isOverQuota((String)Database.getDomainName());
    }

    public boolean doUpdate(ALAction action, RunData rundata, Context context) {
        if (!ScheduleUtils.hasRelation(rundata)) {
            this.aclPortletFeature = "schedule_other";
        }
        try {
            if (!this.doCheckSecurity(rundata, context)) {
                return false;
            }
            this.doCheckAclPermission(rundata, context, 8);
            boolean res = false;
            if (this.isOverQuota()) {
                this.msgList.add(ALLocalizationUtils.getl10n((String)"COMMON_FULL_DISK_DELETE_DETA_OR_CHANGE_PLAN"));
            } else {
                res = this.setFormData(rundata, context, this.msgList) && this.validate(this.msgList) && this.updateFormData(rundata, context, this.msgList);
            }
            return res;
        }
        catch (ALPermissionException e) {
            this.msgList.add("PermissionError");
            this.msgList.add("\u30a2\u30af\u30bb\u30b9\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u30b7\u30b9\u30c6\u30e0\u7ba1\u7406\u8005\u306b\u304a\u554f\u3044\u5408\u308f\u305b\u304f\u3060\u3055\u3044\u3002");
            return false;
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"schedule", (Throwable)e);
            return false;
        }
    }

    public boolean doInsert(ALAction action, RunData rundata, Context context) {
        if (!ScheduleUtils.hasRelation(rundata)) {
            this.aclPortletFeature = "schedule_other";
        }
        try {
            if (!this.doCheckSecurity(rundata, context)) {
                return false;
            }
            this.doCheckAclPermission(rundata, context, 4);
            boolean res = false;
            if (this.isOverQuota()) {
                this.msgList.add(ALLocalizationUtils.getl10n((String)"COMMON_FULL_DISK_DELETE_DETA_OR_CHANGE_PLAN"));
            } else {
                res = this.setFormData(rundata, context, this.msgList) && this.validate(this.msgList) && this.insertFormData(rundata, context, this.msgList);
            }
            return res;
        }
        catch (ALPermissionException e) {
            this.msgList.add("PermissionError");
            this.msgList.add("\u30a2\u30af\u30bb\u30b9\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u30b7\u30b9\u30c6\u30e0\u7ba1\u7406\u8005\u306b\u304a\u554f\u3044\u5408\u308f\u305b\u304f\u3060\u3055\u3044\u3002");
            return false;
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"schedule", (Throwable)e);
            return false;
        }
    }

    public void loadParameters(RunData rundata, Context context, List<String> msgList) {
        ALDateTimeField dummy = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        dummy.setNotNull(true);
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            if (rundata.getParameters().containsKey((Object)"start_date") && rundata.getParameters().containsKey((Object)"end_date")) {
                this.start_date = rundata.getParameters().getString("start_date");
                dummy.setValue(this.start_date);
                if (!dummy.validate(new ArrayList())) {
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"start_date");
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"end_date");
                    msgList.add("starDate_irregular");
                    return;
                }
                this.end_date = rundata.getParameters().getString("end_date");
                dummy.setValue(this.end_date);
                if (!dummy.validate(new ArrayList())) {
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"end_date");
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"end_date");
                    msgList.add("endDate_irregular");
                    return;
                }
                if (rundata.getParameters().containsKey((Object)"view_date")) {
                    this.view_date = rundata.getParameters().getString("view_date");
                    dummy.setValue(this.view_date);
                    if (!dummy.validate(new ArrayList())) {
                        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"view_date");
                        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"view_date");
                        msgList.add("viewDate_irregular");
                        return;
                    }
                }
                if (!rundata.getParameters().containsKey((Object)"entityid")) {
                    msgList.add("entityId_missing");
                    return;
                }
                this.entityId = rundata.getParameters().getInt("entityid");
                if (rundata.getParameters().containsKey((Object)"ign_dup_f")) {
                    this.ignore_duplicate_facility = rundata.getParameters().getBoolean("ign_dup_f", false);
                }
            } else {
                this.isViewList = true;
            }
        } else {
            msgList.add("not own portlet");
            return;
        }
    }

    public boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            this.userId = ALEipUtils.getUserId((RunData)rundata);
            this.schedule = ScheduleUtils.getEipTSchedule(rundata, this.entityId, false, this.userId);
            this.isEdit = "T".equals(this.schedule.getEditFlag());
            if (rundata.getParameters().containsKey((Object)"edit_repeat_flag")) {
                this.edit_repeat_flag = rundata.getParameters().getInt("edit_repeat_flag");
            }
            this.scheduleMaps = ScheduleUtils.getEipTScheduleMaps(this.schedule);
            int listSize = this.scheduleMaps.size();
            for (int i = 0; i < listSize; ++i) {
                EipTScheduleMap map = this.scheduleMaps.get(i);
                if (!"U".equals(map.getType())) continue;
                int targetUserId = map.getUserId();
                this.memberList.add(ALEipUtils.getALEipUser((int)targetUserId));
            }
            this.ownerId = this.schedule.getOwnerId();
            this.startDate.setValue(this.start_date);
            this.endDate.setValue(this.end_date);
            this.viewDate.setValue(this.view_date);
        }
        catch (Exception e) {
            logger.error((Object)"schedule", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean validate(List<String> msgList) throws ALDBErrorException, ALPageNotFoundException {
        return msgList.size() <= 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean updateFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean authorityForOtherSchedule = ScheduleUtils.hasAuthorityForOtherSchedule(rundata, 8);
        if (this.isEdit || this.userId == this.ownerId || this.aclPortletFeature == "schedule_other" || authorityForOtherSchedule) {
            boolean res;
            if (this.edit_repeat_flag == 0) {
                if (this.schedule.getStartDate().equals(this.startDate.getValue()) && this.schedule.getEndDate().equals(this.endDate.getValue())) {
                    return true;
                }
                this.schedule.setStartDate(this.startDate.getValue());
                this.schedule.setEndDate(this.endDate.getValue());
                Date now = new Date();
                this.schedule.setUpdateDate(now);
                this.schedule.setUpdateUserId(Integer.valueOf(this.userId));
                int listSize = this.scheduleMaps.size();
                ArrayList<Integer> facilityIdList = new ArrayList<Integer>();
                for (int i = 0; i < listSize; ++i) {
                    EipTScheduleMap map = this.scheduleMaps.get(i);
                    if (!"F".equals(map.getType())) continue;
                    facilityIdList.add(map.getUserId());
                }
                if (!this.ignore_duplicate_facility && facilityIdList.size() > 0 && ScheduleUtils.isDuplicateFacilitySchedule(this.schedule, facilityIdList, null, null)) {
                    msgList.add("duplicate_facility");
                    Database.rollback();
                    return false;
                }
                Database.commit();
                res = true;
                this.sendEventLog(rundata, context);
                this.sendWhatsNew(this.schedule, false);
                if (!"A".equals(this.schedule.getMailFlag())) {
                    if (!"U".equals(this.schedule.getMailFlag())) return res;
                }
                try {
                    int msgType = ALMailUtils.getSendDestType((int)24);
                    if (msgType <= 0) return res;
                    List destMemberList = ALMailUtils.getALEipUserAddrs(this.memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
                    String subject = "[" + ALOrgUtilsService.getAlias() + "]\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb";
                    ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
                    for (ALEipUserAddr destMember : destMemberList) {
                        ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                        message.setPcSubject(subject);
                        message.setCellularSubject(subject);
                        message.setPcBody(ScheduleUtils.createMsgForPc(rundata, this.schedule, this.memberList, "edit"));
                        message.setCellularBody(ScheduleUtils.createMsgForCellPhone(rundata, this.schedule, this.memberList, destMember.getUserId(), "edit"));
                        messageList.add(message);
                    }
                    ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(this.orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)24)));
                    return res;
                }
                catch (Exception ex) {
                    msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_DONOT_SEND_MAIL"));
                    logger.error((Object)"schedule", (Throwable)ex);
                    return false;
                }
            } else {
                Calendar saved_startdate = Calendar.getInstance();
                saved_startdate.setTime(this.schedule.getStartDate());
                Calendar saved_enddate = Calendar.getInstance();
                saved_enddate.setTime(this.schedule.getEndDate());
                if (Integer.valueOf(this.startDate.getHour()).intValue() == saved_startdate.get(11) && Integer.valueOf(this.startDate.getMinute()).intValue() == saved_startdate.get(12) && Integer.valueOf(this.endDate.getHour()).intValue() == saved_enddate.get(11) && Integer.valueOf(this.endDate.getMinute()).intValue() == saved_enddate.get(12) && this.viewDate.getMonth().equals(this.startDate.getMonth()) && this.viewDate.getDay().equals(this.startDate.getDay()) && this.viewDate.getYear().equals(this.startDate.getYear())) {
                    return true;
                }
                EipTSchedule newSchedule = (EipTSchedule)Database.create(EipTSchedule.class);
                newSchedule.setParentId(this.schedule.getScheduleId());
                newSchedule.setName(this.schedule.getName());
                newSchedule.setPlace(this.schedule.getPlace());
                newSchedule.setNote(this.schedule.getNote());
                newSchedule.setPublicFlag(this.schedule.getPublicFlag());
                newSchedule.setEditFlag(this.schedule.getEditFlag());
                newSchedule.setOwnerId(Integer.valueOf(this.ownerId));
                Date now = new Date();
                newSchedule.setCreateDate(now);
                newSchedule.setCreateUserId(Integer.valueOf(this.ownerId));
                newSchedule.setUpdateDate(now);
                newSchedule.setUpdateUserId(Integer.valueOf(this.userId));
                newSchedule.setEndDate(this.endDate.getValue());
                newSchedule.setRepeatPattern("N");
                newSchedule.setStartDate(this.startDate.getValue());
                int listSize = this.scheduleMaps.size();
                ArrayList<Integer> memberIdList = new ArrayList<Integer>();
                ArrayList<Integer> facilityIdList = new ArrayList<Integer>();
                for (int i = 0; i < listSize; ++i) {
                    EipTScheduleMap newMap = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
                    EipTScheduleMap map = this.scheduleMaps.get(i);
                    newMap.setEipTSchedule(newSchedule);
                    newMap.setUserId(map.getUserId());
                    if (map.getUserId() == this.ownerId) {
                        newMap.setStatus("O");
                    } else {
                        EipTScheduleMap tmpMap = this.getScheduleMap(this.scheduleMaps, map.getUserId(), "U");
                        if (tmpMap != null) {
                            newMap.setStatus(tmpMap.getStatus());
                        } else {
                            newMap.setStatus("T");
                        }
                    }
                    newMap.setType(map.getType());
                    newMap.setCommonCategoryId(map.getCommonCategoryId());
                    newMap.setEipTCommonCategory(map.getEipTCommonCategory());
                    if ("U".equals(map.getType())) {
                        memberIdList.add((int)map.getUserId());
                        continue;
                    }
                    facilityIdList.add((int)map.getUserId());
                }
                if (!this.ignore_duplicate_facility && facilityIdList.size() > 0 && ScheduleUtils.isDuplicateFacilitySchedule(newSchedule, facilityIdList, this.schedule.getScheduleId(), this.viewDate.getValue())) {
                    msgList.add("duplicate_facility");
                    Database.rollback();
                    return false;
                }
                if (this.viewDate != null) {
                    ScheduleUtils.insertDummySchedule(this.schedule, this.userId, this.viewDate.getValue(), this.viewDate.getValue(), memberIdList, facilityIdList);
                }
                Database.commit();
                res = true;
                this.sendEventLog(rundata, context);
                this.sendWhatsNew(newSchedule, false);
                if (!"A".equals(this.schedule.getMailFlag())) {
                    if (!"U".equals(this.schedule.getMailFlag())) return res;
                }
                try {
                    int msgType = ALMailUtils.getSendDestType((int)24);
                    if (msgType <= 0) return res;
                    List destMemberList = ALMailUtils.getALEipUserAddrs(this.memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
                    String subject = "[" + ALOrgUtilsService.getAlias() + "]\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb";
                    ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
                    for (ALEipUserAddr destMember : destMemberList) {
                        ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                        message.setPcSubject(subject);
                        message.setCellularSubject(subject);
                        message.setPcBody(ScheduleUtils.createMsgForPc(rundata, newSchedule, this.memberList, "edit"));
                        message.setCellularBody(ScheduleUtils.createMsgForCellPhone(rundata, newSchedule, this.memberList, destMember.getUserId(), "edit"));
                        messageList.add(message);
                    }
                    ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(this.orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)24)));
                    return res;
                }
                catch (Exception ex) {
                    msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_DONOT_SEND_MAIL"));
                    logger.error((Object)"schedule", (Throwable)ex);
                    return false;
                }
            }
        } else {
            msgList.add("\u305d\u306e\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb\u306f\u7de8\u96c6\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093");
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) throws ALDBErrorException {
        boolean res;
        boolean authorityForOtherSchedule = ScheduleUtils.hasAuthorityForOtherSchedule(rundata, 4);
        if (!this.isEdit && this.userId != this.ownerId && this.aclPortletFeature != "schedule_other" && !authorityForOtherSchedule) {
            msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_YOU_DONOT_EDIT_THE_SCHEDULE"));
            return false;
        }
        if (this.edit_repeat_flag == 0) {
            EipTSchedule newSchedule = (EipTSchedule)Database.create(EipTSchedule.class);
            newSchedule.setStartDate(this.startDate.getValue());
            newSchedule.setEndDate(this.endDate.getValue());
            Date now = new Date();
            newSchedule.setCreateDate(now);
            newSchedule.setUpdateDate(now);
            newSchedule.setUpdateUserId(Integer.valueOf(this.userId));
            newSchedule.setName(this.schedule.getName());
            newSchedule.setNote(this.schedule.getNote());
            newSchedule.setPlace(this.schedule.getPlace());
            newSchedule.setEditFlag(this.schedule.getEditFlag());
            newSchedule.setPublicFlag(this.schedule.getPublicFlag());
            newSchedule.setRepeatPattern(this.schedule.getRepeatPattern());
            newSchedule.setCreateUserId(this.schedule.getCreateUserId());
            newSchedule.setOwnerId(this.schedule.getOwnerId());
            newSchedule.setParentId(this.schedule.getParentId());
            ArrayList<EipTScheduleMap> newScheduleMaps = new ArrayList<EipTScheduleMap>();
            for (EipTScheduleMap eipTScheduleMap : this.scheduleMaps) {
                EipTScheduleMap newScheduleMap = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
                newScheduleMap.setEipTSchedule(newSchedule);
                newScheduleMap.setEipTCommonCategory(eipTScheduleMap.getEipTCommonCategory());
                newScheduleMap.setStatus(eipTScheduleMap.getStatus());
                newScheduleMap.setType(eipTScheduleMap.getType());
                newScheduleMap.setUserId(eipTScheduleMap.getUserId());
                newScheduleMaps.add(newScheduleMap);
            }
            ArrayList<Integer> facilityIdList = new ArrayList<Integer>();
            for (EipTScheduleMap newScheduleMap : newScheduleMaps) {
                if (!"F".equals(newScheduleMap.getType())) continue;
                facilityIdList.add(newScheduleMap.getUserId());
            }
            if (!this.ignore_duplicate_facility && facilityIdList.size() > 0 && ScheduleUtils.isDuplicateFacilitySchedule(newSchedule, facilityIdList, null, null)) {
                msgList.add("duplicate_facility");
                Database.rollback();
                return false;
            }
            Database.commit();
            res = true;
            this.sendEventLog(rundata, context);
            this.sendWhatsNew(newSchedule, true);
            try {
                int n = ALMailUtils.getSendDestType((int)24);
                if (n <= 0) return res;
                List destMemberList = ALMailUtils.getALEipUserAddrs(this.memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
                String subject = "[" + ALOrgUtilsService.getAlias() + "]\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb";
                ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
                Iterator iterator = destMemberList.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(this.orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)24)));
                        return res;
                    }
                    ALEipUserAddr destMember = (ALEipUserAddr)iterator.next();
                    ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                    message.setPcSubject(subject);
                    message.setCellularSubject(subject);
                    message.setPcBody(ScheduleUtils.createMsgForPc(rundata, this.schedule, this.memberList, "new"));
                    message.setCellularBody(ScheduleUtils.createMsgForCellPhone(rundata, this.schedule, this.memberList, destMember.getUserId(), "new"));
                    messageList.add(message);
                }
            }
            catch (Exception exception) {
                msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_DONOT_SEND_MAIL"));
                logger.error((Object)"schedule", (Throwable)exception);
                return false;
            }
        }
        Calendar saved_startdate = Calendar.getInstance();
        saved_startdate.setTime(this.schedule.getStartDate());
        Calendar saved_enddate = Calendar.getInstance();
        saved_enddate.setTime(this.schedule.getEndDate());
        if (Integer.valueOf(this.startDate.getHour()).intValue() == saved_startdate.get(11) && Integer.valueOf(this.startDate.getMinute()).intValue() == saved_startdate.get(12) && Integer.valueOf(this.endDate.getHour()).intValue() == saved_enddate.get(11) && Integer.valueOf(this.endDate.getMinute()).intValue() == saved_enddate.get(12) && this.viewDate.getMonth().equals(this.startDate.getMonth()) && this.viewDate.getDay().equals(this.startDate.getDay()) && this.viewDate.getYear().equals(this.startDate.getYear())) {
            return true;
        }
        EipTSchedule newSchedule = (EipTSchedule)Database.create(EipTSchedule.class);
        newSchedule.setStartDate(this.startDate.getValue());
        newSchedule.setEndDate(this.endDate.getValue());
        Date now = new Date();
        newSchedule.setCreateDate(now);
        newSchedule.setUpdateDate(now);
        newSchedule.setUpdateUserId(Integer.valueOf(this.userId));
        newSchedule.setParentId(this.schedule.getScheduleId());
        newSchedule.setName(this.schedule.getName());
        newSchedule.setNote(this.schedule.getNote());
        newSchedule.setPlace(this.schedule.getPlace());
        newSchedule.setEditFlag(this.schedule.getEditFlag());
        newSchedule.setPublicFlag(this.schedule.getPublicFlag());
        newSchedule.setRepeatPattern(this.schedule.getRepeatPattern());
        newSchedule.setCreateUserId(this.schedule.getCreateUserId());
        newSchedule.setOwnerId(this.schedule.getOwnerId());
        newSchedule.setParentId(this.schedule.getParentId());
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> facilityIdList = new ArrayList<Integer>();
        for (EipTScheduleMap map : this.scheduleMaps) {
            EipTScheduleMap newMap = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
            newMap.setEipTSchedule(newSchedule);
            newMap.setUserId(map.getUserId());
            if (map.getUserId() == this.ownerId) {
                newMap.setStatus("O");
            } else {
                EipTScheduleMap tmpMap = this.getScheduleMap(this.scheduleMaps, map.getUserId(), "U");
                if (tmpMap != null) {
                    newMap.setStatus(tmpMap.getStatus());
                } else {
                    newMap.setStatus("T");
                }
            }
            newMap.setType(map.getType());
            newMap.setCommonCategoryId(map.getCommonCategoryId());
            newMap.setEipTCommonCategory(map.getEipTCommonCategory());
            if ("U".equals(map.getType())) {
                arrayList.add(map.getUserId());
                continue;
            }
            facilityIdList.add((int)map.getUserId());
        }
        if (!this.ignore_duplicate_facility && facilityIdList.size() > 0 && ScheduleUtils.isDuplicateFacilitySchedule(newSchedule, facilityIdList, this.schedule.getScheduleId(), this.viewDate.getValue())) {
            msgList.add("duplicate_facility");
            Database.rollback();
            return false;
        }
        Database.commit();
        res = true;
        this.sendEventLog(rundata, context);
        this.sendWhatsNew(newSchedule, true);
        try {
            int msgType = ALMailUtils.getSendDestType((int)24);
            if (msgType <= 0) return res;
            List destMemberList = ALMailUtils.getALEipUserAddrs(this.memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
            String subject = "[" + ALOrgUtilsService.getAlias() + "]\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb";
            ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
            for (ALEipUserAddr destMember : destMemberList) {
                ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                message.setPcSubject(subject);
                message.setCellularSubject(subject);
                message.setPcBody(ScheduleUtils.createMsgForPc(rundata, newSchedule, this.memberList, "new"));
                message.setCellularBody(ScheduleUtils.createMsgForCellPhone(rundata, newSchedule, this.memberList, destMember.getUserId(), "new"));
                messageList.add(message);
            }
            Iterator iterator = destMemberList.iterator();
            while (iterator.hasNext()) {
                ALEipUserAddr destMember;
                destMember = (ALEipUserAddr)iterator.next();
                ArrayList<ALEipUserAddr> destMembers = new ArrayList<ALEipUserAddr>();
                destMembers.add(destMember);
                ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(this.orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)24)));
            }
            return res;
        }
        catch (Exception ex) {
            msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_DONOT_SEND_MAIL"));
            logger.error((Object)"schedule", (Throwable)ex);
            return false;
        }
    }

    private boolean doCheckAclPermission(RunData rundata, Context context, int defineAclType) throws ALPermissionException {
        if (defineAclType == 0) {
            return true;
        }
        String pfeature = this.getAclPortletFeature();
        if (pfeature == null || "".equals(pfeature)) {
            return true;
        }
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        boolean hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), pfeature, defineAclType);
        if (!hasAuthority) {
            throw new ALPermissionException();
        }
        return true;
    }

    private void sendEventLog(RunData rundata, Context context) {
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"mode", (String)"update");
        ALEventlogFactoryService.getInstance().getEventlogHandler().log(this.schedule.getScheduleId().intValue(), 240, this.schedule.getName());
    }

    private void sendWhatsNew(EipTSchedule newSchedule, boolean isNew) {
        ALEipUser loginUser = null;
        try {
            loginUser = ALEipUtils.getALEipUser((int)this.userId);
        }
        catch (ALDBErrorException aLDBErrorException) {
            // empty catch block
        }
        if (loginUser != null) {
            String loginName = loginUser.getName().getValue();
            ArrayList<String> recipients = new ArrayList<String>();
            for (ALEipUser user : this.memberList) {
                if (loginUser.getUserId().getValue() == user.getUserId().getValue()) continue;
                recipients.add(user.getName().getValue());
            }
            ScheduleUtils.createShareScheduleActivity(this.schedule, loginName, recipients, "edit", this.userId);
            if ("O".equals(newSchedule.getPublicFlag())) {
                ScheduleUtils.createNewScheduleActivity(this.schedule, loginName, "edit", this.userId);
            }
        }
    }

    private boolean hasAcl(RunData rundata) {
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.aclPortletFeature = "schedule_other";
        boolean hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "schedule_other", 4);
        return hasAuthority;
    }

    private String getAclPortletFeature() {
        return this.aclPortletFeature;
    }

    public List<String> getMsgList() {
        return this.msgList;
    }

    public boolean getIsViewList() {
        return this.isViewList;
    }

    private EipTScheduleMap getScheduleMap(List<EipTScheduleMap> scheduleMaps, int userid, String type) {
        EipTScheduleMap map = null;
        int size = scheduleMaps.size();
        for (int i = 0; i < size; ++i) {
            map = scheduleMaps.get(i);
            if (map.getUserId() != userid || !type.equals(map.getType())) continue;
            return map;
        }
        return null;
    }

    private boolean doCheckSecurity(RunData rundata, Context context) {
        String reqSecid = rundata.getParameters().getString("secid");
        String sessionSecid = (String)rundata.getUser().getTemp("secid");
        return reqSecid != null && reqSecid.equals(sessionSecid);
    }
}

