/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule.beans;

import com.aimluck.commons.field.ALCellDateField;
import com.aimluck.commons.field.ALCellDateTimeField;
import com.aimluck.commons.field.ALCellNumberField;
import com.aimluck.commons.field.ALCellStringField;
import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class CellScheduleFormBean
implements ALData {
    private ALCellDateTimeField start_date;
    private ALCellDateTimeField end_date;
    private ALCellDateTimeField view_date;
    private ALCellStringField repeat_type;
    private ALCellStringField week_0;
    private ALCellStringField week_1;
    private ALCellStringField week_2;
    private ALCellStringField week_3;
    private ALCellStringField week_4;
    private ALCellStringField week_5;
    private ALCellStringField week_6;
    private ALCellStringField repeat_week;
    private ALCellStringField limit_flag;
    private ALCellDateField limit_start_date;
    private ALCellDateField limit_end_date;
    private ALCellNumberField month_day;
    private ALCellNumberField year_month;
    private ALCellNumberField year_day;
    private ALCellNumberField edit_repeat_flag;
    private List<ALEipUser> memberList;
    private List<FacilityResultData> facilityMemberList;
    private ALCellStringField edit_flag;
    private ALCellStringField change_tmpreserve_flag;
    private int current_year;

    public void initField() {
        this.initField(null, null, null);
    }

    public void initField(String tmpStart, String tmpEnd, String tmpView) {
        Calendar cal = Calendar.getInstance();
        int min = cal.get(12);
        if (min <= 15) {
            cal.set(12, 15);
        } else if (min <= 30) {
            cal.set(12, 30);
        } else if (min <= 45) {
            cal.set(12, 45);
        } else {
            cal.set(12, 60);
        }
        Date now = cal.getTime();
        this.start_date = new ALCellDateTimeField("yyyy-MM-dd-HH-mm");
        if (tmpStart == null || tmpStart.equals("")) {
            this.start_date.setValue(now);
        } else {
            this.start_date.setValue(tmpStart);
        }
        this.start_date.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_START_DATE"));
        this.end_date = new ALCellDateTimeField("yyyy-MM-dd-HH-mm");
        if (tmpEnd == null || tmpEnd.equals("")) {
            if (tmpStart == null || tmpStart.equals("")) {
                this.end_date.setValue(now);
            } else {
                this.end_date.setValue(tmpStart);
            }
        } else {
            this.end_date.setValue(tmpEnd);
        }
        this.end_date.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_END_DATE"));
        this.view_date = new ALCellDateTimeField("yyyy-MM-dd");
        if (tmpView == null || tmpView.equals("")) {
            this.view_date.setValue(now);
        } else {
            this.view_date.setValue(tmpView);
        }
        this.view_date.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_SELECT_DATE"));
        this.repeat_type = new ALCellStringField();
        this.repeat_type.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_REPEAT_TYPE"));
        this.repeat_type.setValue("D");
        this.repeat_type.setTrim(true);
        this.week_0 = new ALCellStringField();
        this.week_0.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_SUNDAY"));
        this.week_0.setTrim(true);
        this.week_1 = new ALCellStringField();
        this.week_1.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_MANDAY"));
        this.week_1.setTrim(true);
        this.week_2 = new ALCellStringField();
        this.week_2.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_TUSEDAY"));
        this.week_2.setTrim(true);
        this.week_3 = new ALCellStringField();
        this.week_3.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_WEDNESDAY"));
        this.week_3.setTrim(true);
        this.week_4 = new ALCellStringField();
        this.week_4.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_THURSDAY"));
        this.week_4.setTrim(true);
        this.week_5 = new ALCellStringField();
        this.week_5.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_FRIDAY"));
        this.week_5.setTrim(true);
        this.week_6 = new ALCellStringField();
        this.week_6.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_SATURDAY"));
        this.week_6.setTrim(true);
        this.repeat_week = new ALCellStringField();
        this.repeat_week.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_REPEAT_WEEK"));
        this.repeat_week.setTrim(true);
        this.month_day = new ALCellNumberField();
        this.month_day.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_EVERY_MONTH_DAY"));
        this.month_day.limitValue(1L, 31L);
        this.year_month = new ALCellNumberField();
        this.year_month.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_EVERY_YEAR_MONTH"));
        this.year_month.limitValue(1L, 12L);
        this.year_day = new ALCellNumberField();
        this.year_day.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_EVERY_YEAR_DAY"));
        this.year_day.limitValue(1L, 31L);
        this.limit_flag = new ALCellStringField();
        this.limit_flag.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_REPEAT"));
        this.limit_flag.setValue("OFF");
        this.limit_flag.setTrim(true);
        this.limit_start_date = new ALCellDateField();
        this.limit_start_date.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_REPEAT_LIMIT"));
        this.limit_start_date.setValue(this.start_date.getValue());
        this.limit_end_date = new ALCellDateField();
        this.limit_end_date.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_REPEAT_LIMIT"));
        ALCellDateTimeField tmp_date = new ALCellDateTimeField("yyyy-MM-dd-HH-mm");
        if (tmpEnd == null || tmpEnd.equals("")) {
            if (tmpStart == null || tmpStart.equals("")) {
                tmp_date.setValue(now);
                this.limit_end_date.setValue(tmp_date.getValue());
            } else {
                tmp_date.setValue(tmpStart);
                this.limit_end_date.setValue(tmp_date.getValue());
            }
        } else {
            tmp_date.setValue(tmpEnd);
            this.limit_end_date.setValue(tmp_date.getValue());
        }
        this.edit_repeat_flag = new ALCellNumberField();
        this.edit_repeat_flag.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_REPEAT_EDIT_AREA"));
        this.edit_repeat_flag.setValue(-1L);
        this.memberList = new ArrayList<ALEipUser>();
        this.facilityMemberList = new ArrayList<FacilityResultData>();
        this.edit_flag = new ALCellStringField();
        this.edit_flag.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_EDIT_DELETE_PERMISSION"));
        this.edit_flag.setTrim(true);
        this.edit_flag.setValue("T");
        this.change_tmpreserve_flag = new ALCellStringField();
        this.change_tmpreserve_flag.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_TEMP_SCHEDULE"));
        this.change_tmpreserve_flag.setTrim(true);
        this.change_tmpreserve_flag.setValue("F");
        this.current_year = Calendar.getInstance().get(1);
    }

    public void setResultData(EipTSchedule record) {
        String ptn = record.getRepeatPattern();
        int count = 0;
        boolean is_repeat = true;
        boolean is_span = false;
        if (ptn.charAt(0) == 'D') {
            this.repeat_type.setValue("D");
            count = 1;
        } else if (ptn.charAt(0) == 'W' && ptn.length() == 9) {
            this.repeat_type.setValue("W");
            this.week_0.setValue(ptn.charAt(1) != '0' ? "TRUE" : null);
            this.week_1.setValue(ptn.charAt(2) != '0' ? "TRUE" : null);
            this.week_2.setValue(ptn.charAt(3) != '0' ? "TRUE" : null);
            this.week_3.setValue(ptn.charAt(4) != '0' ? "TRUE" : null);
            this.week_4.setValue(ptn.charAt(5) != '0' ? "TRUE" : null);
            this.week_5.setValue(ptn.charAt(6) != '0' ? "TRUE" : null);
            this.week_6.setValue(ptn.charAt(7) != '0' ? "TRUE" : null);
            count = 8;
        } else if (ptn.charAt(0) == 'W' && ptn.length() == 10) {
            this.repeat_type.setValue("W");
            this.week_0.setValue(ptn.charAt(1) != '0' ? "TRUE" : null);
            this.week_1.setValue(ptn.charAt(2) != '0' ? "TRUE" : null);
            this.week_2.setValue(ptn.charAt(3) != '0' ? "TRUE" : null);
            this.week_3.setValue(ptn.charAt(4) != '0' ? "TRUE" : null);
            this.week_4.setValue(ptn.charAt(5) != '0' ? "TRUE" : null);
            this.week_5.setValue(ptn.charAt(6) != '0' ? "TRUE" : null);
            this.week_6.setValue(ptn.charAt(7) != '0' ? "TRUE" : null);
            this.repeat_week.setValue("0");
            switch (ptn.charAt(8)) {
                case '1': {
                    this.repeat_week.setValue("1");
                    break;
                }
                case '2': {
                    this.repeat_week.setValue("2");
                    break;
                }
                case '3': {
                    this.repeat_week.setValue("3");
                    break;
                }
                case '4': {
                    this.repeat_week.setValue("4");
                    break;
                }
                case '5': {
                    this.repeat_week.setValue("5");
                    break;
                }
            }
            count = 9;
        } else if (ptn.charAt(0) == 'M') {
            this.repeat_type.setValue("M");
            this.month_day.setValue((long)Integer.parseInt(ptn.substring(1, 3)));
            count = 3;
        } else if (ptn.charAt(0) == 'Y') {
            this.repeat_type.setValue("Y");
            this.year_month.setValue((long)Integer.parseInt(ptn.substring(1, 3)));
            this.year_day.setValue((long)Integer.parseInt(ptn.substring(3, 5)));
            count = 5;
        } else if (ptn.charAt(0) == 'S') {
            is_span = true;
            is_repeat = false;
        } else {
            is_repeat = false;
        }
        if (is_repeat) {
            Calendar tmpViewCal = Calendar.getInstance();
            tmpViewCal.setTime(this.view_date.getValue());
            Calendar tmpStartCal = Calendar.getInstance();
            tmpStartCal.setTime(record.getStartDate());
            tmpViewCal.set(11, tmpStartCal.get(11));
            tmpViewCal.set(12, tmpStartCal.get(12));
            this.start_date.setValue(tmpViewCal.getTime());
            Calendar tmpStopCal = Calendar.getInstance();
            tmpStopCal.setTime(record.getEndDate());
            tmpViewCal.set(11, tmpStopCal.get(11));
            tmpViewCal.set(12, tmpStopCal.get(12));
            this.end_date.setValue(tmpViewCal.getTime());
            if (ptn.charAt(count) == 'N') {
                this.limit_start_date.setValue(this.view_date.getValue());
                this.limit_end_date.setValue(this.view_date.getValue());
                this.limit_flag.setValue("OFF");
            } else {
                this.limit_flag.setValue("ON");
                this.limit_start_date.setValue(record.getStartDate());
                this.limit_end_date.setValue(record.getEndDate());
            }
            this.edit_repeat_flag.setValue(0L);
        }
        this.start_date.setValue(record.getStartDate());
        this.end_date.setValue(record.getEndDate());
        this.limit_start_date.setValue(record.getStartDate());
        this.limit_end_date.setValue(record.getEndDate());
    }

    public boolean validateDelegate(List<String> msgList, ALEipUser loginUser, String entityId, String scheduleType) throws ALDBErrorException, ALPageNotFoundException {
        boolean is_repeat = false;
        boolean is_span = false;
        if ("R".equals(scheduleType)) {
            is_repeat = true;
        } else if ("S".equals(scheduleType)) {
            is_span = true;
        }
        if ("".equals(this.week_0.getValue())) {
            this.week_0.setValue(null);
        }
        if ("".equals(this.week_1.getValue())) {
            this.week_1.setValue(null);
        }
        if ("".equals(this.week_2.getValue())) {
            this.week_2.setValue(null);
        }
        if ("".equals(this.week_3.getValue())) {
            this.week_3.setValue(null);
        }
        if ("".equals(this.week_4.getValue())) {
            this.week_4.setValue(null);
        }
        if ("".equals(this.week_5.getValue())) {
            this.week_5.setValue(null);
        }
        if ("".equals(this.week_6.getValue())) {
            this.week_6.setValue(null);
        }
        return ScheduleUtils.validateDelegate((ALDateTimeField)this.getStartDate(), (ALDateTimeField)this.getEndDate(), (ALStringField)this.getRepeatType(), is_repeat, is_span, (ALStringField)this.getWeek0(), (ALStringField)this.getWeek1(), (ALStringField)this.getWeek2(), (ALStringField)this.getWeek3(), (ALStringField)this.getWeek4(), (ALStringField)this.getWeek5(), (ALStringField)this.getWeek6(), (ALStringField)this.getRepeatWeek(), (ALStringField)this.getLimitFlag(), (ALDateField)this.getLimitStartDate(), (ALDateField)this.getLimitEndDate(), (ALNumberField)this.getMonthDay(), (ALNumberField)this.getYearMonth(), (ALNumberField)this.getYearDay(), loginUser, entityId, msgList, true);
    }

    public ALCellDateTimeField getStartDate() {
        return this.start_date;
    }

    public String getStartDateDate() {
        return ScheduleUtils.translateDate(this.start_date.getValue(), "yyyyMMdd");
    }

    public String getStartDateTime() {
        return ScheduleUtils.translateDate(this.start_date.getValue(), "HHmm");
    }

    public String getStartDateDate2() {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.start_date.getValue());
            return ScheduleUtils.translateDate(this.start_date.getValue(), "yyyy/MM/dd") + ALDateUtil.getDayOfWeek((Calendar)cal);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getStartDateTime2() {
        try {
            return ScheduleUtils.translateDate(this.start_date.getValue(), "HH:mm");
        }
        catch (Exception e) {
            return "";
        }
    }

    public ALCellDateTimeField getEndDate() {
        return this.end_date;
    }

    public String getEndDateDate() {
        return ScheduleUtils.translateDate(this.end_date.getValue(), "yyyyMMdd");
    }

    public String getEndDateTime() {
        return ScheduleUtils.translateDate(this.end_date.getValue(), "HHmm");
    }

    public String getEndDateDate2() {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.end_date.getValue());
            return ScheduleUtils.translateDate(this.end_date.getValue(), "yyyy/MM/dd") + ALDateUtil.getDayOfWeek((Calendar)cal);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getEndDateTime2() {
        try {
            return ScheduleUtils.translateDate(this.end_date.getValue(), "HH:mm");
        }
        catch (Exception e) {
            return "";
        }
    }

    public ALCellDateTimeField getViewDate() {
        return this.view_date;
    }

    public ALCellStringField getRepeatType() {
        return this.repeat_type;
    }

    public ALCellStringField getWeek0() {
        return this.week_0;
    }

    public ALCellStringField getWeek1() {
        return this.week_1;
    }

    public ALCellStringField getWeek2() {
        return this.week_2;
    }

    public ALCellStringField getWeek3() {
        return this.week_3;
    }

    public ALCellStringField getWeek4() {
        return this.week_4;
    }

    public ALCellStringField getWeek5() {
        return this.week_5;
    }

    public ALCellStringField getWeek6() {
        return this.week_6;
    }

    public ALCellStringField getRepeatWeek() {
        return this.repeat_week;
    }

    public ALCellStringField getLimitFlag() {
        return this.limit_flag;
    }

    public ALCellDateField getLimitStartDate() {
        return this.limit_start_date;
    }

    public String getLimitStartDateDate() {
        Date date = null;
        try {
            date = this.limit_start_date.getValue().getDate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (date == null) {
            return "";
        }
        return ScheduleUtils.translateDate(date, "yyyyMMdd");
    }

    public String getLimitStartDateDate2() {
        try {
            return ScheduleUtils.translateDate(this.limit_start_date.getValue().getDate(), "yyyy/MM/dd");
        }
        catch (Exception e) {
            return "";
        }
    }

    public ALCellDateField getLimitEndDate() {
        return this.limit_end_date;
    }

    public String getLimitEndDateDate() {
        Date date = null;
        try {
            date = this.limit_end_date.getValue().getDate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (date == null) {
            return "";
        }
        return ScheduleUtils.translateDate(date, "yyyyMMdd");
    }

    public String getLimitEndDateDate2() {
        try {
            return ScheduleUtils.translateDate(this.limit_end_date.getValue().getDate(), "yyyy/MM/dd");
        }
        catch (Exception e) {
            return "";
        }
    }

    public ALCellNumberField getEditRepeatFlag() {
        return this.edit_repeat_flag;
    }

    public ALCellNumberField getMonthDay() {
        return this.month_day;
    }

    public ALCellNumberField getYearMonth() {
        return this.year_month;
    }

    public ALCellNumberField getYearDay() {
        return this.year_day;
    }

    public List<ALEipUser> getMemberList() {
        return this.memberList;
    }

    public List<FacilityResultData> getFacilityMemberList() {
        return this.facilityMemberList;
    }

    public ALCellStringField getEditFlag() {
        return this.edit_flag;
    }

    public ALCellStringField getChangeTmpreserveFlag() {
        return this.change_tmpreserve_flag;
    }

    public int getCurrentYear() {
        return this.current_year;
    }
}

