#include "babel_serializer.h"

#ifdef USE_BABEL

#include <iostream>

using namespace aka2;

void babel_formatter::set_encoding(const std::string &encoding) {
  std::string canonicalized = canonicalize_encoding_name(encoding);
  int enc_out = babel_util::get_encoding_from_label(canonicalized.c_str());
  if (enc_out == babel::base_encoding::unknown) {
    throw aka2::tagged_error("encoding ", encoding, "not found.", __FILE__, __LINE__);
  }
  in_translator_ = 
    babel::manual_translate_engine<std::string, ustring>::
    create(babel_util::default_encoding_, babel::base_encoding::unicode);
  out_translator_ = 
    babel::manual_translate_engine<ustring, std::string>::
    create(babel::base_encoding::unicode, enc_out);

  bom_ = check_bom(encoding);
}

ustring babel_formatter::lcp_to_ucs2(const std::string &source) {
  in_translator_.clear();
  in_translator_.translate(source);
  in_translator_.flush();
  return in_translator_.get_string();
}

void babel_formatter::write(const ustring &entity) {
  if (bom_ != 0) {
    ostm_->write(bom_->chars_, bom_->length_);
    bom_ = 0;
  }  
  out_translator_.clear();
  out_translator_.translate(entity);
  out_translator_.flush();
  const std::string &res = out_translator_;
  ostm_->write(res.c_str(), res.size());
}

#endif
