/* -*- c++ -*- */
#ifndef AKAXISO_XML_DESERIALIZER_ANY_HANDLER_H__
#define AKAXISO_XML_DESERIALIZER_ANY_HANDLER_H__

/** @file akaxiso/parser/any_handler.h */

#include <akaxiso/XML/deserializer/handler.h>

namespace aka2 {

  class any_handler : public handler {
  public:
    any_handler(const qname& tagname, any &an, int depth,
		parser_context &context);
    virtual ~any_handler();

    virtual validation_result query_element(const qname &tagname, const attribute_values &attrs);
    virtual validation_result end_element(const qname &tagname);
    virtual validation_result query_next(const qname &tagname, const attribute_values &attrs);
    virtual bool parse_entity(const std::string &entity);

    virtual node get_node();
    virtual void receive_child(const node &child);
    virtual bool can_skip();
    virtual void abort();
    
  private:
    any &any_;
    any *child_;
  };
  
  
} // namespace aka2

#endif
