/* -*- c++ -*- */
#ifndef AKAXISO_XML_DESERIALIZER_ARRAY_HANDLER_H__
#define AKAXISO_XML_DESERIALIZER_ARRAY_HANDLER_H__

/** @file akaxiso/XML/deserializer/array_handler.h */

#include <akaxiso/XML/deserializer/handler.h>

namespace aka2 {

  class array_handler : public handler {
  public:
    array_handler(const qname &tagname, void *ma, int depth,
		  const array_op &aop, const element_props &props,
		  parser_context &context);
    virtual ~array_handler();
    virtual validation_result query_element(const qname &tagname, const attribute_values &attrs);
    virtual validation_result end_element(const qname &tagname);
    virtual validation_result query_next(const qname &tagname, const attribute_values &attrs);
    virtual bool parse_entity(const std::string &entity);

    virtual node get_node();
    virtual void receive_child(const node &child);

    virtual bool can_skip();
    virtual void abort(); 

  private:
    validation_result parse_element(const qname &tagname, const attribute_values &attrs);
    validation_result find_particle(const qname &tagname, const attribute_values &attrs);

    void *array_;
    void *e_;
    const array_op &aop_;
    const element_props &props_;
    bool is_element_;
    int count_;
  };

} // namespace aka2

#endif
