/* -*- c++ -*- */
#ifndef AKAXISO_XML_DESERIALIZER_DOCUMENT_HANDLER_H__
#define AKAXISO_XML_DESERIALIZER_DOCUMENT_HANDLER_H__

/** @file akaxiso/parser/document_handler.h */

#include <akaxiso/framework/document.h>
#include <akaxiso/framework/namespaces.h>
#include <akaxiso/XML/deserializer/handler.h>

namespace aka2 {

  class locator;
  
  class document_handler {
  public:
    document_handler(prefix_map &pfs);
    ~document_handler();

    void reset();

    void startElement(const qname &tagname, attribute_values& attrs);
    void characters(const char* chars, const unsigned int length);
    void endElement(const qname &tagname);
    void set_locator(const locator* const locator);
    void set_source_name(const std::string &source_name) {
      context_.set_source_name(source_name);
    }

    document *adopt_document();
    const parser_context &get_context() const {
      return context_;
    }

    void start_prefix_mapping(const std::string &prefix, const std::string &uri);
    void end_prefix_mapping(const std::string &prefix);

    document get_document() { return doc_; }

  protected:
    validation_result go_up(const qname& tagname);

  protected:
    std::string charsbuf_;
    parser_context context_;
    document doc_;
    int depth_;
  };

} // namespace aka2

#endif

