// -*- c++ -*-
#ifndef AKAXISO_XML_DESERIALIZER_PTRMEMBER_HANDLER_H__
#define AKAXISO_XML_DESERIALIZER_PTRMEMBER_HANDLER_H__

#include <akaxiso/XML/deserializer/handler.h>

namespace aka2 {

  class ptrmember_handler : public handler {
  public:
    ptrmember_handler(const qname &tagname, void *ma, int depth,
		  const ptrmember_op &pop, const element_props &props,
		  parser_context &context);
    virtual ~ptrmember_handler();
    virtual validation_result query_element(const qname &tagname, const attribute_values &attrs);
    virtual validation_result end_element(const qname &tagname);
    virtual validation_result query_next(const qname &tagname, const attribute_values &attrs);
    virtual bool parse_entity(const std::string &entity);

    virtual node get_node();
    virtual void receive_child(const node &child);

    virtual bool can_skip();
    virtual void abort(); 

  private:
    validation_result parse_element(const qname &tagname, const attribute_values &attrs);
    validation_result find_particle(const qname &tagname, const attribute_values &attrs);

    void *ptrmember_;
    void *e_;
    const ptrmember_op &pop_;
    const element_props &props_;
    bool is_element_;
    bool appeared_;
  };

}

#endif

