// -*- c++ -*-
#ifndef AKAXISO_XML_DESERIALIZER_SAX2_ADAPTOR_H__
#define AKAXISO_XML_DESERIALIZER_SAX2_ADAPTOR_H__

#include <akaxiso/framework/document.h>
#include <akaxiso/XML/deserializer/document_handler.h>
#include <stack>
#include <vector>

namespace aka2 {


  struct sax_attribute {
    sax_attribute(){}
    sax_attribute(const std::string &name, const std::string &value)
      : name_(name), value_(value) {}
    std::string name_;
    std::string value_;
  };

  typedef std::vector<sax_attribute> sax_attributes;


  struct nsdecl {
    std::string prefix_;
    std::string uri_;
  };

  struct ns_decls {
    typedef std::vector<nsdecl> prefixes;
    ns_decls() :  default_ns_id_(empty_token){}
    prefixes prefixes_;
    id_type default_ns_id_;
  };

  class ns_stack {
  public:
    ns_stack() : depth_(0){}
    void inc_depth();
    const ns_decls& get_current_decls() const;
    void dec_depth();
    bool process_namespace_attribute(const sax_attribute &attr, const nsdecl ** decl);
  private:
    typedef std::stack<ns_decls> decls_stack;
    size_t depth_;
    decls_stack stack_;
  };


  class sax2_adaptor {
  public:
    sax2_adaptor();
    virtual ~sax2_adaptor(){}

    virtual void startElement(const std::string &tagname, sax_attributes &attrs);
    virtual void endElement(const std::string &tagname);
    virtual void characters(const char *chars, const unsigned int length);

    void set_handler(document_handler &handler, prefix_map &pfs) { 
      handler_ = &handler; 
      pfs_ = &pfs;
    }
  private:
    qname create_qname(const std::string &name);
    void process_attributes(const sax_attributes &saxattrs, attribute_values &xattrs);
    prefix_map *pfs_;
    ns_stack ns_;
    document_handler *handler_;
  };

}

#endif
