// -*- c++ -*-
#ifndef AKAXISO_XML_EXPAT_EXPAT_DOCUMENTHANDLER_H__
#define AKAXISO_XML_EXPAT_EXPAT_DOCUMENTHANDLER_H__

#include <akaxiso/configuration.h>
#ifdef USE_EXPAT

#include <akaxiso/framework/document.h>
#include <akaxiso/XML/deserializer/document_handler.h>
#include <akaxiso/XML/deserializer/sax2_adaptor.h>
#include <akaxiso/imported/expat_parser.h>

namespace aka2 {

  class expat_handler : public expat_document_handler {
  public:
    expat_handler();
    virtual ~expat_handler(){}
    
    void set_source_name(const std::string &source_name) {
      handler_.set_source_name(source_name);
    }
    void reset() { handler_.reset(); }
    
    virtual void startElement(const std::string &name, sax_attributes &saxattrs);
    virtual void endElement(const std::string &name);
    virtual void characters(const char *data, int len);

    document get_document();
    std::string encoding_;
  private:
    prefix_map pfs_;
    document_handler handler_;
    sax2_adaptor adaptor_;
  };

}

#endif

#endif

