/* -*- c++ -*- */
#ifndef AKAXISO_XML_XERCES_XERCES_DESERIALIZER_H__
#define AKAXISO_XML_XERCES_XERCES_DESERIALIZER_H__

#include <akaxiso/configuration.h>
#ifdef USE_XERCESC


#include <akaxiso/XML/deserializer/deserializer.h>
#include <xercesc/sax2/SAX2XMLReader.hpp>

namespace aka2 {

  class xerces_deserializer : public deserializer {
  public:
    xerces_deserializer();

    virtual ~xerces_deserializer() {}

    virtual document deserialize(std::istream &istm);
    virtual document deserialize(const char *document);
    virtual document deserialize(const std::string &document);
    virtual document deserialize_stdin();
    virtual document deserialize_file(const std::string &filepath);

  private:
    document deserialize_internal(xercesc::InputSource &src, const std::string &source_name);
  };

} // namespace aka2

#endif

#endif
