#include "xerces_serializer.h"

#ifdef USE_XERCESC

#include "../../exception.h"
#include <xercesc/util/PlatformUtils.hpp> /* {Xerces-C++2.2} */
#include <xercesc/util/XMLString.hpp>

#include <iostream>


using namespace aka2;


void xerces_formatter::set_encoding(const std::string &encoding) {
  xercesc::XMLTransService::Codes resValue;
  out_transcoder_.reset(xercesc::XMLPlatformUtils::fgTransService->
      makeNewTranscoderFor(encoding.c_str(), resValue, 4096));
  if (resValue != xercesc::XMLTransService::Ok) {
    throw aka2::tagged_error("encoding", encoding, "not found", __FILE__, __LINE__);
  }
  in_transcoder_.reset(xercesc::XMLPlatformUtils::fgTransService->makeNewLCPTranscoder());
}

ustring xerces_formatter::lcp_to_ucs2(const std::string &source) {

  XMLCh *converted = in_transcoder_->transcode(source.c_str());
  ustring ret(converted);
  /** Freeing memory allocated in Xerces-C++ lib. */
  xercesc::XMLString::release(&converted);
  return ret;
}

void xerces_formatter::write(const ustring &entity) {
  const int maxBytes = 4096;
  unsigned int charsEaten;

  /** [g++2.96] std::basic_string<unsigned short>::c_str() does not work with g++2.96 STL */
  const XMLCh *toConvert = reinterpret_cast<const XMLCh*>(entity.data());

  XMLByte buffer[maxBytes];

  for (unsigned int offset = 0; offset < entity.size(); ) {
    unsigned int numBytes = out_transcoder_->
      transcodeTo(toConvert + offset,
                  entity.size(),
                  buffer,
                  maxBytes,
                  charsEaten,
                  xercesc::XMLTranscoder::UnRep_RepChar);

    /** For Xerces-C++.
     * Xerces-C++ 2.5 does not recognize 'UTF16' as UTF-16,
     * causing lack of BOM.
     * If BOM not found, add BOM.
     */
    if (bom_ != 0) {
      if (strncmp(bom_->chars_, reinterpret_cast<const char*>(buffer), 2) != 0)
        ostm_->write(bom_->chars_, bom_->length_);
      bom_ = 0;
    }

    ostm_->write(reinterpret_cast<char*>(buffer), numBytes);
    offset = charsEaten;
  }
}

#endif /* USE_XERCESC */
