#include "exception.h"
#include "util/sstream.h"

using namespace aka2;

error::error(const std::string &msg, const char *file, 
	     const unsigned long line) {
  std::ostringstream ostm;
  ostm << msg << '(' << file << ':' << line << ')';
  msg_ = ostm.rdbuf()->str();
}


error::~error() throw() {
}

const char *error::what() const throw() {
  return msg_.c_str();
}


tagged_error::tagged_error(const std::string &caption, 
			   const std::string &tagname,
			   const std::string &msg, 
			   const char *file, const unsigned long line) {
  std::ostringstream ostm;
  ostm << caption + " \"" + tagname + "\":" + msg << " (" << file << ':' << line << ')';
  msg_ = ostm.rdbuf()->str();
}

tagged_error::~tagged_error() throw() {
}
