#include "operators.h"

using namespace aka2;

void ptrmember_op::copy_construct(void *e, const void *src) const { 
  if (is_null(src))
    set_null(e);
  else {
    void *vdest = get_value_op().replicate(dereference(src));
    dereference(e) = vdest;
  }
}

void ptrmember_op::destruct(void *e) const { 
  if (!is_null(e)) {
    void *&val = dereference(e);
    get_value_op().destroy(dereference(e));
    val = 0;
  }
}

bool ptrmember_op::equals(const void *lhs, const void *rhs) const {
  if (is_null(lhs) && is_null(rhs))
    return true;
  else if (is_null(lhs) || is_null(rhs))
    return false;
  return get_value_op().equals(dereference(lhs), dereference(rhs));
}
