/* -*- c++ -*- */
#ifndef AKAXISO_FRAMEWORK_SIMPLETYPE_H__
#define AKAXISO_FRAMEWORK_SIMPLETYPE_H__

/** @file akaxiso/classes/simpletype.h */

#include <akaxiso/framework/builtin.h>
#include <akaxiso/framework/type_registry.h>
#include <akaxiso/framework/member.h>
#include <akaxiso/framework/operators.h>
#include <akaxiso/util/sstream.h>

#include <typeinfo>

namespace aka2 {

  template<class V, class VL>
  struct default_value : public default_op {
    typedef V value_type;

    default_value() : has_default_(false) {}
    virtual ~default_value(){}

    virtual void set_default(const std::string &defval) {
      aka2::isstream istm(defval);
      VL::read_text(&default_, istm, system_preconditions());
      has_default_ = true;
    }

    virtual bool has_default() const {
      return has_default_;
    }

    virtual const void *value() const {
      assert(has_default_);
      return &default_;
    }

  private:
    V default_;
    bool has_default_;
  };


  template<class L>
  struct simpletype_op_dispatcher : public simpletype_op {
  public:
    virtual schematype_id get_schematype() const { return simpletype_id; }
    virtual std::string get_typename() const { return L::get_xmltype(); }
    virtual const attribute_types *get_attribute_types() const { return 0; }
    virtual const any_member *get_anyattr_type() const { return 0; }

    virtual void write_text(const void* elm,
                            std::ostream &ostm,
                            const preconditions &pcd) const {
      L::write_text(elm, ostm, pcd);
    }

    virtual void read_text(void* elm, aka2::isstream &istm,
                           const preconditions &pcd) const {
      L::read_text(elm, istm, pcd);
    }

    virtual void construct(void *e) const {  L::construct(e); }
    virtual void copy_construct(void *e, const void *src) const { L::copy_construct(e, src); }
    virtual void destruct(void *e) const { L::destruct(e); }
    virtual size_t class_size() const { return L::class_size(); }
    virtual bool equals(const void *lhs, const void *rhs) const { return L::equals(lhs, rhs); }
  };


  template<class L, class V>
  struct simpletype_statics {
    static simpletype_op_dispatcher<L> dispatcher_;
    static qname xmltype_;
    static occurrence occ_;
  };

  template<class L, class V>
  simpletype_op_dispatcher<L> simpletype_statics<L, V>::dispatcher_;

  template<class L, class V>
  qname simpletype_statics<L, V>::xmltype_;

  template<class L, class V>
  occurrence simpletype_statics<L, V>::occ_;


  template<class V, class L=xiso::leaf<V> >
  class simpletype : public simpletype_statics<L, V> {
  public:
    virtual ~simpletype(){}
    typedef V value_type;

    static void initialize() {
      system_type_registry().add(L());
    }
    static void uninitialize() {}

    static void write_text(const void *elm, std::ostream &ostm,
                           const preconditions &pfs) {
      const V &value = *reinterpret_cast<const V*>(elm);
      ostm << value;
    }

    static void read_text(void *elm, aka2::isstream &istm,
                          const preconditions &pfs) {
      V &value = *reinterpret_cast<V*>(elm);
      istm >> value;
      if (istm.fail())
        throw error(std::string("Failed to parse simpletype value, \"")
		    + istm.rdbuf()->str() + "\".",
		    __FILE__, __LINE__);
    }


    static void construct(void *e) { new (e) V(); }
    static void copy_construct(void *e, const void *src) {
      new (e) V(*static_cast<const V*>(src));
    }
    static size_t class_size() { return sizeof(V); }
    static void destruct(void *elm) { static_cast<V*>(elm)->~V(); }

    static bool equals(const void *lhs, const void *rhs) {
      return *static_cast<const V*>(lhs) == *static_cast<const V*>(rhs);
    }

    static default_op* create_default_op() { return new default_value<V, L>; }
    static simpletype_op_dispatcher<L> *get_attribute_dispatcher() {
      return &L::dispatcher_;
    }

    static std::string get_xmltype() {
      if (L::xmltype_.empty())
	return typeid(V).name();
      return L::xmltype_.qualified();
    }

  };


  struct  nill_leaf :  public aka2::simpletype<nill, nill_leaf>  {
    static void initialize() {}
    static void uninitialize() {}
    static bool equals(const void *, const void *) {
      return true;
    }
    static void write_text(const void *e, std::ostream &ostm, const preconditions &pcd) { }
    static void read_text(void *e, aka2::isstream &istm, const preconditions &pcd) { }
    static default_op* create_default_op() { return 0; }
  };

} // namespace aka2

#endif
