/* -*- c++ -*- */
#ifndef AKAXISO_EXPAT_PARSER_H__
#define AKAXISO_EXPAT_PARSER_H__

#include <akaxiso/configuration.h>
#ifdef USE_EXPAT

#include <akaxiso/XML/deserializer/sax2_adaptor.h>
#include <akaxiso/imported/expat/expat.h>
#include <akaxiso/imported/tricklib/tricklib.h>

#include <stack>

namespace aka2 {

  struct expat_document_handler {
    virtual void startElement(const std::string &name, sax_attributes &saxattrs) = 0;
    virtual void endElement(const std::string &name) = 0;
    virtual void characters(const XML_Char *data, int len) = 0;
  };


  struct expat_dtd_handler {
    virtual void startDoctypeDeclHandler(const XML_Char *doctypeName,
					 const XML_Char *sysid,
					 const XML_Char *pubid,
					 int has_internal_subset) = 0;
    virtual void endDoctypeDeclHandler() = 0;

    virtual void elementDeclHandler(const XML_Char *name, XML_Content *model) = 0;
    virtual void attlistDeclHandler(const XML_Char *elname,
				    const XML_Char *attname,
				    const XML_Char *att_type,
				    const XML_Char *dflt,
				    int isrequired) = 0;
  };

  class expat_parser {
  public:
    expat_parser();
    void parse_buffer(const char *doc, int len, const std::string &source_name);
    void parse_istream(std::istream &istm, const std::string &source_name);
    void set_document_handler(expat_document_handler &doch) { dochandler_ = &doch; }
    void set_dtd_handler(expat_dtd_handler &dtdh) { dtdhandler_ = &dtdh; }
    void set_base(const std::string &base);

  private:
    static void startElement(void *userData, const XML_Char *name, const XML_Char **atts);
    static void endElement(void *userData, const XML_Char *name);
    static void characters(void *userData, const XML_Char *data, int len);
    static int unknownEncodingHandler(void *encodingHandlerData, 
				      const XML_Char *name, XML_Encoding *info);

    static void elementDeclHandler(void *userData, const XML_Char *name, XML_Content *model);
    static void attlistDeclHandler(void *userData,
				   const XML_Char *elname,
				   const XML_Char *attname,
				   const XML_Char *att_type,
				   const XML_Char *dflt,
				   int isrequired);
    static void startDoctypeDeclHandler(void *userData,
					const XML_Char *doctypeName,
					const XML_Char *sysid,
					const XML_Char *pubid,
					int has_internal_subset);
    static void endDoctypeDeclHandler(void *userData);

    static int externalEntityRefHandler(XML_Parser p,
					const XML_Char *context,
					const XML_Char *base,
					const XML_Char *systemId,
					const XML_Char *publicId);


    expat_document_handler *dochandler_;
    expat_dtd_handler *dtdhandler_;
    void process_attributes(const XML_Char **atts, sax_attributes &attrs);
    XML_Parser create_parser(const char *encoding,
			     expat_document_handler *doch, 
			     expat_dtd_handler *dtdh);
    void free_parser(XML_Parser parser);
    static std::string create_message(XML_Parser parser,
				      const std::string &source_name);
    

    std::string encoding_;
    std::string base_;
#ifdef USE_BABEL
    const std::string &translate_token(const std::string &token);
    babel::bbl_translater<std::string, std::string> token_translator;
    babel::bbl_translater<std::string, std::string> chars_translator;
#endif
    const int buffer_size_;
    std::stack<XML_Parser> parser_stack_;
  };

}

#endif

#endif

