#include "tricklib.h"

#ifdef USE_BABEL

#include "babel.cpp"


namespace babel_util {

  int get_encoding_from_label(const char *label) {
    using namespace babel::base_encoding;
    if (0 == strcasecmp(label, "shiftjis"))
      return sjis;
    if (0 == strcasecmp(label, "jis"))
      return jis;
    if (0 == strcasecmp(label, "iso-2022-jp"))
      return iso2022jp;
    if (0 == strcasecmp(label, "euc-jp"))
      return euc;
    if (0 == strcasecmp(label, "utf-8"))
      return utf8;
    if (0 == strcasecmp(label, "utf-16"))
      return utf16;
    if (0 == strcasecmp(label, "utf-16le"))
      return utf16le;
    if (0 == strcasecmp(label, "utf-16be"))
      return utf16be;
    return unknown;
  }

#ifdef __USING_EUC__
  const int default_encoding_ = babel::base_encoding::euc;
#endif

#ifdef __USING_SJIS__
  const int default_encoding_ = babel::base_encoding::sjis;
#endif

#ifdef __USING_UTF8__
  const int default_encoding_ = babel::base_encoding::utf8;
#endif


}

#endif
