/* -*- c++ -*- */
#ifndef AKAXISO_LIBSELECTION_H__
#define AKAXISO_LIBSELECTION_H__

#ifdef USE_XERCESC
#include <memory.h> /* {BCB6} */
#include <akaxiso/XML/xerces/xerces_serializer.h>
#include <akaxiso/XML/xerces/xerces_deserializer.h>

namespace aka2 {
  typedef xerces_serializer xml_serializer;
  typedef xerces_deserializer xml_deserializer;
}

# define SERIALIZER_TYPES_DECLARED 1
# define DESERIALIZER_TYPES_DECLARED 1

#endif


#ifdef USE_BABEL
# include <akaxiso/XML/babel/babel_serializer.h>
# if !defined(SERIALIZER_TYPES_DECLARED)
# define SERIALIZER_TYPES_DECLARED
namespace aka2 {
  typedef babel_serializer xml_serializer;
}

# endif
#endif

#if !defined(SERIALIZER_TYPES_DECLARED)
# include <akaxiso/XML/serializer/default_serializer.h>
namespace aka2 {
  typedef default_serializer xml_serializer;
}
#endif


#ifdef USE_EXPAT
# include <akaxiso/XML/expat/expat_deserializer.h>
# if !defined(DESERIALIZER_TYPES_DECLARED)
#  define DESERIALIZED_TYPES_DECLARED 1
namespace aka2 {
  typedef expat_deserializer xml_deserializer;
}
# endif
#endif


#endif

