#include <akaxiso/content_model.h>
#include "schema.h"
#include "schema_xiso.h"
#include <akaxiso/util/string_funcs.h>

using namespace xs;

void maxOccursLeaf::write_text(const void *e, std::ostream &ostm,
			       const aka::preconditions &pcd) {
  const long &v = *static_cast<const long*>(e);
  if (v == aka::unbounded)
    ostm << "unbounded";
  else
    ostm << v;
}

void maxOccursLeaf::read_text(void *e, aka2::isstream &istm, 
			      const aka::preconditions &pcd) {
  long &v = *static_cast<long*>(e);
  std::string val = aka::trim(istm.rdbuf()->str());
  if (val == "unbounded") {
    v = aka::unbounded;
    return;
  }
  istm >> v;
  if (istm.fail())
    throw aka::error("failed to parse maxOccurs", __FILE__, __LINE__);
}

void ElementLeaf::model() {
    //      static_typeinfo().set_typename("xs:element");
    member("xs:complexType",
          &xs::Element::complexTypes_, ComplexTypesLeaf(),
          0, 1);
    attribute("name", &xs::Element::name_);
    attribute("type", &xs::Element::type_);
    attribute("ref", &xs::Element::ref_);
    attribute("minOccurs", &xs::Element::minOccurs_).set_default("1");
    attribute("maxOccurs", &xs::Element::maxOccurs_, maxOccursLeaf()).set_default("1");
}

void GlobalElementLeaf::model () {
  //static_typeinfo().set_typename("xs:global_element");
  member("xs:complexType", &xs::GlobalElement::complexTypes_, ComplexTypesLeaf(), 0, 1);
  attribute("name", &xs::GlobalElement::name_);
  attribute("type", &xs::GlobalElement::type_);
}

void xs::define_schemadoc() {
  aka::xmlns("xs", NS_XMLSCHEMA);
  aka::doctype("xs:schema", SchemaLeaf());
}

