/*  -*- c++ -*- */
#ifndef DTD_PROCESSOR_H__
#define DTD_PROCESSOR_H__

#include <akaxiso/akaxiso.h>
#include <akaxiso/util/shared_ptr.h>
#include <akaxiso/schema/schema.h>
#include "registry.h"

class dtd_processor {
public:
  dtd_processor(registry &reg, std::ostream &ostm, bool verbose, bool do_dump);
  int process(const std::string &base, const std::string &filename);
  xs::schema* get_schema();
private: 
  registry &registry_;
  std::ostream *ostm_;
  bool verbose_;
  bool do_dump_;
  xs::schema *schema_;
};

#endif
