/* -*- c++ -*- */
#ifndef preference_h__
#define preference_h__

#include <akaxiso/schema/schema_builtin.h>

namespace osx {

  void instantiate_xiso();

  /** complexType definitions */

  struct container_type {
    /** attributes */
    ::std::string type_;
  };

  struct escape {
    /** attributes */
    ::std::string to_escape_;
    ::std::string escaped_;
  };

  struct format {
    /** attributes */
    ::std::string prefix_;
    ::std::string postfix_;
  };

  struct _namespace {
    /** attributes */
    ::std::string prefix_;
    ::xs::anyURI uri_;
  };

  struct nill_type {
    /** members */
    ::std::string cpp_;
    aka::deep_ptr< ::std::string> leaf_;
    ::std::string array_;
    aka::deep_ptr< ::std::string> array_leaf_;
  };

  struct substitution {
    /** attributes */
    ::std::string original_;
    ::std::string substituted_;
  };

  typedef std::list< ::osx::substitution> substitution_array;

  typedef std::list< ::osx::escape> escape_array;

  typedef std::list< ::osx::_namespace> namespace_array;

  struct type {
    /** members */
    ::std::string cpp_;
    aka::deep_ptr< ::std::string> leaf_;
    ::std::string array_;
    aka::deep_ptr< ::std::string> array_leaf_;
    /** attributes */
    ::std::string name_;
  };

  typedef std::list< ::osx::type> type_array;

  struct types {
    /** members */
    ::osx::type_array type_;
  };

  struct preference {
    /** members */
    ::osx::container_type choice_container_;
    ::osx::container_type array_container_;
    ::osx::format member_format_;
    ::osx::format array_format_;
    ::osx::substitution_array substitution_;
    ::osx::escape_array escape_;
    ::osx::namespace_array namespace_;
    ::std::string nill_type_;
    ::osx::types cpp_builtins_;
    ::osx::types schema_builtins_;
  };


}

/** serialization of "osx:preference". */
void serialize(const ::osx::preference &root, std::ostream &ostm);

#endif // #ifndef preference_h__
