#!/bin/bash

OK_COUNT=0
NG_COUNT=0

SRCDIR=`dirname $0`
if [ -z $SRCDIR ]
then
    SRCDIR=`pwd`
fi


test_parse()
{
    DOC=$1
    if ../osixaka2 $DOC > /dev/null
	then
	echo -n '.'
	OK_COUNT=`expr $OK_COUNT + 1`
    else
	echo "NG($DOC)." 
	NG_COUNT=`expr $NG_COUNT + 1`
    fi
}

test_build()
{
    DOC=$1
    ../osixaka2 ${DOC}.xsd > /dev/null
    if g++ -c -I${SRCDIR}/../.. -DUSE_XERCESC ${DOC}_xiso.cpp > /dev/null 2>&1; then
	echo -n '.'
	OK_COUNT=`expr $OK_COUNT + 1`
    else
	echo "NG($DOC)"
	NG_COUNT=`expr $NG_COUNT + 1`
    fi
}

FILES="phonebook sample sample1 sample1a todo todo1 builtin_array sample osixaka simpletype wsdl XMLSchema"

for FILE in $FILES;
  do
  test_parse ${SRCDIR}/${FILE}.xsd
done

for FILE in $FILES;
  do
  test_build ${SRCDIR}/$FILE
done


TOTAL=`expr $OK_COUNT + $NG_COUNT`
echo
echo
echo "Total : $TOTAL   OK : $OK_COUNT  NG: $NG_COUNT"

if [ $NG_COUNT -gt 0 ]
    then
    exit 1
fi

ls -f *.xml 2> /dev/null

exit 0
