/* -*- c++ -*- */
#include "osixaka.h"

#include <iostream>
#include <iomanip>
#include <fstream>
#include <stdlib.h>

#include "ltg.h"
#include "name_resolver.h"
#include "generator.h"

#include <sys/stat.h>
#include <sys/types.h>

bool test_parse_ok(const ltg::file &f) {
  osixaka osi(std::cerr);
  osi.load_defaults();
  if (osi.deserialize(f.get_filepath()) != 0)
    return false;
  if (osi.process() != 0)
    return false;
  osi.akaxisonize();

  std::string outputpath = f.get_outputpath("./generated");
  mkdir(outputpath.c_str(), 0777);
  osi.generate(outputpath);
  return true;
}

bool test_parse_ng(const ltg::file &f) {
  std::ostringstream ostm;

  try {
    osixaka osi(ostm);
    osi.load_defaults();
    if (osi.deserialize(f.get_filepath()) != 0)
      return true;
    if (osi.process() != 0)
      return true;
    osi.akaxisonize();
    std::string outputpath = f.get_outputpath("./generated");
    mkdir(outputpath.c_str(), 0777); 
    osi.generate(outputpath);
  }
  catch ( ... ) {
    return true;
  }
  return false;
}


int main(int argc, char* argv[]){

  mkdir("./generated", 0777);

  aka::initialize();
  // Initialize XML-Schema Document Classes.
  ltg::instantiate_xiso();
  osixaka::initialize();

  int total = 0;
  int ok = 0;

  aka::document ltgdoc = aka::deserialize_file(argv[1]);
  ltg::root *root = aka::root_cast<ltg::root>(ltgdoc);
  const ltg::tests &tests = root->tests_;

  for (ltg::tests::const_iterator testit = tests.begin();
       testit != tests.end(); ++testit) {
    const ltg::files &fs = testit->files_;
    for (ltg::files::const_iterator fileit = fs.begin();
	 fileit != fs.end(); ++fileit) {
      bool res;
      bool done = false;

      if (fileit->validity_ && (fileit->role_ == "schema")) {
	res = test_parse_ok(*fileit);
	done = true;
      }
      else if (!fileit->validity_ && (fileit->role_ == "schema")) {
	res = test_parse_ng(*fileit);
	done = true;
      }

      if (done) {
	if (res) {
	  ++ok;
	  std::cout << '.' << std::flush;
	}
	else {
	  std::cout << std::endl
		    << "Failure:" << fileit->get_filepath() << std::endl;
	} 
	++total;
      }
    }
  }

  std::cout << std::endl
	    << argv[1] << std::endl
	    << "total: " << total 
	    << "  ok: " << ok << "  fail: " << total - ok << std::endl;

  // Uninitializers.
  aka::uninitialize();
  return 0;
}
