#include <akaxiso/akaxiso.h>
#include <akaxiso/content_model.h>
#include <iostream>
#include <iomanip>


namespace {

  struct chars {
    std::string encoding_;
    std::string text_;
  };

  struct chars_leaf : public aka::sequence<chars, chars_leaf> {
    void model() {
      member("encoding", &chars::encoding_);
      member("text", &chars::text_);
    }
  };

}

void dump_string(const std::string &doc) {

  for (std::string::size_type pos = 0; pos < doc.size(); ++pos)
    std::cout << std::setw(2) << std::setfill('0') << std::hex << ((int)doc[pos] & 0xffUL) << " ";
  std::cout << std::endl;

}



void parse(const std::string &filename, const std::string &encoding) {

#ifdef USE_XERCESC
  {
    std::cout << std::endl
	      << "Using xerces_serializer..." << std::endl
	      << std::endl;
    std::ostringstream ostm;

    aka::xerces_deserializer deserializer;
    aka::document doc = deserializer.deserialize_file(filename);
    
    aka::xerces_serializer ser(encoding);
    ser.serialize(doc, std::cout);

    ser.serialize(doc, ostm);
    std::cout << "Dump..." << std::endl;
    dump_string(ostm.rdbuf()->str());
  }
#endif

#ifdef USE_EXPAT

  {
    std::cout << std::endl
	      << "Using babel translator..." << std::endl
	      << std::endl;

    std::ostringstream ostm;
    aka::expat_deserializer deserializer;
    aka::document doc = deserializer.deserialize_file(filename);
    aka::babel_serializer ser(encoding);
    ser.serialize(doc, std::cout);

    ser.serialize(doc, ostm);
    std::cout << "Dump..." << std::endl;
    dump_string(ostm.rdbuf()->str());
  }

#endif

}


void usage() {
  std::cout << "encoding [filename] [encoding]" << std::endl
            << "  -h : show this usage." << std::endl;
}


int main(int argc, const char* argv[]){
  
  aka::initialize();
  aka::doctype("chars", chars_leaf());

  if (argc != 3) {
    usage();
    return 1;
  }

  parse(argv[1], argv[2]);

  aka::uninitialize();
  return 0;
}
