#include "default_serializer.h"

#include <iostream>

using namespace aka2;

void default_formatter::set_encoding(const std::string &encoding) {
  assert(!"not supported.");
}

ustring default_formatter::lcp_to_ucs2(const std::string &source) {
  ustring ret;
  for (std::string::size_type pos = 0; pos < source.size(); ++pos)
    ret += source.at(pos);
  return ret;
}

void default_formatter::write(const ustring &entity) {
  if (bom_ != 0) {
    ostm_->write(bom_->chars_, bom_->length_);
    bom_ = 0;
  }  
  std::string to_write;
  for (aka2::ustring::size_type pos = 0; pos < entity.size(); ++pos)
    to_write += entity.at(pos);
  ostm_->write(to_write.c_str(), to_write.size());
}

default_serializer::default_serializer()
  : xml_serializer_base("") {
  formatter_ = shared_ptr<formatter_base>(new default_formatter());
}
