/* -*- c++ -*- */
#ifndef AKAXISO2_XML_XERCES_XERCES_DESERIALIZER_H__
#define AKAXISO2_XML_XERCES_XERCES_DESERIALIZER_H__

/**
 * @file akaxiso2/XML/xerces/xerces_deserializer.h
 * @brief XML deserializer by using Xerces-C++ SAX2 parser.
 */

#include <akaxiso2/configuration.h>
#ifdef AKAXISO2_USE_XERCESC


#include <akaxiso2/XML/deserializer/deserializer.h>
#include <xercesc/sax2/SAX2XMLReader.hpp>

namespace aka2 {

  /**
   * @brief XML deserializer class by using Xerces-C++ SAX2 parser.
   */
  class xerces_deserializer : public deserializer {
  public:
    xerces_deserializer();

    virtual ~xerces_deserializer() {}

    virtual document deserialize(std::istream &istm);
    virtual document deserialize(const char *doc);
    virtual document deserialize(const std::string &doc);
    virtual document deserialize_stdin();
    virtual document deserialize_file(const std::string &filename);

  private:
    document deserialize_internal(xercesc::InputSource &src, const std::string &source_name);
  };

} // namespace aka2

#endif

#endif
