#include "schema_builtin_xiso.h"
#include "../framework/preconditions.h"
#include "../framework/namespaces.h"

namespace xs {

//   void QName_leaf::read_text(void *elm, aka2::isstream &istm, 
// 			    const aka::preconditions &pcd) {
//     aka::qname &name = *static_cast<aka::qname*>(elm);
//     std::string rawname;
//     istm >> rawname;
//     name.set(rawname, pcd.get_prefixes());
//   }


  void QName_leaf::read_text(void *elm, aka2::isstream &istm, 
			     const aka::preconditions &pcd) {
    aka::qname &name = *static_cast<aka::qname*>(elm);
    std::string rawname;
    istm >> rawname;
    if (rawname.find_first_of(':') == std::string::npos)
      name.set(pcd.get_prefixes().get_prefix_id(""), rawname); 
    else
      name.set(rawname, pcd.get_prefixes()); 
  }

}

