/* -*- c++ -*- */
#ifndef AKAXISO2_FRAMEWORK_CONTAINER_METHODS_H__
#define AKAXISO2_FRAMEWORK_CONTAINER_METHODS_H__

#include <list>

namespace aka2 {

  template<class C>
  struct sequential {
    typedef TYPENAME C::value_type V;
    V& push(C &c, const V &v) {
      c.push_back(v);
      return c.back();
    }
  };

  template<class C>
  struct associative {
    typedef TYPENAME C::value_type V;
    V& push(C &c, const V &v) {
      std::pair<TYPENAME C::iterator, bool> res = c.insert(v);
      if (!res.second)
	throw error("element is already inserted.", __FILE__, __LINE__);
      return *res.first;
    }
  };
}

#endif

