// -*- c++ -*-
#ifndef AKAXISO2_FRAMEWORK_ITEM_H__
#define AKAXISO2_FRAMEWORK_ITEM_H__

/**
 * @file akaxiso2/framework/item.h 
 * @brief @ref aka_choice element
 */

#include <akaxiso2/framework/element_props.h>
#include <akaxiso2/framework/node_ptr.h>

namespace aka2 {

  struct itemtype : public element_props {
    itemtype() {}
    itemtype(element_op &op) 
      : element_props(op){ }
    bool equals(const void *lhs, const void *rhs) const;
    void set_item_to_default(void *e) const;
  };


  /**
   * @brief element of @ref aka_choice containters. 
   *
   * Akaxiso data model uses STL-compatible containers for @ref aka_choice container, and 
   * the type of container element must be aka2::item.\n
   * Users don't have to use methods of this class,
   * use aka2::item_of<>() and aka2::item_cast<>() instead.\n
   */
  class item {
  public:
    item() : props_(0) {}
    item(void *e, const element_props &props)
      : nodeptr_(node(e, props.op())), props_(&props) {  }
    item(const item &i) 
      : nodeptr_(i.nodeptr_), props_(i.props_) { }
    ~item(){}

    const item& operator=(const item& rhs);
    const qname &get_name() const { return props_->get_name(); }
    node get_node() { return nodeptr_.get_node(); }
    const_node get_node() const { return nodeptr_.get_node(); }
    bool is_element() const { return props_->get_name().local()[0] != '&'; }
    const element_props &get_props() const { return *props_; }
  protected:
    void assign(const item &rhs);
    node_ptr nodeptr_;
    const element_props *props_;
  };


  /**
   * @brief Check tag name of aka2::item.
   * @param i item instance to be checked.
   * @param tagname tag name.
   * @return true if item's tag name is same as tag name parameter, otherwise false.
   */
  bool item_of(const aka2::item &i, const std::string &tagname);
  
  /**
   * @brief Check tag name of aka2::item.
   * @param i item instance to be checked.
   * @return reference of T instance in aka2::item.
   */
  template<class T>
  T& item_cast(aka2::item &i) {
    node nd = i.get_node();
    return *static_cast<T*>(nd.ptr());
  } 
  
  /**
   * @brief const version of tag name check function for aka2::item.
   * @param i item instance to be checked.
   * @return reference of T instance in aka2::item.
   */
  template<class T>
  const T& item_cast(const aka2::item &i) {
    const_node cnd = i.get_node();
    return *static_cast<const T*>(cnd.ptr());
  } 

}


#endif
