#include "membertype.h"
#include "member_cache.h"
#include "namespace_statics.h"
#include "any_op.h"
#include "../util/string_funcs.h"

using namespace aka2;

bool member_type::equals(const void *lhs, const void *rhs) const {
  if (op_->get_schematype() == fixed_id)
    return true;

  const_member_cache  lhscache(lhs, *op_, *mgetter_);
  const_member_cache  rhscache(rhs, *op_, *mgetter_);
  lhscache.prepare();
  rhscache.prepare();
  return op_->equals(lhscache.value(), rhscache.value());
}

void member_type::set_member_to_default(void *e) const {
  member_cache cache(e, *op_, getter());
  cache.prepare(false);
  set_default(cache.value());
  cache.flush();
}

attribute_type::attribute_type(const member_getter *mgetter, const element_op &op) : 
  member_type(mgetter, op), required_(false) {    
  schematype_id id = get_schematype();
  if ((id != simpletype_id) && (id != fixed_id)) {
    std::string message = "attribute " + quote(get_name().qualified())
      + ": Attribute value should be simpleType.";
    throw error(message, __FILE__, __LINE__);
  }
}


attribute_type::attribute_type(const member_getter *mgetter) : 
  member_type(mgetter, wildcard_attributes_op::dispatcher_), required_(false) {    
}


bool attribute_type::is_attribute_default(const void *elm) const {
  if (!is_default_specified()) // @default
    return false;

  const_member_cache cache(elm, *op_, getter());
  cache.prepare();
  return is_default(cache.value());
}

