/* -*- c++ -*- */
/**
 * Babel.
 */

/**
 *
 * -babel-
 * Coded by Wraith	in July 14, 2002.
 *		http://tricklib.com/cxx/ex/babel/babel.h
 // Reference/support
 //		http://tricklib.com/cxx/ex/babel/
 // License
 //		http://tricklib.com/license.htm
 */

#ifndef __BABEL_BABEL_H__
#define __BABEL_BABEL_H__

#include <cassert>


// base-encoding specification.
//#define __UNICODE_CHAR_SIZE_2__
//#define __UNICODE_CHAR_SIZE_4__

// endian specification.
//#define __LITTLE_ENDIAN_COMPUTER__
//#define __BIG_ENDIAN_COMPUTER__

// base-encoding specification.
//#define __USING_ANSI__
//#define __USING_SJIS__
//#define __USING_EUC__
//#define __USING_UTF8__


// default string type specification.
//#define __BBL_STRING_DEFAULT__
//#define __BBL_WSTRING_DEFAULT__

// Strict conversion to use unicode.
#define __BBL_STRICT_TRANSLATE__

// mapping specification
//#define __BBL_USING_STATIC_TABLE__
//#define __BBL_USING_STDMAP_TABLE__


// unicode<-> sjis specification.
//#define __BBL_LOAD_UNICODE_MAP_CP932__
//#define __BBL_LOAD_UNICODE_MAP_UTC__
//#define __BBL_LOAD_UNICODE_MAP_APPLE__


// unicode<-> sjis mapping.
//#define __BBL_USE_UNICODE_MAP_CP932__
//#define __BBL_USE_UNICODE_MAP_UTC__
//#define __BBL_USE_UNICODE_MAP_APPLE__

// to reject implementation.
#define	__BBL_DISABLE_UTF32__	//	UTF-32 is off.


//#define __BBL_USE_SELECTORS__  defined in configuration.h


#	if defined(__BORLANDC__)
#		pragma warn -8027
#	endif


namespace babel {

  /** initialization of moddule. */
  void init_babel();


  // base template of functor, using demi.
  //
  template<class T> class bbl_demi {
  public:
    T value;
    
    bbl_demi() {}
    bbl_demi(const T &X_value) :value(X_value) {}
    bbl_demi(const bbl_demi<T> &X) :value(X.value) {}
    
    operator T& () { return value; }
    operator const T& () const { return value; }
    
    T * operator & () { return &value; }
    const T * operator & () const { return &value; }
    
    T & operator () () { return value; }
    const T & operator () () const { return value; }
  };
  //	cf. http://tricklib.com/cxx/dagger/tips.h
}
#include <string>

// bugbeared.
#if defined(__BABEL_WITH_BUG__)
// use statement hack.
#define __BUG_STATEMENT_HACK__
#include "..¥bugbeard¥bug.h"
#endif	//	defined(__BABEL_WITH_BUG__)

namespace babel {
  typedef std::string bbl_binary;
  typedef std::string bbl_string;
  typedef std::basic_string<WCHAR_T> bbl_wstring;

  inline const bbl_string & binary_to_string(const bbl_binary &X) { return X; }
  inline const bbl_binary & string_to_binary(const bbl_string &X) { return X; }

  typedef	bbl_string	bbl_default_string;


  //terms
  namespace bbl_term {
    extern const WCHAR_T broken_wchar_literal[];
    extern const WCHAR_T empty_wchar_literal[];

    const bbl_string broken_char = "?";  //ANSI chars.
    const bbl_string empty = "";
    const bbl_wstring broken_wchar = broken_wchar_literal; // ansi chars.
    const bbl_wstring wempty = empty_wchar_literal; //L"";
    const bbl_string utf8_FEFF = "¥xEF¥xBB¥xBF";
    const bbl_wstring unicode_bom((bbl_wstring::size_type)1, (bbl_wstring::value_type)0xFEFF);
    const bbl_string babel_version = 
    "information>¥n"
    "¥tmodule>¥tid=babel¥n"
    "¥t¥tname=-babel- ¥n"
    "¥t¥turl=http://tricklib.com/cxx/ex/babel/¥n"
    "¥t¥tversion=beta modified by smoirno@akaxiso project team¥n"
    "¥tauthor>¥tid=wraith¥n"
    "¥t¥tname=Doukeshi¥n"
    "¥t¥turl=http://www.trickpalace.net/¥n"
    "¥t¥tmail=wraith@trickpalace.net¥n";
  
    struct get_broken_char {
      operator const bbl_string &() const { return broken_char; }
      operator const bbl_wstring &() const { return broken_wchar; }
    };
  
    struct get_bom {
      operator const bbl_string &() const { return utf8_FEFF; }
      operator const bbl_wstring &() const { return unicode_bom; }
    };

    struct get_empty {
      operator const bbl_string &() const { return empty; }
      operator const bbl_wstring &() const { return wempty; }
    };
  }

  inline const int get_base_wstring_size() {
    return sizeof(bbl_wstring::value_type);
  }

  namespace base_endian {
    enum {
      unknown,
      little_endian,
      big_endian,
      bi_endian,
    };
  };
  inline const int get_base_endian() {
    using namespace base_endian;
#ifdef	__LITTLE_ENDIAN_COMPUTER__
    return little_endian;
#endif
#ifdef	__BIG_ENDIAN_COMPUTER__
    return big_endian;
#endif
  }
  
  namespace base_encoding {
    enum {
      unknown,
      binary,
      ansi,
      sjis,
      jis,
      euc,
      iso2022jp,
      utf8,
      utf16be,
      utf16le,
      utf32be,
      utf32le,
#ifdef	__LITTLE_ENDIAN_COMPUTER__
      utf16 = utf16le,
      utf32 = utf32le,
#endif
#ifdef	__BIG_ENDIAN_COMPUTER__
      utf16 = utf16be,
      utf32 = utf32be,
#endif
#ifdef	__UNICODE_CHAR_SIZE_2__
      unicode = utf16,
#endif
#ifdef	__UNICODE_CHAR_SIZE_4__
      unicode = utf32,
#endif
    };
  };


  inline const int get_base_encoding() {
    using namespace base_encoding;
#ifdef	__USING_ANSI__
    return ansi;
#endif
#ifdef	__USING_SJIS__
    return sjis;
#endif
#ifdef	__USING_EUC__
    return euc;
#endif
#ifdef	__USING_UTF8__
    return utf8;
#endif
  }


  bbl_binary::size_type get_aspect_position(const bbl_binary &X);

  class analyze_result {
    typedef int value_type;
    const value_type hunch_result;
    const value_type strict_result;
  public:
    analyze_result(const value_type X_hunch_result)
      :hunch_result(X_hunch_result), strict_result(X_hunch_result) { }
    analyze_result(
		   const value_type X_hunch_result,
		   const value_type X_strict_result)
      :hunch_result(X_hunch_result), strict_result(X_strict_result) { }
    const int & get_hunch_result() const { return hunch_result; }
    const int & get_strict_result() const { return strict_result; }
    operator const int &() const { return get_hunch_result(); }
  };
  analyze_result analyze_base_encoding(const bbl_binary &X, const unsigned int max_scan_size = 8192);

  class bbl_smart_base {
  public:
    typedef bbl_smart_base this_type;
  private:
    volatile int ref_count;
  protected:
    bbl_smart_base() :ref_count(0) {}
    virtual ~bbl_smart_base() { assert(0 == ref_count); }

  public:
    void inc_ref() volatile {
      if (NULL != this) {
	++ref_count;
      }
    }
    void dec_ref() volatile {
      if (NULL != this) {
	if (--ref_count <= 0) {
	  assert(0 == ref_count);
	  delete this;
	}
      }
    }
  };
  template<class target_object>
  class bbl_smart_shell {
  public:
    typedef bbl_smart_shell<target_object> this_type;
    typedef target_object	target_type;

  private:
    target_type *value;

  public:
    bbl_smart_shell(target_type *X_value = NULL) :value(X_value) {
      value->inc_ref();
    }
    bbl_smart_shell(const this_type &X) :value(X.value) {
      value->inc_ref();
    }
    ~bbl_smart_shell() {
      value->dec_ref();
    }

    this_type & operator = (target_type *X_value) {
      if (value != X_value) {
	value->dec_ref();
	value = X_value;
	value->inc_ref();
      }
      return *this;
    }
    this_type & operator = (const this_type &X) {
      if (value != X.value) {
	value->dec_ref();
	value = X.value;
	value->inc_ref();
      }
      return *this;
    }

    bool operator == (const this_type &X) const {
      return value == X.value;
    }
    bool operator != (const this_type &X) const {
      return value != X.value;
    }
    bool operator == (const target_type *X_value) const {
      return value == X_value;
    }
    bool operator != (const target_type *X_value) const {
      return value != X_value;
    }

    bool operator ! () const { return !value; }
    operator target_type* () { return value; }
    operator const target_type* () const { return value; }
    target_type& operator*() { return *value; }
    const target_type& operator*() const { return *value; }
    target_type* operator->() { return value; }
    const target_type* operator->() const { return value; }
    bool is_null() const { return NULL == value; }
    bool is_not_null() const { return NULL != value; }
  };

  template<class from_string = bbl_default_string, class to_string = bbl_default_string> class bbl_translater;

  template<class from_string = bbl_default_string, class to_string = bbl_default_string>
  class bbl_translate_engine :public bbl_smart_base {
  public:
    typedef bbl_translate_engine<from_string, to_string> this_type;
    typedef bbl_translater<from_string, to_string> bbl_translater_type;
    typedef from_string		from_string_type;
    typedef to_string		to_string_type;
    friend class bbl_translater<from_string, to_string>;
  protected:
    from_string_type untranslated_buffer;
    to_string_type translated_buffer;
  public:
    virtual void translate() = 0;
    virtual void flush() {
      for(int i = 0, length = untranslated_buffer.length(); i < length; ++i) {
	translated_buffer += bbl_term::get_broken_char();
      }
      untranslated_buffer = bbl_term::get_empty();
    }
    virtual void clear() {
      untranslated_buffer = bbl_term::get_empty();
      translated_buffer = bbl_term::get_empty();
    }

    const to_string_type & ignite(const from_string_type &X) {
      untranslated_buffer = X;
      translate();
      flush();
      return translated_buffer;
    }
  };


  // null translation
  template<class from_string = bbl_default_string, class to_string = bbl_default_string>
  class dull_engine :public bbl_translate_engine<from_string, to_string> {
  public:
    typedef dull_engine<from_string, to_string> this_type;
    typedef	bbl_translate_engine<from_string, to_string> base_type;
    typedef typename base_type::bbl_translater_type	bbl_translater_type;
    typedef from_string						from_string_type;
    typedef to_string						to_string_type;
  private:
    dull_engine() {}
  public:	//to suppress warning for g++.
    ~dull_engine() {}
  protected:
    void translate() { }
    void flush() { this_type::untranslated_buffer = bbl_term::get_empty(); }
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return bbl_term::get_empty(); }
  };
  
  template<class first_engine, class second_engine> class twin_translate_engine;
  
  // Code conversion class.
  template<class from_string, class to_string>
  class bbl_translater {
  public:
    typedef bbl_translater this_type;
    typedef bbl_translate_engine<from_string, to_string> engine_type;
    typedef dull_engine<from_string, to_string> dull_engine_type;
    typedef from_string		from_string_type;
    typedef to_string		to_string_type;

  private:
    bbl_smart_shell<engine_type> engine;
  public:
    bbl_translater(engine_type *X_engine)	:engine(X_engine) { }
    bbl_translater(const bbl_translater &X = dull_engine_type::create())
      :engine(X.engine) { }
    ~bbl_translater() { }

    bbl_translater & operator = (engine_type *X_engine) {
      engine = X_engine;
      return *this;
    }
    bbl_translater & operator = (const bbl_translater &X) {
      engine = X.engine;
      return *this;
    }
    bool operator == (const bbl_translater &X) const {
      return engine == X.engine;
    }
    bool operator != (const bbl_translater &X) const {
      return engine != X.engine;
    }

    this_type & translate(const from_string_type &X) {
      engine->untranslated_buffer += X;
      engine->translate();
      return *this;
    }
    this_type & flush() {
      //engine->translate();
      engine->flush();
      return *this;
    }
    this_type & clear() {
      engine->clear();
      return *this;
    }
    
    this_type & operator = (const from_string_type &X) { return clear().translate(X).flush(); }
    operator const to_string_type & () const { return get_string(); }
    const to_string_type & get_string() const { return engine->translated_buffer;	}
    const char * c_str() const { return get_string().c_str(); }
    const to_string_type pook_buffer() {
      to_string_type buffer = engine->translated_buffer;
      engine->translated_buffer.erase();
      return buffer;
    }
    
    this_type & operator << (const from_string_type &X) { return translate(X); }
    this_type & operator >> (to_string_type &X) {
      X = engine->translated_buffer;
      engine->translated_buffer.erase();
      return *this;
    }
    const to_string_type & operator () (const from_string_type &X) {
      return clear().translate(X).flush().get_string();
    }
  };

  template<class target_string = bbl_default_string>
  class through_engine :public bbl_translate_engine<target_string, target_string> {
  public:
    typedef through_engine<target_string>	this_type;
    typedef	bbl_translate_engine<target_string, target_string> base_type;
    typedef typename base_type::bbl_translater_type	bbl_translater_type;
    typedef typename base_type::from_string_type	from_string_type;
    typedef typename base_type::to_string_type		to_string_type;
  protected:
    through_engine() {}
  protected:
    void translate() {
      this_type::translated_buffer += this_type::untranslated_buffer;
      this_type::untranslated_buffer.erase();
    }
    void flush() { }
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type & ignite(const from_string_type &X) { return X; }
  };
  
  class ansi_to_unicode_engine :public bbl_translate_engine<bbl_string, bbl_wstring> {
  public:
    typedef ansi_to_unicode_engine this_type;
    typedef bbl_translate_engine<bbl_string, bbl_wstring> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    ansi_to_unicode_engine() { }
  protected:
    void translate();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };

  class unicode_to_ansi_engine :public bbl_translate_engine<bbl_wstring, bbl_string> {
  public:
    typedef unicode_to_ansi_engine this_type;
    typedef bbl_translate_engine<bbl_wstring, bbl_string> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    unicode_to_ansi_engine() { }
  protected:
    void translate();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };

  class sjis_to_euc_engine :public bbl_translate_engine<bbl_string, bbl_string> {
  public:
    typedef sjis_to_euc_engine this_type;
    typedef	bbl_translate_engine<bbl_string, bbl_string> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    sjis_to_euc_engine() { }
  protected:
    void translate();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
  class sjis_to_jis_engine :public bbl_translate_engine<bbl_string, bbl_string> {
  public:
    typedef sjis_to_jis_engine this_type;
    typedef	bbl_translate_engine<bbl_string, bbl_string> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    int status;
    sjis_to_jis_engine() :status(0) { }
  protected:
    void translate();
    void flush();
    void clear() {
      base_type::clear();
      status = 0;
    }
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };

#	if defined(__BBL_USE_UNICODE_MAP_CP932__)
  class unicode_to_sjis_cp932_engine;
  typedef unicode_to_sjis_cp932_engine	unicode_to_sjis_engine;
  class sjis_cp932_to_unicode_engine;
  typedef sjis_cp932_to_unicode_engine	sjis_to_unicode_engine;
#	endif
#	if defined(__BBL_USE_UNICODE_MAP_UTC__)
  class unicode_to_sjis_utc_engine;
  typedef unicode_to_sjis_utc_engine		unicode_to_sjis_engine;
  class sjis_utc_to_unicode_engine;
  typedef sjis_utc_to_unicode_engine		sjis_to_unicode_engine;
#	endif
#	if defined(__BBL_USE_UNICODE_MAP_APPLE__)
  class unicode_to_sjis_apple_engine;
  typedef unicode_to_sjis_apple_engine	unicode_to_sjis_engine;
  class sjis_apple_to_unicode_engine
  typedef sjis_apple_to_unicode_engine	sjis_to_unicode_engine;
#	endif

#if	defined(__BBL_STRICT_TRANSLATE__)
  class euc_to_unicode_engine;
  typedef twin_translate_engine<euc_to_unicode_engine, unicode_to_sjis_engine> euc_to_sjis_engine;
#else	//	defined(__BBL_STRICT_TRANSLATE__);
  class euc_to_sjis_engine :public bbl_translate_engine<bbl_string, bbl_string> {
  public:
    typedef euc_to_sjis_engine this_type;
    typedef	bbl_translate_engine<bbl_string, bbl_string> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    euc_to_sjis_engine() { }
  protected:
    void translate();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
#endif	//	defined(__BBL_STRICT_TRANSLATE__);

  class euc_to_jis_engine :public bbl_translate_engine<bbl_string, bbl_string> {
  public:
    typedef euc_to_jis_engine this_type;
    typedef	bbl_translate_engine<bbl_string, bbl_string> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    int status;
    euc_to_jis_engine() :status(0) { }
  protected:
    void translate();
    void flush();
    void clear() {
      base_type::clear();
      status = 0;
    }
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };

  class euc_to_unicode_engine :public bbl_translate_engine<bbl_string, bbl_wstring> {
  public:
    typedef euc_to_unicode_engine this_type;
    typedef bbl_translate_engine<bbl_string, bbl_wstring> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    euc_to_unicode_engine() {}
  protected:
    void translate();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
  class unicode_to_euc_engine :public bbl_translate_engine<bbl_wstring, bbl_string> {
  public:
    typedef unicode_to_euc_engine this_type;
    typedef	bbl_translate_engine<bbl_wstring, bbl_string> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    unicode_to_euc_engine() { }
  protected:
    void translate();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
  
#if	defined(__BBL_STRICT_TRANSLATE__)
  class jis_to_euc_engine;
  typedef twin_translate_engine<jis_to_euc_engine, euc_to_sjis_engine> jis_to_sjis_engine;
#else	//	defined(__BBL_STRICT_TRANSLATE__);
  class jis_to_sjis_engine :public bbl_translate_engine<bbl_string, bbl_string> {
  public:
    typedef jis_to_sjis_engine this_type;
    typedef	bbl_translate_engine<bbl_string, bbl_string> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    int status;
    jis_to_sjis_engine() :status(0) { }
  protected:
    void translate();
    void flush();
    void clear() {
      base_type::clear();
      status = 0;
    }
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
#endif	//  defined(__BBL_STRICT_TRANSLATE__)
  class jis_to_euc_engine :public bbl_translate_engine<bbl_string, bbl_string> {
  public:
    typedef jis_to_euc_engine this_type;
    typedef	bbl_translate_engine<bbl_string, bbl_string> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    int status;
    jis_to_euc_engine() :status(0) { }
  protected:
    void translate();
    void flush();
    void clear() {
      base_type::clear();
      status = 0;
    }
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
  class jis_to_iso2022jp_engine :public bbl_translate_engine<bbl_string, bbl_string> {
  public:
    typedef jis_to_iso2022jp_engine this_type;
    typedef	bbl_translate_engine<bbl_string, bbl_string> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    int from_status;
    int to_status;
    jis_to_iso2022jp_engine() :from_status(0), to_status(0) { }
  protected:
    void translate();
    void flush();
    void clear() {
      base_type::clear();
      from_status = 0;
      to_status = 0;
    }
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
  
#if defined(__BBL_LOAD_UNICODE_MAP_CP932__)
  class sjis_cp932_to_unicode_engine :public bbl_translate_engine<bbl_string, bbl_wstring> {
  public:
    typedef sjis_cp932_to_unicode_engine this_type;
    typedef	bbl_translate_engine<bbl_string, bbl_wstring> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    sjis_cp932_to_unicode_engine() {    }
  protected:
    void translate();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
  class unicode_to_sjis_cp932_engine :public bbl_translate_engine<bbl_wstring, bbl_string> {
  public:
    typedef unicode_to_sjis_cp932_engine this_type;
    typedef	bbl_translate_engine<bbl_wstring, bbl_string> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    unicode_to_sjis_cp932_engine() { }
  protected:
    void translate();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
#endif	//	defined(__BBL_LOAD_UNICODE_MAP_CP932__)

#if defined(__BBL_LOAD_UNICODE_MAP_UTC__)
  class sjis_utc_to_unicode_engine :public bbl_translate_engine<bbl_string, bbl_wstring> {
  public:
    typedef sjis_utc_to_unicode_engine this_type;
    typedef	bbl_translate_engine<bbl_string, bbl_wstring> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    sjis_utc_to_unicode_engine() {
    }
  protected:
    void translate();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
  class unicode_to_sjis_utc_engine :public bbl_translate_engine<bbl_wstring, bbl_string> {
  public:
    typedef unicode_to_sjis_utc_engine this_type;
    typedef	bbl_translate_engine<bbl_wstring, bbl_string> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    unicode_to_sjis_utc_engine() { }
  protected:
    void translate();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
#endif	//	defined(__BBL_LOAD_UNICODE_MAP_UTC__)
  
#if defined(__BBL_LOAD_UNICODE_MAP_APPLE__)
  class sjis_apple_to_unicode_engine :public bbl_translate_engine<bbl_string, bbl_wstring> {
  public:
    typedef sjis_apple_to_unicode_engine this_type;
    typedef	bbl_translate_engine<bbl_string, bbl_wstring> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    sjis_apple_to_unicode_engine() {	}
  protected:
    void translate();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
  class unicode_to_sjis_apple_engine :public bbl_translate_engine<bbl_wstring, bbl_string> {
  public:
    typedef unicode_to_sjis_apple_engine this_type;
    typedef	bbl_translate_engine<bbl_wstring, bbl_string> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    unicode_to_sjis_apple_engine() { }
  protected:
    void translate();
    void flush();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
#endif	//	defined(__BBL_LOAD_UNICODE_MAP_APPLE__)
  
  class unicode_to_utf8_engine :public bbl_translate_engine<bbl_wstring, bbl_string> {
  public:
    typedef unicode_to_utf8_engine this_type;
    typedef	bbl_translate_engine<bbl_wstring, bbl_string> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    unicode_to_utf8_engine() { }
  protected:
    void translate();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
  class utf8_to_unicode_engine :public bbl_translate_engine<bbl_string, bbl_wstring> {
  public:
    typedef utf8_to_unicode_engine this_type;
    typedef	bbl_translate_engine<bbl_string, bbl_wstring> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    utf8_to_unicode_engine() { }
  protected:
    void translate();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
  
  const unsigned int translate_buffer_full_size = 1024;	//	8〜4096
  const unsigned int translate_buffer_size = 1000;			//	translate_buffer_full_size -alpha
  //const int translate_buffer_full_size = 128;		//	8〜4096
  //const int translate_buffer_size = 100;			//	translate_buffer_full_size -alpha

  // composite translation.
  template<class first_engine, class second_engine>
  class twin_translate_engine :public bbl_translate_engine<typename first_engine::from_string_type, typename second_engine::to_string_type> {
  public:
    typedef twin_translate_engine<first_engine, second_engine> this_type;
    typedef first_engine	first_engine_type;
    typedef	second_engine	second_engine_type;
    typedef	bbl_translate_engine<typename first_engine::from_string_type, typename second_engine::to_string_type> base_type;
    typedef typename base_type::bbl_translater_type	bbl_translater_type;
    typedef typename base_type::from_string_type	from_string_type;
    typedef typename base_type::to_string_type		to_string_type;
  protected:
    typename first_engine_type::bbl_translater_type engine1;
    typename second_engine_type::bbl_translater_type engine2;
    
    twin_translate_engine()
      :engine1(first_engine_type::create()),
       engine2(second_engine_type::create()) { }
    
  protected:
    void translate() {
      engine1.translate(this_type::untranslated_buffer);
      this_type::untranslated_buffer.erase();
      engine2.translate(engine1.pook_buffer());
      this_type::translated_buffer += engine2.pook_buffer();
    }
    void flush() {
      engine1.flush();
      
      this_type::untranslated_buffer.erase();
      engine2.translate(engine1.pook_buffer()).flush();
      this_type::translated_buffer += engine2.pook_buffer();
    }
    void clear() {
      base_type::clear();
      engine1.clear();
      engine2.clear();
    }
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) {
      return second_engine_type::ignite(first_engine_type::ignite(X));
    }
  };

  typedef twin_translate_engine<jis_to_euc_engine, euc_to_unicode_engine> jis_to_unicode_engine;
  typedef twin_translate_engine<unicode_to_euc_engine, euc_to_jis_engine> unicode_to_jis_engine;
  typedef twin_translate_engine<sjis_to_unicode_engine, unicode_to_utf8_engine> sjis_to_utf8_engine;
  typedef twin_translate_engine<euc_to_unicode_engine, unicode_to_utf8_engine> euc_to_utf8_engine;
  typedef twin_translate_engine<jis_to_unicode_engine, unicode_to_utf8_engine> jis_to_utf8_engine;
  typedef twin_translate_engine<utf8_to_unicode_engine, unicode_to_sjis_engine> utf8_to_sjis_engine;
  typedef twin_translate_engine<utf8_to_unicode_engine, unicode_to_euc_engine> utf8_to_euc_engine;
  typedef twin_translate_engine<utf8_to_euc_engine, euc_to_jis_engine> utf8_to_jis_engine;

  // conde conversion function (alias)
  const bbl_string (* const sjis_to_euc)(const bbl_string &) = sjis_to_euc_engine::ignite;
  const bbl_string (* const sjis_to_jis)(const bbl_string &) = sjis_to_jis_engine::ignite;
  const bbl_string (* const euc_to_sjis)(const bbl_string &) = euc_to_sjis_engine::ignite;
  const bbl_string (* const euc_to_jis)(const bbl_string &) = euc_to_jis_engine::ignite;
  const bbl_string (* const jis_to_sjis)(const bbl_string &) = jis_to_sjis_engine::ignite;
  const bbl_string (* const jis_to_euc)(const bbl_string &) = jis_to_euc_engine::ignite;
  const bbl_string (* const jis_to_iso2022jp)(const bbl_string &) = jis_to_iso2022jp_engine::ignite;
  const bbl_string (* const sjis_to_utf8)(const bbl_string &) = sjis_to_utf8_engine::ignite;
  const bbl_wstring (* const sjis_to_unicode)(const bbl_string &) = sjis_to_unicode_engine::ignite;
  const bbl_string (* const euc_to_utf8)(const bbl_string &) = euc_to_utf8_engine::ignite;
  const bbl_wstring (* const euc_to_unicode)(const bbl_string &) = euc_to_unicode_engine::ignite;
  const bbl_string (* const jis_to_utf8)(const bbl_string &) = jis_to_utf8_engine::ignite;
  const bbl_wstring (* const jis_to_unicode)(const bbl_string &) = jis_to_unicode_engine::ignite;
  const bbl_string (* const utf8_to_sjis)(const bbl_string &) = utf8_to_sjis_engine::ignite;
  const bbl_string (* const utf8_to_euc)(const bbl_string &) = utf8_to_euc_engine::ignite;
  const bbl_string (* const utf8_to_jis)(const bbl_string &) = utf8_to_jis_engine::ignite;
  const bbl_wstring (* const utf8_to_unicode)(const bbl_string &) = utf8_to_unicode_engine::ignite;
  const bbl_string (* const unicode_to_sjis)(const bbl_wstring &) = unicode_to_sjis_engine::ignite;
  const bbl_string (* const unicode_to_euc)(const bbl_wstring &) = unicode_to_euc_engine::ignite;
  const bbl_string (* const unicode_to_jis)(const bbl_wstring &) = unicode_to_jis_engine::ignite;
  const bbl_string (* const unicode_to_utf8)(const bbl_wstring &) = unicode_to_utf8_engine::ignite;

  class WORD_to_unicode_engine :public bbl_translate_engine<bbl_binary, bbl_wstring> {
  public:
    typedef WORD_to_unicode_engine this_type;
    typedef	bbl_translate_engine<bbl_binary, bbl_wstring> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    WORD_to_unicode_engine() { }
  protected:
    void translate();
    void flush();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
  class unicode_to_WORD_engine :public bbl_translate_engine<bbl_wstring, bbl_binary> {
  public:
    typedef unicode_to_WORD_engine this_type;
    typedef	bbl_translate_engine<bbl_wstring, bbl_binary> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    unicode_to_WORD_engine() { }
  protected:
    void translate();
    void flush();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
  class cross_WORD_to_unicode_engine :public bbl_translate_engine<bbl_binary, bbl_wstring> {
  public:
    typedef cross_WORD_to_unicode_engine this_type;
    typedef	bbl_translate_engine<bbl_binary, bbl_wstring> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    cross_WORD_to_unicode_engine() { }
  protected:
    void translate();
    void flush();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
  class unicode_to_cross_WORD_engine :public bbl_translate_engine<bbl_wstring, bbl_binary> {
  public:
    typedef unicode_to_cross_WORD_engine this_type;
    typedef	bbl_translate_engine<bbl_wstring, bbl_binary> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    unicode_to_cross_WORD_engine() { }
  protected:
    void translate();
    void flush();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };

  const bbl_wstring WORD_to_unicode(const bbl_binary &X);
  const bbl_binary unicode_to_WORD(const bbl_wstring &X);
  const bbl_wstring cross_WORD_to_unicode(const bbl_binary &X);
  const bbl_binary unicode_to_cross_WORD(const bbl_wstring &X);

  inline const unsigned int WORD_cross_endian(const unsigned int &X) {
    assert(X <= 0xFFFF);
    return ((X &0x00FF) *0x100)
      |(X /0x100);
  }

#	if	defined(__BBL_USE_UTF32__)
  class DWORD_to_unicode_engine :public bbl_translate_engine<bbl_binary, bbl_wstring> {
  public:
    typedef DWORD_to_unicode_engine this_type;
    typedef	bbl_translate_engine<bbl_binary, bbl_wstring> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    DWORD_to_unicode_engine() { }
  protected:
    void translate();
    void flush();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
  class unicode_to_DWORD_engine :public bbl_translate_engine<bbl_wstring, bbl_binary> {
  public:
    typedef unicode_to_DWORD_engine this_type;
    typedef	bbl_translate_engine<bbl_wstring, bbl_binary> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    unicode_to_DWORD_engine() { }
  protected:
    void translate();
    void flush();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
  class cross_DWORD_to_unicode_engine :public bbl_translate_engine<bbl_binary, bbl_wstring> {
  public:
    typedef cross_DWORD_to_unicode_engine this_type;
    typedef	bbl_translate_engine<bbl_binary, bbl_wstring> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    cross_DWORD_to_unicode_engine() { }
  protected:
    void translate();
    void flush();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };
  class unicode_to_cross_DWORD_engine :public bbl_translate_engine<bbl_wstring, bbl_binary> {
  public:
    typedef unicode_to_cross_DWORD_engine this_type;
    typedef	bbl_translate_engine<bbl_wstring, bbl_binary> base_type;
    typedef base_type::bbl_translater_type	bbl_translater_type;
    typedef base_type::from_string_type		from_string_type;
    typedef base_type::to_string_type		to_string_type;
  protected:
    unicode_to_cross_DWORD_engine() { }
  protected:
    void translate();
    void flush();
  public:
    static bbl_translater_type create() { return new this_type; }
    static const to_string_type ignite(const from_string_type &X) { return this_type().base_type::ignite(X); }
  };

  const bbl_wstring DWORD_to_unicode(const bbl_binary &X);
  const bbl_binary unicode_to_DWORD(const bbl_wstring &X);
  const bbl_wstring cross_DWORD_to_unicode(const bbl_binary &X);
  const bbl_binary unicode_to_cross_DWORD(const bbl_wstring &X);

  inline const unsigned int DWORD_cross_endian(const unsigned int &X) {
    return (X *0x1000000)
      |((X &0x0000FF00) *0x100)
      |((X &0x00FF0000) /0x100)
      |(X /0x1000000);
  }
#	endif	//defined(__BBL_USE_UTF32__)


#if defined(__BBL_USE_SELECTORS__)
  // translate_to_string-, auto_translate-, translate_to_binary-, manual_translate-
  //
  //	translate_engine get_translate_engine(objective, encoding_known = false) {
  //		switch(objective) {
  //			case input:
  //				if(encoding_known) {
  //					return translate_to_string_engine;
  //				} else {
  //					return auto_translate_engine;
  //				}
  //
  //			case output:
  //				return translate_to_binary_engine;
  //
  //			default:
  //				return manual_translate_engine;
  //		}
  //	}

  template<class from_string = bbl_default_string, class to_string = bbl_default_string>
  class manual_translate_engine :public bbl_translate_engine<from_string, to_string> {
  public:
    typedef manual_translate_engine this_type;
    typedef	bbl_translate_engine<from_string, to_string> base_type;
    typedef typename base_type::bbl_translater_type	bbl_translater_type;
    typedef typename base_type::from_string_type	from_string_type;
    typedef typename base_type::to_string_type		to_string_type;
  protected:
    bbl_translater_type	engine;
    manual_translate_engine(int from_base_encoding, int to_base_encoding = babel::get_base_encoding())
      :engine(this_type::order(from_base_encoding, to_base_encoding)) {}
  protected:
    void translate() {
      engine.translate(this_type::untranslated_buffer);
      this_type::untranslated_buffer.erase();
      this_type::translated_buffer += engine.pook_buffer();
    }
    void flush() {
      engine.flush();
      this_type::untranslated_buffer.erase();
      this_type::translated_buffer += engine.pook_buffer();
    }
    void clear() {
      base_type::clear();
      engine.clear();
    }
  public:
    static bbl_translater_type create(int from_base_encoding, int to_base_encoding = babel::get_base_encoding()) {
      return new this_type(from_base_encoding, to_base_encoding);
    }
    //static const to_string_type ignite(
    //			const from_string_type &X, int from_base_encoding, int to_base_encoding = babel::get_base_encoding()) {
    //		return this_type(from_base_encoding, to_base_encoding).base_type::ignite(X);
    //	}
    static const to_string_type ignite(const from_string_type &X, int from_base_encoding, int to_base_encoding = babel::get_base_encoding());
    static bbl_translater_type order(int from_base_encoding, int to_base_encoding = babel::get_base_encoding());
  };

  //	forwarded declarations for specialized types.
  template<>
  manual_translate_engine<bbl_string, bbl_string>::bbl_translater_type
  manual_translate_engine<bbl_string, bbl_string>::order(int X_from_base_encoding, int X_to_base_encoding);

  template<>
  const bbl_string manual_translate_engine<bbl_string, bbl_string>::ignite(const bbl_string &X, int X_from_base_encoding, int X_to_base_encoding);

  template<>
  manual_translate_engine<bbl_wstring, bbl_string>::bbl_translater_type
  manual_translate_engine<bbl_wstring, bbl_string>::order(int X_from_base_encoding, int X_to_base_encoding);

  template<>
  manual_translate_engine<bbl_string, bbl_wstring>::bbl_translater_type
  manual_translate_engine<bbl_string, bbl_wstring>::order(int X_from_base_encoding, int X_to_base_encoding);

  template<>
  manual_translate_engine<bbl_wstring, bbl_wstring>::bbl_translater_type
  manual_translate_engine<bbl_wstring, bbl_wstring>::order(int X_from_base_encoding, int X_to_base_encoding);

  template<>
  const bbl_wstring manual_translate_engine<bbl_string, bbl_wstring>::ignite(const bbl_string &X, int X_from_base_encoding, int X_to_base_encoding);

  template<>
  const bbl_string manual_translate_engine<bbl_wstring, bbl_string>::ignite(const bbl_wstring &X, int X_from_base_encoding, int X_to_base_encoding);

  template<>
  const bbl_wstring manual_translate_engine<bbl_wstring, bbl_wstring>::ignite(const bbl_wstring &X, int X_from_base_encoding, int X_to_base_encoding);


  template<class string_type = bbl_default_string>
  class translate_to_string_engine :public manual_translate_engine<bbl_binary, string_type> {
    //	This class is identical to manual_translate_engine except that from_string_type 
    // is fixed to bbl_binary.
  public:
    typedef translate_to_string_engine<string_type> this_type;
    typedef	manual_translate_engine<bbl_binary, string_type> parent_type;
    typedef	bbl_translate_engine<bbl_binary, string_type> base_type;
    typedef typename base_type::bbl_translater_type	bbl_translater_type;
    typedef typename base_type::from_string_type		from_string_type;
    typedef typename base_type::to_string_type		to_string_type;
  protected:
    translate_to_string_engine(int from_base_encoding, int to_base_encoding = babel::get_base_encoding())
      :parent_type(from_base_encoding, to_base_encoding) {}
  protected:
  public:
  };


  template<class to_string = bbl_default_string>
  class auto_translate_engine :public translate_to_string_engine<to_string> {
  public:
    typedef auto_translate_engine this_type;
    typedef	translate_to_string_engine<to_string> base_type;
    typedef typename base_type::bbl_translater_type	bbl_translater_type;
    typedef typename base_type::from_string_type		from_string_type;
    typedef typename base_type::to_string_type		to_string_type;
  protected:
    int from_base_encoding, to_base_encoding;
    auto_translate_engine(int X_to_base_encoding = babel::get_base_encoding())
      :base_type(X_to_base_encoding, X_to_base_encoding), from_base_encoding(X_to_base_encoding), to_base_encoding(X_to_base_encoding) {}
  protected:
    void translate() {
      int new_from_base_encoding = analyze_base_encoding(this_type::untranslated_buffer);
      if (from_base_encoding != new_from_base_encoding) {
	from_base_encoding = new_from_base_encoding;
	this_type::engine = this_type::order(from_base_encoding, to_base_encoding);
      }
      this_type::engine.translate(this_type::untranslated_buffer);
      this_type::untranslated_buffer.erase();
      this_type::translated_buffer = this_type::engine.pook_buffer();
    }
  public:
    static bbl_translater_type create(int X_to_base_encoding = babel::get_base_encoding()) {
      return new this_type(X_to_base_encoding);
    }
    static const to_string_type ignite(const from_string_type &X, int X_to_base_encoding = babel::get_base_encoding()) {
      return this_type(X_to_base_encoding).base_type::ignite(X);
    }
  };


  template<class from_string = bbl_default_string, class to_string = bbl_default_string>
  class manual_translate :public bbl_demi<to_string> {
  public:
    manual_translate(const from_string &X, int from_base_encoding, int to_base_encoding = babel::get_base_encoding())
      :bbl_demi<to_string>(manual_translate_engine<from_string, to_string>::ignite(X, from_base_encoding, to_base_encoding)) { }
  };

  template<class to_string = bbl_default_string>
  class translate_to_string :public bbl_demi<to_string> {
  public:
    translate_to_string(const bbl_binary &X, int from_base_encoding, int to_base_encoding = babel::get_base_encoding())
      :bbl_demi<to_string>(translate_to_string_engine<to_string>::ignite(X, from_base_encoding, to_base_encoding)) { }
  };

  template<class to_string = bbl_default_string>
  class auto_translate :public bbl_demi<to_string> {
  public:
    auto_translate(const bbl_binary &X, int to_base_encoding = babel::get_base_encoding())
      :bbl_demi<to_string>(auto_translate_engine<to_string>::ignite(X, analyze_base_encoding(X), to_base_encoding)) { }
  };


  template<class string_type = bbl_default_string>
  class translate_to_binary_engine :public manual_translate_engine<string_type, bbl_binary> {
    //
    //	This class is identical to manual_translate_engine class
    //  except that to_string_type is fixed to bbl_binary.    //
    //
  public:
    typedef translate_to_binary_engine<string_type> this_type;
    typedef	manual_translate_engine<bbl_binary, string_type> parent_type;
    typedef	bbl_translate_engine<bbl_binary, string_type> base_type;
    typedef typename base_type::bbl_translater_type	bbl_translater_type;
    typedef typename base_type::from_string_type		from_string_type;
    typedef typename base_type::to_string_type		to_string_type;
  protected:
    translate_to_binary_engine(int from_base_encoding = babel::get_base_encoding(), int to_base_encoding = babel::get_base_encoding())
      :parent_type(from_base_encoding, to_base_encoding) {}
  protected:
  public:
  };

  inline const bbl_binary translate_to_binary(const bbl_string &X, int X_to_base_encoding, int X_from_base_encoding = babel::get_base_encoding()) {
    return manual_translate_engine<bbl_string, bbl_binary>::ignite(X, X_from_base_encoding, X_to_base_encoding);
  }
  inline const bbl_binary translate_to_binary(const bbl_wstring &X, int X_to_base_encoding, int X_from_base_encoding = babel::base_encoding::unicode) {
    return manual_translate_engine<bbl_wstring, bbl_binary>::ignite(X, X_from_base_encoding, X_to_base_encoding);
  }
#endif	//	defined(__BBL_USE_SELECTORS__)

}	//	namespace babel


#if defined(__BORLANDC__)
#	pragma warn .8027
#endif

#endif	//	__BABEL_BBL_H__

/******************************************************************************
Wraith the Trickster
I'll go with heaven's advantage and fool's wisdom.
******************************************************************************/

