#include "xschemadeserializer.h"
#include <akaxiso2/akaxiso2.h>
#include <iostream>

using namespace osx;

xs::schema *xschemadeserializer::deserialize(const std::string &filepath) {
  aka::document doc;
  try {
    if (verbose_)
      ostm_ << "Parsing " << filepath << "..." << std::flush;
    doc = aka::deserialize_file(filepath);
    if (verbose_)
      ostm_ << "done." << std::endl;
  }
  catch (const std::exception &e) {
    ostm_ << e.what() << std::endl;
    ostm_ << "Unsupported features or wrong grammar found in schema document." << std::endl
	   << "Aborting..." << std::endl;
    return 0;
  }
  catch ( ... ) {
    ostm_ << "Unhandled deserialize error detected.  Aborting..." << std::endl;
    return 0;
  }
  return aka::adopt_root<xs::schema>(doc);
}
