/* -*- c++ -*- */
#ifndef AKAXISO2_AKAXISO2_H__
#define AKAXISO2_AKAXISO2_H__

/**
 * @file akaxiso2/akaxiso2.h
 * @brief Akaxiso library initializer/uninitializer
 */

#include <akaxiso2/configuration.h>
#include <akaxiso2/util/deep_ptr.h>
#include <akaxiso2/framework/namespaces.h>
#include <akaxiso2/framework/any.h>
#include <akaxiso2/libselection.h>

#include <akaxiso2/builtin/builtin.h>
#include <akaxiso2/builtin/schema_builtin.h>

namespace aka2 {

  /**
   * @brief Initializer of akaxiso library.
   *
   * Initialize akaxiso library.\n
   * xercesc::XMLPlatformUtils::Initialize() is called if you enable Xerces-C++.
   */
  void initialize();

  /** 
   * @brief Uninitializer of akaxiso library.
   *
   * Release system resources.\n
   * xercesc::XMLPlatformUtils::Terminate() will be called if you enable Xerces-C++. 
   */
  void uninitialize();
}

#endif /* AKAXISO2_AKAXISO2_H__ */
