#include <akaxiso2/akaxiso2.h>
#include <akaxiso2/content_model.h>

#include <iostream>

struct string_operator : aka::complement_operator {
  virtual void reset_for_new_document(void *e) const {
    std::string *str = static_cast<std::string*>(e);
    *str = "";
  }
};


struct root {
  std::string value_;
};

struct value_leaf : aka::simpletype<std::string, value_leaf> {
  static void read_text(void *e, const std::string &entity, 
			aka::entity_complements &ecomps) {
    std::string &read_value = aka::get_complement<std::string>(ecomps, "value_leaf");
    read_value = entity;
    *static_cast<std::string*>(e) = entity;
  }
};


struct root_leaf : aka::sequence<root, root_leaf> {
  void model() {
    member("value", &root::value_, value_leaf());
  }
};


int main() {
  aka::initialize();
  aka::doctype("custom", root_leaf());

  root rt;
  rt.value_ = "test";

  std::ostringstream ostm;
  aka::xml_serializer ser;
  ser.serialize(rt, "custom", ostm);
  std::cout << ostm.str();


  aka::xml_deserializer deser;
  aka::entity_complements ecomps;
  std::string saved_value;
  ecomps.add_complement("value_leaf", saved_value, new string_operator());
  
  deser.set_entity_complements(ecomps);
  deser.deserialize(ostm.str());

  std::cout << "Saved value : " << saved_value << std::endl;

}
