/* -*- c++ -*- */
#ifndef osx_h__
#define osx_h__


#include <akaxiso2/builtin/builtin.h>
#include <akaxiso2/builtin/schema_builtin.h>


namespace osx {

  /** complexType definitions */

  struct array_type {
    /** attributes */
    ::std::string container_;
    ::std::string prefix_;
    ::std::string suffix_;
  };

  typedef std::list< ::osx::array_type> array_type_array;

  struct primitive {
    /** members */
    aka::deep_ptr< ::xs::token> typedef_;
    aka::deep_ptr< ::xs::token> leaf_;
  };

  struct builtin_array {
    /** members */
    ::osx::primitive primitive_;
    /** attributes */
    ::std::string name_;
  };

  typedef std::list< ::osx::builtin_array> builtin_array_array;

  struct type {
    /** members */
    ::osx::primitive primitive_;
    aka::deep_ptr< ::osx::builtin_array> array_;
    /** attributes */
    ::std::string name_;
  };

  typedef std::list< ::osx::type> type_array;

  struct builtins {
    /** members */
    ::osx::type_array type_;
  };

  typedef std::list< ::osx::builtins> builtins_array;

  struct container_type {
    /** attributes */
    ::std::string container_;
  };

  typedef std::list< ::osx::container_type> container_type_array;

  struct include {
    ::std::string value_;
    /** attributes */
    bool system_;
  };

  struct _namespace {
    /** attributes */
    ::std::string prefix_;
    ::xs::anyURI uri_;
  };

  typedef std::list<aka::item> directives_choice;

  struct directives {
    /** members */
    ::osx::directives_choice c0_;
  };

  typedef std::list< ::osx::directives> directives_array;

  struct escape {
    /** attributes */
    ::std::string to_escape_;
    ::std::string escaped_;
  };

  typedef std::list< ::osx::escape> escape_array;

  struct escapes {
    /** members */
    ::osx::escape_array escape_;
  };

  typedef std::list< ::osx::escapes> escapes_array;

  struct member_type {
    /** attributes */
    ::std::string prefix_;
    ::std::string suffix_;
  };

  struct simplecontent_value_name {
    /** attributes */
    ::std::string valuename_;
  };

  struct format {
    /** members */
    ::osx::member_type member_;
    ::osx::array_type array_;
    ::osx::container_type choice_;
    ::osx::simplecontent_value_name simplecontent_;
    ::osx::member_type particle_item_;
  };

  typedef std::list< ::osx::format> format_array;

  struct resolve {
    ::std::string value_;
    /** attributes */
    ::std::string name_;
  };

  typedef std::list<aka::item> imports_choice;

  struct imports {
    /** members */
    ::osx::imports_choice c0_;
  };

  typedef std::list< ::osx::imports> imports_array;

  typedef std::list< ::osx::include> include_array;

  struct internal {
    /** members */
    ::osx::builtins builtins_;
    ::osx::imports imports_;
  };

  typedef std::list< ::osx::internal> internal_array;

  typedef std::list< ::osx::member_type> member_type_array;

  struct substitution {
    /** attributes */
    ::std::string original_;
    ::std::string substituted_;
  };

  typedef std::list< ::osx::substitution> substitution_array;

  struct substitutions {
    /** members */
    ::osx::substitution_array substitution_;
  };

  struct preference {
    /** members */
    ::osx::format format_;
    ::osx::substitutions substitutions_;
    ::osx::escapes escapes_;
    ::osx::directives directives_;
    aka::deep_ptr< ::osx::internal> internal_;
  };

  typedef std::list< ::osx::preference> preference_array;

  typedef std::list< ::osx::resolve> resolve_array;

  typedef std::list< ::osx::simplecontent_value_name> simplecontent_value_name_array;

  typedef std::list< ::osx::substitutions> substitutions_array;

  typedef std::list< ::osx::primitive> primitive_array;


}

#endif // #ifndef osx_h__
