#include "xschemadeserializer.h"
#include <akaxiso2/akaxiso2.h>
#include "serializer.h"
#include <iostream>

using namespace osx;

xs::schema *xschemadeserializer::deserialize(const std::string &filepath) {
  aka::document doc;
  try {
    if (verbose_)
      ostm_ << "Parsing " << filepath << "..." << std::flush;
    doc = aka::deserialize_file(filepath);
    if (verbose_)
      ostm_ << "done." << std::endl;
  }
  catch (const std::exception &e) {
    ostm_ << e.what() << std::endl;
    ostm_ << "Parsing XML document failed because of no-file, unsupported features, or wrong grammar." << std::endl
	   << "Aborting..." << std::endl;
    return 0;
  }
  catch ( ... ) {
    ostm_ << "Unhandled deserialize error detected.  Aborting..." << std::endl;
    return 0;
  }
  return aka::adopt_root<xs::schema>(doc);
}
