#include "fixed_handler.h"
#include "../../util/string_funcs.h"
#include "simpletype_handler.h"
#include <sstream>

using namespace aka2;

fixed_handler::fixed_handler(void *e, const fixed_op &fop,
			     int depth, 
			     const qname& tagname, const element_props &props,
			     parser_context &context) 
  : handler(false, depth, props, context), e_(e), fop_(fop), tagname_(tagname)  {

  assert((props.get_schematype() == fixed_id) || (props.get_schematype() == array_id));

  if (e_ != 0) {
    fop_.get_value_op().destruct(e_);
    fop_.get_value_op().construct(e_);
  }
}

validation_result fixed_handler::query_element(const qname &tagname, const attribute_values &attrs) {
  assert(!"Must not be called.");
  return invalid;
}

validation_result fixed_handler::query_next(const qname &tagname, const attribute_values &attrs) {
  assert(!"Must not be called.");
  return invalid;
}

bool fixed_handler::parse_entity(const pstring &entity) {
  if (!props_.is_fixed_string(entity, context_.get_entity_complements())) {
    std::ostringstream message;
    message << "Wrong fixed value. expected: \"";
    props_.write_fixed_string(message, context_.get_entity_complements());
    message << "\" actual: " << quote(context_.to_lcp(entity)) << ".";
    throw error(message.str(), __FILE__, __LINE__);
  }

  if (e_ != 0) {
    simpletype_handler shandler(e_, fop_.get_value_op(), 
				depth_, 
				props_, 
				context_);
    shandler.parse_entity(entity);
  }
  return true;
}

validation_result fixed_handler::end_element(const qname &tagname) {
  return ok;
}

node fixed_handler::get_node() {
  return node(e_, fop_);
}

void fixed_handler::receive_child(const node &child) {
  assert(!"Must not be called.");
}

bool fixed_handler::can_skip() {
  assert(!"Must not be called.");
  return false;
}

void fixed_handler::abort() {
}
