/* -*- c++ -*- */
#include "serializer.h"
#include "../../framework/member_cache.h"
#include "../../framework/any.h"
#include "../../framework/any_op.h"
#include "../../framework/namespace_statics.h"
#include "../../framework/operators.h"
#include "../../framework/literal.h"
#include "../../framework/entity_complements.h"
#include "../../transcoders/encoding_name.h"

using namespace aka2;

serializer::serializer(int tab, const std::string &encoding, transcoder_factory create)
  : indent_str_(tab, ' '), formatter_(create), encoding_(encoding) {
  if (encoding_.empty())
    encoding_ = get_default_encoding();
  ecomp_ = system_entity_complements_clone(true, create);
}

serializer::~serializer() {
  if (ecomp_)
    delete ecomp_;
}

void serializer::using_prefix(const std::string &prefix) {
  id_type id = get_prefix_id(prefix);
  nsids_.push_back(id);
}

void serializer::using_uri(const std::string &uri) {
  id_type id = get_namespace_id(uri);
  nsids_.push_back(id);
}

void serializer::default_ns_prefix(const std::string &prefix) {
  
  pstring uni_prefix = ecomp_->to_pivot(prefix);
  id_type id = ecomp_->get_prefixes().get_prefix_id(uni_prefix);
  const pstring &uri = g_namespaces_.get_namespace_uri(id);
  ecomp_->get_prefixes().assign_prefix(pstring(), uri);
}

void serializer::default_ns_uri(const std::string &uri) {
  pstring uni_uri = ecomp_->to_pivot(uri);
  ecomp_->get_prefixes().assign_prefix(pstring(), uni_uri);
}

void serializer::new_line() {
  pstring line = literal::new_line();
  for (int i = indent_; i != 0; --i)
    line.append(indent_str_);
  formatter_.write_uni(line.data(), line.size());
}

void serializer::inc_ns_depth() {
  if (ns_stack_.empty()) {
    ns_set new_set;
    new_set.insert(empty_token); // empty prefix and "xml" prefix is XML-instrinsic prefixes.
    new_set.insert(xml_ns_token);
    ns_stack_.push(new_set); // push empty one.
  }
  else {
    const ns_set &nsset = ns_stack_.top();
    ns_stack_.push(nsset);
  }
}

void serializer::dec_ns_depth() {
  ns_stack_.pop();
}

bool serializer::is_new_ns(id_type id) const {
  for (ids::const_iterator it = nsids_.begin(); it != nsids_.end();
       ++it) {
    if (*it == id)
      return false;
  }

  const ns_set &nsset = ns_stack_.top();
  return ns_set::const_iterator(nsset.find(id)) == nsset.end();
}

void serializer::use_temp_nsdecl(id_type id) {
  assert(is_new_ns(id));
  ns_set &nsset = ns_stack_.top();
  nsset.insert(id);
}

void serializer::prepare(std::ostream &ostm) {
  formatter_.prepare(ostm, encoding_);
  indent_ = 0;
  is_root_ = true;
}

void serializer::finish() {
  formatter_.finish();
}
